/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftModeled;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticDoor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticDoorBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPneumaticDoor
extends BlockPneumaticCraftModeled {
    private static final PropertyBool TOP_DOOR = PropertyBool.func_177716_a((String)"top_door");
    private static final PropertyEnum<DoorState> DOOR_STATE = PropertyEnum.func_177709_a((String)"door_state", DoorState.class);
    public boolean isTrackingPlayerEye;
    private int thickness = 13;

    BlockPneumaticDoor() {
        super(Material.field_151573_f, "pneumatic_door");
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TOP_DOOR, ROTATION, DOOR_STATE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)TOP_DOOR, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) + ((Boolean)state.func_177229_b((IProperty)TOP_DOOR) != false ? 8 : 0);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = PneumaticCraftUtils.getTileEntitySafely(worldIn, pos);
        if (te instanceof TileEntityPneumaticDoor) {
            TileEntityPneumaticDoor teDoor = (TileEntityPneumaticDoor)te;
            if (teDoor.rotationAngle == 90.0f) {
                EnumFacing originalRotation = (EnumFacing)state.func_177229_b((IProperty)ROTATION);
                if (originalRotation != EnumFacing.UP && originalRotation != EnumFacing.DOWN) {
                    EnumFacing facing = teDoor.rightGoing ? originalRotation.func_176746_e() : originalRotation.func_176735_f();
                    state = state.func_177226_a((IProperty)ROTATION, (Comparable)facing);
                }
                state = state.func_177226_a(DOOR_STATE, (Comparable)((Object)DoorState.OPEN));
            } else if (teDoor.rotationAngle == 0.0f) {
                state = state.func_177226_a(DOOR_STATE, (Comparable)((Object)DoorState.CLOSED));
            } else if (teDoor.rotationAngle > 0.0f) {
                state = state.func_177226_a(DOOR_STATE, (Comparable)((Object)DoorState.MOVING));
            }
        }
        return state;
    }

    public static boolean isTopDoor(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TOP_DOOR);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        if (this.isTrackingPlayerEye) {
            return field_185505_j;
        }
        float xMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float zMax = 1.0f;
        TileEntity te = blockAccess.func_175625_s(pos);
        EnumFacing rotation = (EnumFacing)state.func_177229_b((IProperty)ROTATION);
        if (te instanceof TileEntityPneumaticDoor) {
            TileEntityPneumaticDoor door = (TileEntityPneumaticDoor)te;
            float cosinus = (float)this.thickness / 16.0f - MathHelper.func_76126_a((float)((float)Math.toRadians(door.rotationAngle))) * (float)this.thickness / 16.0f;
            float sinus = (float)this.thickness / 16.0f - MathHelper.func_76134_b((float)((float)Math.toRadians(door.rotationAngle))) * (float)this.thickness / 16.0f;
            if (door.rightGoing) {
                switch (rotation) {
                    case NORTH: {
                        zMin = cosinus;
                        xMax = 1.0f - sinus;
                        break;
                    }
                    case WEST: {
                        xMin = cosinus;
                        zMin = sinus;
                        break;
                    }
                    case SOUTH: {
                        zMax = 1.0f - cosinus;
                        xMin = sinus;
                        break;
                    }
                    case EAST: {
                        xMax = 1.0f - cosinus;
                        zMax = 1.0f - sinus;
                    }
                }
            } else {
                switch (rotation) {
                    case NORTH: {
                        zMin = cosinus;
                        xMin = sinus;
                        break;
                    }
                    case WEST: {
                        xMin = cosinus;
                        zMax = 1.0f - sinus;
                        break;
                    }
                    case SOUTH: {
                        zMax = 1.0f - cosinus;
                        xMax = 1.0f - sinus;
                        break;
                    }
                    case EAST: {
                        xMax = 1.0f - cosinus;
                        zMin = sinus;
                    }
                }
            }
        }
        boolean topDoor = (Boolean)state.func_177229_b((IProperty)TOP_DOOR);
        return new AxisAlignedBB((double)xMin, topDoor ? -1.0 : 0.0, (double)zMin, (double)xMax, topDoor ? 1.0 : 2.0, (double)zMax);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        this.thickness = 15;
        AxisAlignedBB aabb = this.func_185496_a(blockState, worldIn, pos);
        this.thickness = 13;
        return aabb;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return (Boolean)state.func_177229_b((IProperty)TOP_DOOR) == false && super.canRenderInLayer(state, layer);
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityPneumaticDoor.class;
    }

    public boolean func_176196_c(World par1World, BlockPos pos) {
        return super.func_176196_c(par1World, pos) && par1World.func_175623_d(pos.func_177972_a(EnumFacing.UP));
    }

    @Override
    public void func_180633_a(World par1World, BlockPos pos, IBlockState state, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        super.func_180633_a(par1World, pos, state, par5EntityLiving, par6ItemStack);
        par1World.func_180501_a(pos.func_177972_a(EnumFacing.UP), par1World.func_180495_p(pos).func_177226_a((IProperty)TOP_DOOR, (Comparable)Boolean.valueOf(true)), 3);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return BlockPneumaticDoor.isTopDoor(state) ? Items.field_190931_a : super.func_180660_a(state, rand, fortune);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos posDown = pos.func_177977_b();
        BlockPos posUp = pos.func_177984_a();
        if (player.field_71075_bZ.field_75098_d && BlockPneumaticDoor.isTopDoor(state) && worldIn.func_180495_p(posDown).func_177230_c() == this) {
            worldIn.func_175698_g(posDown);
        }
        if (!BlockPneumaticDoor.isTopDoor(state) && worldIn.func_180495_p(posUp).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(posUp);
        }
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public boolean rotateBlock(World world, EntityPlayer player, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        if (BlockPneumaticDoor.isTopDoor(state)) {
            return this.rotateBlock(world, player, pos.func_177972_a(EnumFacing.DOWN), face);
        }
        super.rotateBlock(world, player, pos, face);
        IBlockState newState = world.func_180495_p(pos);
        world.func_180501_a(pos.func_177972_a(EnumFacing.UP), newState.func_177226_a((IProperty)TOP_DOOR, (Comparable)Boolean.valueOf(true)), 3);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityPneumaticDoor) {
            ((TileEntityPneumaticDoor)te).rightGoing = true;
            ((TileEntityPneumaticDoor)te).setRotationAngle(0.0f);
            TileEntity topDoor = world.func_175625_s(pos.func_177972_a(EnumFacing.UP));
            if (topDoor instanceof TileEntityPneumaticDoor) {
                ((TileEntityPneumaticDoor)topDoor).sendDescriptionPacket();
            }
        }
        return true;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float par7, float par8, float par9) {
        TileEntityPneumaticDoorBase doorBase = this.getDoorBase(world, pos);
        if (!world.field_72995_K && doorBase != null && doorBase.redstoneMode == 2 && doorBase.getPressure() >= 2.0f && hand == EnumHand.MAIN_HAND) {
            doorBase.setOpening(!doorBase.isOpening());
            doorBase.setNeighborOpening(doorBase.isOpening());
            return true;
        }
        return false;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (BlockPneumaticDoor.isTopDoor(state)) {
            BlockPos lowerPos = pos.func_177972_a(EnumFacing.DOWN);
            if (world.func_180495_p(lowerPos).func_177230_c() == Blockss.PNEUMATIC_DOOR) {
                this.func_176226_b(world, lowerPos, world.func_180495_p(lowerPos), 0);
            }
            world.func_175698_g(lowerPos);
        } else {
            world.func_175698_g(pos.func_177972_a(EnumFacing.UP));
        }
        super.func_180663_b(world, pos, state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return BlockPneumaticDoor.isTopDoor(state) ? 0 : 1;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        boolean powered;
        boolean bl = powered = world.func_175687_A(pos) > 0;
        if (!powered) {
            powered = world.func_175687_A(pos.func_177972_a(BlockPneumaticDoor.isTopDoor(state) ? EnumFacing.DOWN : EnumFacing.UP)) > 0;
        }
        TileEntityPneumaticDoorBase doorBase = this.getDoorBase(world, pos);
        if (!world.field_72995_K && doorBase != null && doorBase.getPressure() >= 2.0f && powered != doorBase.wasPowered) {
            doorBase.wasPowered = powered;
            doorBase.setOpening(powered);
        }
    }

    private TileEntityPneumaticDoorBase getDoorBase(World world, BlockPos pos) {
        TileEntityPneumaticDoorBase door;
        TileEntityPneumaticDoorBase door2;
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return null;
        }
        if (!BlockPneumaticDoor.isTopDoor(world.func_180495_p(pos))) {
            return this.getDoorBase(world, pos.func_177972_a(EnumFacing.UP));
        }
        EnumFacing dir = this.getRotation((IBlockAccess)world, pos);
        if (dir.func_176740_k() == EnumFacing.Axis.Y) {
            return null;
        }
        TileEntity te1 = world.func_175625_s(pos.func_177972_a(dir.func_176746_e()));
        if (te1 instanceof TileEntityPneumaticDoorBase && (door2 = (TileEntityPneumaticDoorBase)te1).getRotation() == dir.func_176735_f()) {
            return door2;
        }
        TileEntity te2 = world.func_175625_s(pos.func_177972_a(dir.func_176735_f()));
        if (te2 instanceof TileEntityPneumaticDoorBase && (door = (TileEntityPneumaticDoorBase)te2).getRotation() == dir.func_176746_e()) {
            return door;
        }
        return null;
    }

    public static enum DoorState implements IStringSerializable
    {
        CLOSED("closed"),
        MOVING("moving"),
        OPEN("open");

        private final String name;

        private DoorState(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

