/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.pneumaticHelmet.GuiHelmetMainOptions;
import me.desht.pneumaticcraft.client.gui.pneumaticHelmet.GuiHelmetMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MainHelmetHandler
implements IUpgradeRenderHandler {
    private GuiAnimatedStat powerStat;
    public GuiAnimatedStat testMessageStat;
    private int powerStatX;
    private int powerStatY;
    private boolean powerStatLeftSided;
    public int messagesStatX;
    public int messagesStatY;
    public boolean messagesStatLeftSided;

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getUpgradeName() {
        return "coreComponents";
    }

    @Override
    public void initConfig() {
        this.powerStatX = ConfigHandler.helmetOptions.powerX;
        this.powerStatY = ConfigHandler.helmetOptions.powerY;
        this.powerStatLeftSided = ConfigHandler.helmetOptions.powerLeft;
        this.messagesStatX = ConfigHandler.helmetOptions.messageX;
        this.messagesStatY = ConfigHandler.helmetOptions.messageY;
        this.messagesStatLeftSided = ConfigHandler.helmetOptions.messageLeft;
    }

    @Override
    public void saveToConfig() {
        if (this.powerStat != null) {
            ConfigHandler.helmetOptions.powerX = this.powerStatX = this.powerStat.getBaseX();
            ConfigHandler.helmetOptions.powerY = this.powerStatY = this.powerStat.getBaseY();
            ConfigHandler.helmetOptions.powerLeft = this.powerStatLeftSided = this.powerStat.isLeftSided();
        }
        if (this.testMessageStat != null) {
            ConfigHandler.helmetOptions.messageX = this.messagesStatX = this.testMessageStat.getBaseX();
            ConfigHandler.helmetOptions.messageY = this.messagesStatY = this.testMessageStat.getBaseY();
            ConfigHandler.helmetOptions.messageLeft = this.messagesStatLeftSided = this.testMessageStat.isLeftSided();
        }
        ConfigHandler.sync();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update(EntityPlayer player, int rangeUpgrades) {
        List<String> l = Arrays.stream(UpgradeRenderHandlerList.ARMOR_SLOTS).map(slot -> this.getPressureStr(player, (EntityEquipmentSlot)slot)).collect(Collectors.toList());
        this.powerStat.setText(l);
    }

    private String getPressureStr(EntityPlayer player, EntityEquipmentSlot slot) {
        if (!(player.func_184582_a(slot).func_77973_b() instanceof ItemPneumaticArmor)) {
            return "-";
        }
        float pressure = CommonHUDHandler.getHandlerForPlayer((EntityPlayer)player).armorPressure[slot.func_188454_b()];
        TextFormatting colour = pressure < 0.5f ? TextFormatting.RED : (pressure < 2.0f ? TextFormatting.GOLD : (pressure < 4.0f ? TextFormatting.YELLOW : TextFormatting.GREEN));
        return colour.toString() + String.format("%5.2f", Float.valueOf(pressure));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render3D(float partialTicks) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render2D(float partialTicks, boolean helmetEnabled) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.powerStat == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ScaledResolution sr = new ScaledResolution(minecraft);
            this.powerStat = new GuiAnimatedStat(null, "", "", this.powerStatX != -1 ? this.powerStatX : sr.func_78326_a() - 2, this.powerStatY, 0x3000AA00, null, this.powerStatLeftSided);
            this.powerStat.setLineSpacing(15);
            this.powerStat.setWidgetOffsets(-18, 0);
            for (EntityEquipmentSlot slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                GuiButtonSpecial pressureButton = new GuiButtonSpecial(-1, 0, 5 + (3 - slot.func_188454_b()) * 15, 18, 18, "");
                ItemStack stack = GuiHelmetMainScreen.ARMOR_STACKS[slot.func_188454_b()];
                pressureButton.setVisible(false);
                pressureButton.setRenderStacks(stack);
                this.powerStat.addWidget(pressureButton);
            }
            this.powerStat.setMinDimensionsAndReset(0, 0);
            this.powerStat.openWindow();
        }
        return this.powerStat;
    }

    @Override
    public Item[] getRequiredUpgrades() {
        return new Item[0];
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.powerStat = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOptionPage getGuiOptionsPage() {
        return new GuiHelmetMainOptions(this);
    }

    @Override
    public float getMinimumPressure() {
        return -1.0f;
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot() {
        return EntityEquipmentSlot.HEAD;
    }
}

