/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;
import sonar.core.SonarCore;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.IItemEnergyHandler;
import sonar.core.api.energy.ITileEnergyHandler;
import sonar.core.api.utils.ActionType;
import sonar.core.handlers.energy.EnergyStorageWrapper;
import sonar.core.handlers.energy.EnumEnergyWrapperType;
import sonar.core.handlers.energy.IEnergyHandler;
import sonar.core.handlers.energy.IEnergyTransferProxy;
import sonar.core.handlers.energy.ItemHandlingWrapper;
import sonar.core.handlers.energy.TileHandlingWrapper;

public class EnergyTransferHandler {
    public static final SonarTransferProxy PROXY_SC = new SonarTransferProxy();
    public static final EnergyTransferHandler INSTANCE_SC = new EnergyTransferHandler(PROXY_SC);
    public IEnergyTransferProxy transferProxy;

    public static long convert(long val, EnergyType from, EnergyType to, IEnergyTransferProxy proxy) {
        if (from == to) {
            return val;
        }
        double inRF = (double)val / proxy.getRFConversion(from);
        return (long)(inRF * proxy.getRFConversion(to));
    }

    public EnergyTransferHandler(IEnergyTransferProxy transferProxy) {
        this.transferProxy = transferProxy;
    }

    public IEnergyTransferProxy getProxy() {
        return this.transferProxy;
    }

    public long convert(long val, EnergyType from, EnergyType to) {
        return EnergyTransferHandler.convert(val, from, to, this.transferProxy);
    }

    @Nullable
    public IItemEnergyHandler getItemHandler(ItemStack stack) {
        if (!this.transferProxy.canConnectItem(stack)) {
            return null;
        }
        for (IItemEnergyHandler handler : SonarCore.itemEnergyHandlers) {
            if (!this.transferProxy.isItemEnergyTypeEnabled(handler.getEnergyType()) || !handler.canAddEnergy(stack) && !handler.canRemoveEnergy(stack)) continue;
            return handler;
        }
        return null;
    }

    @Nullable
    public ITileEnergyHandler getTileHandler(TileEntity tile, EnumFacing face) {
        if (!this.transferProxy.canConnectTile(tile, face)) {
            return null;
        }
        for (ITileEnergyHandler handler : SonarCore.tileEnergyHandlers) {
            if (!this.transferProxy.isTileEnergyTypeEnabled(handler.getEnergyType()) || !handler.canAddEnergy(tile, face) && !handler.canRemoveEnergy(tile, face)) continue;
            return handler;
        }
        return null;
    }

    @Nullable
    public IEnergyHandler getWrappedItemHandler(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        IItemEnergyHandler handler = this.getItemHandler(stack);
        if (handler != null) {
            return new ItemHandlingWrapper(stack, handler);
        }
        return null;
    }

    @Nullable
    public IEnergyHandler getWrappedTileHandler(TileEntity tile, EnumFacing face) {
        if (tile == null) {
            return null;
        }
        ITileEnergyHandler handler = this.getTileHandler(tile, face);
        if (handler != null) {
            return new TileHandlingWrapper(tile, face, handler);
        }
        return null;
    }

    public IEnergyHandler getWrappedStorageHandler(IEnergyStorage storage, EnumEnergyWrapperType wrapperType, EnergyType type) {
        return new EnergyStorageWrapper(storage, wrapperType, type);
    }

    public boolean canAdd(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        IItemEnergyHandler handler = this.getItemHandler(stack);
        return handler != null && handler.canAddEnergy(stack);
    }

    public boolean canRemove(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        IItemEnergyHandler handler = this.getItemHandler(stack);
        return handler != null && handler.canRemoveEnergy(stack);
    }

    public boolean canRead(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        IItemEnergyHandler handler = this.getItemHandler(stack);
        return handler != null && handler.canReadEnergy(stack);
    }

    public boolean canAdd(TileEntity tile, EnumFacing face) {
        if (tile == null) {
            return false;
        }
        ITileEnergyHandler handler = this.getTileHandler(tile, face);
        return handler != null && handler.canAddEnergy(tile, face);
    }

    public boolean canRemove(TileEntity tile, EnumFacing face) {
        if (tile == null) {
            return false;
        }
        ITileEnergyHandler handler = this.getTileHandler(tile, face);
        return handler != null && handler.canRemoveEnergy(tile, face);
    }

    public boolean canRead(TileEntity tile, EnumFacing face) {
        if (tile == null) {
            return false;
        }
        ITileEnergyHandler handler = this.getTileHandler(tile, face);
        return handler != null && handler.canReadEnergy(tile, face);
    }

    public boolean canRenderConnection(TileEntity tile, EnumFacing face) {
        if (tile == null || !this.transferProxy.canConnectTile(tile, face)) {
            return false;
        }
        for (ITileEnergyHandler handler : SonarCore.tileEnergyHandlers) {
            if (!this.transferProxy.isTileEnergyTypeEnabled(handler.getEnergyType()) || !handler.canRenderConnection(tile, face)) continue;
            return true;
        }
        return false;
    }

    public long convertedAction(long toConvert, EnergyType from, EnergyType to, Function<Long, Long> action) {
        long maxAdd = EnergyTransferHandler.convert(toConvert, from, to, this.transferProxy);
        long added = action.apply(maxAdd);
        return EnergyTransferHandler.convert(added, to, from, this.transferProxy);
    }

    public long doSimpleTransfer(Iterable<IEnergyHandler> sources, Iterable<IEnergyHandler> destinations, long maximum) {
        long transferred = 0L;
        for (IEnergyHandler source : sources) {
            if (!source.canRemoveEnergy()) continue;
            long maxRemove = source.removeEnergy(maximum - transferred, ActionType.SIMULATE);
            long removed = 0L;
            for (IEnergyHandler destination : destinations) {
                if (!this.transferProxy.canConvert(source, destination) || !this.transferProxy.canConvert(source.getEnergyType(), destination.getEnergyType())) continue;
                removed += this.convertedAction(maxRemove - removed, source.getEnergyType(), destination.getEnergyType(), e -> destination.addEnergy((long)e, ActionType.PERFORM));
            }
            transferred += source.removeEnergy(removed, ActionType.PERFORM);
        }
        return transferred;
    }

    public long addEnergy(IEnergyHandler handler, long charge, EnergyType energyType, ActionType actionType) {
        if (this.transferProxy.canConvert(energyType, handler.getEnergyType())) {
            return this.convertedAction(charge, energyType, handler.getEnergyType(), e -> handler.addEnergy((long)e, actionType));
        }
        return 0L;
    }

    public long removeEnergy(IEnergyHandler handler, long charge, EnergyType energyType, ActionType actionType) {
        if (this.transferProxy.canConvert(energyType, handler.getEnergyType())) {
            return this.convertedAction(charge, energyType, handler.getEnergyType(), e -> handler.removeEnergy((long)e, actionType));
        }
        return 0L;
    }

    public long chargeItem(Iterable<IEnergyHandler> sources, ItemStack stack, long maximum) {
        IEnergyHandler itemHandler = this.getWrappedItemHandler(stack);
        return itemHandler != null && itemHandler.canAddEnergy() ? this.doSimpleTransfer(sources, Lists.newArrayList((Object[])new IEnergyHandler[]{itemHandler}), maximum) : 0L;
    }

    public long dischargeItem(Iterable<IEnergyHandler> destinations, ItemStack stack, long maximum) {
        IEnergyHandler itemHandler = this.getWrappedItemHandler(stack);
        return itemHandler != null && itemHandler.canRemoveEnergy() ? this.doSimpleTransfer(Lists.newArrayList((Object[])new IEnergyHandler[]{itemHandler}), destinations, maximum) : 0L;
    }

    public long chargeItem(ItemStack stack, long charge, EnergyType energyType, ActionType actionType) {
        IEnergyHandler itemHandler = this.getWrappedItemHandler(stack);
        return itemHandler != null && itemHandler.canAddEnergy() ? this.addEnergy(itemHandler, charge, energyType, actionType) : 0L;
    }

    public long dischargeItem(ItemStack stack, long discharge, EnergyType energyType, ActionType actionType) {
        IEnergyHandler itemHandler = this.getWrappedItemHandler(stack);
        return itemHandler != null && itemHandler.canRemoveEnergy() ? this.removeEnergy(itemHandler, discharge, energyType, actionType) : 0L;
    }

    public long getEnergyStored(ItemStack stack, EnergyType energyType) {
        IItemEnergyHandler itemHandler = this.getItemHandler(stack);
        return itemHandler != null && itemHandler.canReadEnergy(stack) ? EnergyTransferHandler.convert(itemHandler.getStored(stack), itemHandler.getEnergyType(), energyType, this.transferProxy) : 0L;
    }

    public long getEnergyCapacity(ItemStack stack, EnergyType energyType) {
        IItemEnergyHandler itemHandler = this.getItemHandler(stack);
        return itemHandler != null && itemHandler.canReadEnergy(stack) ? EnergyTransferHandler.convert(itemHandler.getCapacity(stack), itemHandler.getEnergyType(), energyType, this.transferProxy) : 0L;
    }

    public void transferToAdjacent(TileEntity tile, Iterable<EnumFacing> faces, long maximum) {
        long transferred = 0L;
        for (EnumFacing face : faces) {
            IEnergyHandler handler = this.getWrappedTileHandler(tile, face);
            IEnergyHandler adjacent = this.getAdjacentHandler(tile.func_145831_w(), tile.func_174877_v(), face);
            if (handler == null || adjacent == null) continue;
            transferred += this.doSimpleTransfer(Lists.newArrayList((Object[])new IEnergyHandler[]{handler}), Lists.newArrayList((Object[])new IEnergyHandler[]{adjacent}), maximum - transferred);
        }
        this.getAdjacentHandlers(tile.func_145831_w(), tile.func_174877_v(), faces);
    }

    public List<IEnergyHandler> getAdjacentHandlers(World world, BlockPos pos, Iterable<EnumFacing> faces) {
        ArrayList<IEnergyHandler> handlers = new ArrayList<IEnergyHandler>();
        for (EnumFacing face : faces) {
            IEnergyHandler handler = this.getAdjacentHandler(world, pos, face);
            if (handler == null) continue;
            handlers.add(handler);
        }
        return handlers;
    }

    @Nullable
    public IEnergyHandler getAdjacentHandler(World world, BlockPos pos, EnumFacing face) {
        BlockPos adj = pos.func_177972_a(face);
        TileEntity tile = world.func_175625_s(adj);
        if (tile != null) {
            IEnergyHandler handler = this.getWrappedTileHandler(tile, face.func_176734_d());
            return handler;
        }
        return null;
    }

    public static class SonarTransferProxy
    implements IEnergyTransferProxy {
        @Override
        public double getRFConversion(EnergyType type) {
            switch (type) {
                case FE: {
                    return 1.0;
                }
                case TESLA: {
                    return 1.0;
                }
                case RF: {
                    return 1.0;
                }
                case EU: {
                    return 0.25;
                }
                case MJ: {
                    return 2.5;
                }
                case AE: {
                    return 0.5;
                }
            }
            return 1.0;
        }
    }
}

