/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.recipe.handler;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.ingredient.recipe.IRecipeInputDefinitionHandler;
import org.cyclops.cyclopscore.ingredient.recipe.IRecipeOutputDefinitionHandler;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;

public class IngredientRecipeComponentHandler
implements IRecipeInputDefinitionHandler<IngredientRecipeComponent>,
IRecipeOutputDefinitionHandler<IngredientRecipeComponent> {
    @Override
    public IMixedIngredients toRecipeDefinitionOutput(IngredientRecipeComponent recipeOutput) {
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        if (!recipeOutput.getItemStacks().isEmpty() && recipeOutput.getChance() == 1.0f) {
            outputs.put(IngredientComponent.ITEMSTACK, Collections.singletonList(recipeOutput.getFirstItemStack()));
        }
        return new MixedIngredients((Map)outputs);
    }

    @Override
    public Map<IngredientComponent<?, ?>, List<List<IPrototypedIngredient<?, ?>>>> toRecipeDefinitionInput(IngredientRecipeComponent recipeInput) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        List<ItemStack> itemStacks = recipeInput.getItemStacks();
        if (!itemStacks.isEmpty()) {
            inputs.put(IngredientComponent.ITEMSTACK, Collections.singletonList(itemStacks.stream().map(itemStack -> {
                int condition = 1;
                if (itemStack.func_77952_i() != Short.MAX_VALUE) {
                    condition |= 2;
                }
                return new PrototypedIngredient(IngredientComponent.ITEMSTACK, itemStack, (Object)condition);
            }).collect(Collectors.toList())));
        }
        return inputs;
    }
}

