/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import it.zerono.mods.zerocore.api.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import it.zerono.mods.zerocore.api.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import it.zerono.mods.zerocore.util.CodeHelper;
import it.zerono.mods.zerocore.util.ItemHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPart
extends ModBlock {
    protected final PartType _type;

    public BlockPart(PartType type, String blockName, Material material) {
        super(blockName, material);
        this._type = type;
        this.func_149647_a(BigReactors.TAB);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.0f);
    }

    public PartType getType() {
        return this._type;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos posistion, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.hasTileEntity(state) && !player.func_70093_af()) {
            ModTileEntity modTe;
            TileEntity te = world.func_175625_s(posistion);
            if (te instanceof ModTileEntity && EnumHand.MAIN_HAND == hand && (modTe = (ModTileEntity)te).canOpenGui(world, posistion, state)) {
                if (WorldHelper.calledByLogicalServer((World)world)) {
                    player.openGui((Object)BigReactors.getInstance(), 0, world, posistion.func_177958_n(), posistion.func_177956_o(), posistion.func_177952_p());
                }
                return true;
            }
            ItemStack heldItem = player.func_184586_b(hand);
            if (te instanceof IMultiblockPart && WorldHelper.calledByLogicalServer((World)world) && ItemHelper.stackIsEmpty((ItemStack)heldItem) && hand == EnumHand.OFF_HAND) {
                IMultiblockPart part = (IMultiblockPart)te;
                MultiblockControllerBase controller = part.getMultiblockController();
                TextComponentTranslation message = null;
                if (null != controller) {
                    ValidationError error = controller.getLastError();
                    if (null != error) {
                        message = error.getChatMessage();
                    }
                } else {
                    message = new TextComponentTranslation("multiblock.validation.block_not_connected", new Object[0]);
                }
                if (null != message) {
                    CodeHelper.sendChatMessage((ICommandSender)player, (ITextComponent)message);
                    return true;
                }
            }
        }
        return super.func_180639_a(world, posistion, state, player, hand, side, hitX, hitY, hitZ);
    }

    public void func_180663_b(World world, BlockPos position, IBlockState state) {
        world.func_175713_t(position);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos position, EnumFacing side) {
        IBlockState sideState = blockAccess.func_180495_p(position.func_177972_a(side));
        Block sideBlock = sideState.func_177230_c();
        return sideBlock != this;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos position) {
        TileEntity te = world.func_175625_s(position);
        if (te instanceof MultiblockTileEntityBase) {
            state = this.buildActualState(state, world, position, (MultiblockTileEntityBase)te);
        }
        return state;
    }

    protected IBlockState buildActualState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos position, @Nonnull MultiblockTileEntityBase part) {
        return state;
    }
}

