/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.client;

import c4.conarm.lib.client.IArmorMaterialTexture;
import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.modifiers.IArmorModelModifier;
import c4.conarm.lib.tinkering.TinkersArmor;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class DynamicTextureHelper {
    private static Cache<CacheKey, ResourceLocation> dynamicTextureCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public static ResourceLocation getCachedTexture(ItemStack stack) {
        CacheKey key = DynamicTextureHelper.getCacheKey(stack);
        ResourceLocation rl = null;
        if (stack.func_77973_b() instanceof TinkersArmor) {
            try {
                rl = (ResourceLocation)dynamicTextureCache.get((Object)key, () -> DynamicTextureHelper.getCombinedTexture(stack, (TinkersArmor)stack.func_77973_b()));
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return rl;
    }

    private static ResourceLocation getCombinedTexture(ItemStack stack, TinkersArmor armor) {
        ArrayList bufferedImages = Lists.newArrayList();
        List materials = TinkerUtil.getMaterialsFromTagList((NBTTagList)TagUtil.getBaseMaterialsTagList((ItemStack)stack));
        NonNullList modifiers = TinkerUtil.getModifiers((ItemStack)stack);
        for (int i = 0; i < materials.size(); ++i) {
            String partIn;
            Material material = (Material)materials.get(i);
            String identifier = material.getIdentifier();
            switch (i) {
                case 0: {
                    partIn = ArmorMaterialType.CORE;
                    break;
                }
                case 1: {
                    partIn = ArmorMaterialType.PLATES;
                    break;
                }
                case 2: {
                    if (materials.size() > 3) {
                        partIn = ArmorMaterialType.PLATES;
                        break;
                    }
                    partIn = ArmorMaterialType.TRIM;
                    break;
                }
                default: {
                    partIn = ArmorMaterialType.TRIM;
                }
            }
            TextureMap map = Minecraft.func_71410_x().func_147117_R();
            String loc = armor.getArmorModelTexture(stack, partIn);
            TextureAtlasSprite sprite = map.getTextureExtry(String.format("%s_%s", loc, identifier));
            if (sprite == null) {
                if (material.renderInfo.getTextureSuffix() != null) {
                    sprite = map.getTextureExtry(String.format("%s_%s", loc, material.renderInfo.getTextureSuffix()));
                    if (sprite == null) {
                        sprite = map.getTextureExtry(loc);
                    }
                } else {
                    sprite = map.getTextureExtry(loc);
                }
            }
            if (sprite == null) continue;
            int iconWidth = sprite.func_94211_a();
            int iconHeight = sprite.func_94216_b();
            int frameCount = sprite.func_110970_k();
            if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
                return null;
            }
            BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
            for (int j = 0; j < frameCount; ++j) {
                int[][] frameTextureData = sprite.func_147965_a(j);
                int[] largestMipMapTextureData = frameTextureData[0];
                bufferedImage.setRGB(0, j * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
            }
            if (material.renderInfo.useVertexColoring() && !CustomTextureCreator.exists((String)(loc + "_" + material.identifier))) {
                int color = material.renderInfo.getVertexColor();
                int a = color >> 24;
                if (a == 0) {
                    a = 255;
                }
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                float R = (float)r / 255.0f;
                float G = (float)g / 255.0f;
                float B = (float)b / 255.0f;
                float A = (float)a / 255.0f;
                for (int k = 0; k < bufferedImage.getWidth(); ++k) {
                    for (int l = 0; l < bufferedImage.getHeight(); ++l) {
                        int ax = bufferedImage.getColorModel().getAlpha(bufferedImage.getRaster().getDataElements(k, l, null));
                        int rx = bufferedImage.getColorModel().getRed(bufferedImage.getRaster().getDataElements(k, l, null));
                        int gx = bufferedImage.getColorModel().getGreen(bufferedImage.getRaster().getDataElements(k, l, null));
                        int bx = bufferedImage.getColorModel().getBlue(bufferedImage.getRaster().getDataElements(k, l, null));
                        rx = (int)((float)rx * R);
                        gx = (int)((float)gx * G);
                        bx = (int)((float)bx * B);
                        ax = (int)((float)ax * A);
                        bufferedImage.setRGB(k, l, ax << 24 | rx << 16 | gx << 8 | bx);
                    }
                }
            }
            bufferedImages.add(bufferedImage);
        }
        for (IModifier modifier : modifiers) {
            String loc;
            TextureMap map = Minecraft.func_71410_x().func_147117_R();
            if (modifier instanceof IArmorMaterialTexture) {
                loc = ((IArmorMaterialTexture)modifier).getBaseTexture();
            } else {
                if (!(modifier instanceof IArmorModelModifier)) continue;
                loc = String.format("%s_%s", ((IArmorModelModifier)modifier).getModelTextureLocation(), modifier.getIdentifier());
            }
            TextureAtlasSprite sprite = map.func_110572_b(loc);
            if (sprite == map.func_174944_f()) continue;
            int iconWidth = sprite.func_94211_a();
            int iconHeight = sprite.func_94216_b();
            int frameCount = sprite.func_110970_k();
            if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
                return null;
            }
            BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
            for (int k = 0; k < frameCount; ++k) {
                int[][] frameTextureData = sprite.func_147965_a(k);
                int[] largestMipMapTextureData = frameTextureData[0];
                bufferedImage.setRGB(0, k * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
            }
            bufferedImages.add(bufferedImage);
        }
        BufferedImage combined = new BufferedImage(64, 64, 6);
        Graphics2D g = combined.createGraphics();
        for (BufferedImage img : bufferedImages) {
            g.drawImage((Image)img, 0, 0, null);
        }
        g.dispose();
        return Minecraft.func_71410_x().func_110434_K().func_110578_a("constructsarmor", new DynamicTexture(combined));
    }

    public static CacheKey getCacheKey(ItemStack stack) {
        return new CacheKey(stack);
    }

    public static class CacheKey {
        final NBTTagCompound data;

        public CacheKey(ItemStack stack) {
            this.data = TagUtil.getTagSafe((ItemStack)stack);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.data != null ? this.data.equals((Object)cacheKey.data) : cacheKey.data == null;
        }

        public int hashCode() {
            return this.data != null ? this.data.hashCode() : 0;
        }
    }
}

