/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.inventory.AccessDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;

class SidedAccess {
    private final Map<EnumFacing, AccessDirection> accesses = new HashMap<EnumFacing, AccessDirection>();
    private AccessDirection base = AccessDirection.BOTH;
    private boolean insertLocked = false;
    private boolean extractLocked = false;

    public AccessDirection getAccess(@Nullable EnumFacing side) {
        return this.accesses.getOrDefault(side, this.base);
    }

    public boolean canInsert(@Nullable EnumFacing side) {
        return this.getAccess(side).canInsert();
    }

    public boolean canExtract(@Nullable EnumFacing side) {
        return this.getAccess(side).canExtract();
    }

    public boolean canAccess(EnumFacing side) {
        return this.getAccess(side).canAccess();
    }

    public boolean canChangeInsert() {
        return !this.insertLocked;
    }

    public boolean canChangeExtract() {
        return !this.extractLocked;
    }

    public void forbidInsertChange() {
        this.insertLocked = true;
    }

    public void forbidExtractChange() {
        this.extractLocked = true;
    }

    public Collection<EnumFacing> getInsertionSides() {
        ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            AccessDirection direction = this.getAccess(side);
            if (!direction.canInsert()) continue;
            dirs.add(side);
        }
        return dirs;
    }

    public Collection<EnumFacing> getExtractionSides() {
        ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            AccessDirection direction = this.getAccess(side);
            if (!direction.canExtract()) continue;
            dirs.add(side);
        }
        return dirs;
    }

    public void setInsert(EnumFacing side, boolean value) {
        AccessDirection direction = this.getAccess(side);
        if (direction.canInsert() != value) {
            this.accesses.put(side, direction.changeInsert(value));
        }
    }

    public void setExtract(EnumFacing side, boolean value) {
        AccessDirection direction = this.getAccess(side);
        if (direction.canExtract() != value) {
            this.accesses.put(side, direction.changeExtract(value));
        }
    }

    public void setInsert(boolean value) {
        if (this.base.canInsert() != value) {
            this.base = this.base.changeInsert(value);
        }
    }

    public void setExtract(boolean value) {
        if (this.base.canExtract() != value) {
            this.base = this.base.changeExtract(value);
        }
    }
}

