/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.database;

import binnie.core.api.gui.IArea;
import binnie.core.gui.controls.listbox.ControlListBox;
import binnie.core.gui.controls.page.ControlPage;
import binnie.core.gui.controls.page.ControlPages;
import binnie.core.gui.controls.tab.ControlTabBar;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.IDatabaseMode;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.geometry.CraftGUIUtil;
import binnie.core.gui.geometry.Point;

public final class ModeWidgets {
    private final ControlPage<IDatabaseMode> modePage;
    private final ControlListBox listBox;
    private final ControlPages<DatabaseTab> infoPages;
    private ControlTabBar<DatabaseTab> infoTabs;

    public ControlPage<IDatabaseMode> getModePage() {
        return this.modePage;
    }

    public ControlListBox getListBox() {
        return this.listBox;
    }

    public ModeWidgets(IDatabaseMode mode, WindowAbstractDatabase database, IListBoxCreator listBoxCreator) {
        this.modePage = new ControlPage<IDatabaseMode>(database.getModePages(), 0, 0, database.getSize().xPos(), database.getSize().yPos(), mode);
        IArea listBoxArea = database.getPanelSearch().getArea().inset(2);
        this.listBox = listBoxCreator.createListBox(listBoxArea, this.modePage);
        CraftGUIUtil.alignToWidget(this.listBox, database.getPanelSearch());
        CraftGUIUtil.moveWidget(this.listBox, new Point(2, 2));
        this.infoPages = new ControlPages(this.modePage, 0, 0, 144, 176);
        CraftGUIUtil.alignToWidget(this.infoPages, database.getPanelInformation());
    }

    public ControlPages<DatabaseTab> getInfoPages() {
        return this.infoPages;
    }

    public ControlTabBar<DatabaseTab> getInfoTabs() {
        return this.infoTabs;
    }

    public void setInfoTabs(ControlTabBar<DatabaseTab> infoTabs) {
        this.infoTabs = infoTabs;
    }

    @FunctionalInterface
    public static interface IListBoxCreator {
        public ControlListBox createListBox(IArea var1, ControlPage<IDatabaseMode> var2);
    }
}

