/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.telepad.gui;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.widget.GuiScrollableList;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.item.coordselector.TelepadTarget;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.teleport.telepad.TileDialingDevice;
import crazypants.enderio.machines.machine.teleport.telepad.packet.PacketTargetList;
import crazypants.enderio.machines.network.PacketHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTargetList
extends GuiScrollableList<TelepadTarget> {
    @Nonnull
    private final TileDialingDevice te;

    public GuiTargetList(int width, int height, int originX, int originY, @Nonnull TileDialingDevice te) {
        super(width, height, originX, originY, Minecraft.func_71410_x().field_71466_p.field_78288_b + 4);
        this.te = te;
    }

    @Nonnull
    public TelepadTarget getElementAt(int index) {
        ArrayList<TelepadTarget> targs = this.te.getTargets();
        if (index < 0 || index >= targs.size()) {
            throw new IndexOutOfBoundsException("No telepad target for index " + index);
        }
        return (TelepadTarget)NullHelper.notnull((Object)targs.get(index), (String)"Telepad target was null in list");
    }

    public int getNumElements() {
        return this.te.getTargets().size();
    }

    protected void drawElement(int elementIndex, int x, int y, int heightIn, @Nonnull BufferBuilder renderer) {
        TelepadTarget targ = this.getElementAt(elementIndex);
        String name = targ.getName();
        if (name.trim().length() == 0) {
            name = Lang.GUI_TELEPAD_UNNAMED_LOCATION.get();
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_175065_a(name, (float)(x + 4), (float)(y + 2), 0xFFFFFF, true);
        if (this.getSelectedElement() == targ) {
            Rectangle iconBounds = this.getIconBounds(y);
            EnderWidget icon = EnderWidget.X_BUT;
            EnderWidget.map.render((IWidgetIcon)icon, (double)iconBounds.x, (double)iconBounds.y, (double)iconBounds.width, (double)iconBounds.height, 0.0, true);
        }
    }

    protected boolean elementClicked(int elementIndex, boolean doubleClick, int elX, int elY) {
        TelepadTarget target = (TelepadTarget)this.getSelectedElement();
        Rectangle iconBounds = this.getIconBounds(0);
        if (iconBounds.contains(elX, elY)) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTargetList(this.te, target, false));
            if (this.selectedIndex >= this.getNumElements()) {
                this.setSelection(this.getNumElements() - 1);
            }
            return false;
        }
        return true;
    }

    public Rectangle getIconBounds(int minElY) {
        EnderWidget icon = EnderWidget.RETURN_BUT_HOVER;
        int xPos = this.minX + this.width - icon.width - 2;
        if (this.getContentOverhang() > 0) {
            xPos -= 6;
        }
        Rectangle iconBounds = new Rectangle(xPos, minElY + 1, icon.width, icon.height);
        return iconBounds;
    }
}

