/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.RecipeConfig;
import crazypants.enderio.base.integration.tic.TicProxy;
import crazypants.enderio.base.recipe.BasicManyToOneRecipe;
import crazypants.enderio.base.recipe.IManyToOneRecipe;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class ManyToOneRecipeManager {
    @Nonnull
    private final NNList<IManyToOneRecipe> recipes = new NNList();
    @Nonnull
    private final String managerName;

    public ManyToOneRecipeManager(@Nonnull String managerName) {
        this.managerName = managerName;
    }

    @Nonnull
    public NNList<IManyToOneRecipe> getRecipes() {
        return this.recipes;
    }

    public void addRecipe(Recipe rec) {
        if (rec == null) {
            Log.warn("Invalid null recipe found for " + this.managerName);
        } else if (((Boolean)RecipeConfig.createSyntheticRecipes.get()).booleanValue() && rec.getInputs().length == 1 && !rec.getInputs()[0].isFluid() && rec.getInputs()[0].getInput().func_190916_E() <= rec.getInputs()[0].getInput().func_77976_d() / 3 && rec.getOutputs().length == 1 && !rec.getOutputs()[0].isFluid() && rec.getOutputs()[0].getOutput().func_190916_E() <= rec.getOutputs()[0].getOutput().func_77976_d() / 3) {
            IRecipe dupe = this.getRecipeForStacks(rec.getInputStacks());
            if (dupe != null) {
                Log.warn("The supplied recipe " + rec + " for " + this.managerName + " may be a duplicate to: " + dupe);
            }
            int er = rec.getEnergyRequired();
            RecipeBonusType bns = rec.getBonusType();
            RecipeOutput out = rec.getOutputs()[0];
            IRecipeInput in = rec.getInputs()[0];
            IRecipeInput in2 = in.copy();
            in2.shrinkStack(-in.getInput().func_190916_E());
            RecipeOutput out2 = new RecipeOutput(out.getOutput(), out.getChance(), out.getExperiance());
            out2.getOutput().func_190917_f(out.getOutput().func_190916_E());
            IRecipeInput in3 = in.copy();
            in3.shrinkStack(-in.getInput().func_190916_E());
            in3.shrinkStack(-in.getInput().func_190916_E());
            RecipeOutput out3 = new RecipeOutput(out.getOutput(), out.getChance(), out.getExperiance());
            out3.getOutput().func_190917_f(out.getOutput().func_190916_E());
            out3.getOutput().func_190917_f(out.getOutput().func_190916_E());
            this.recipes.add((Object)new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, in.copy(), in.copy(), in.copy())).setSynthetic());
            this.recipes.add((Object)new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, in.copy(), in2.copy())).setSynthetic());
            this.recipes.add((Object)new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, in2.copy(), in.copy())).setSynthetic());
            this.recipes.add((Object)new BasicManyToOneRecipe(new Recipe(out2, er * 2, bns, in.copy(), in.copy())).setSynthetic());
            this.recipes.add((Object)new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, in3.copy())).setSynthetic());
            this.recipes.add((Object)new BasicManyToOneRecipe(new Recipe(out2, er * 2, bns, in2.copy())).setSynthetic());
            this.recipes.add((Object)new BasicManyToOneRecipe(rec));
            Log.info("Created 6 synthetic recipes for " + in.getInput() + " => " + out.getOutput());
        } else {
            this.addRecipe(new BasicManyToOneRecipe(rec));
            if (this.managerName.equals("Alloy Smelter") && rec.getInputs().length >= 2) {
                NNList inputs = new NNList();
                for (int i = 0; i < rec.getInputs().length; ++i) {
                    ItemStack input = rec.getInputs()[i].getInput().func_77946_l();
                    Things inputThing = new Things();
                    inputThing.add(input);
                    inputThing.setSize(input.func_190916_E());
                    inputThing.setNbt(input.func_77978_p());
                    inputs.add((Object)inputThing);
                }
                ItemStack output = rec.getOutputs()[0].getOutput().func_77946_l();
                Things outputThing = new Things();
                outputThing.add(output);
                outputThing.setSize(output.func_190916_E());
                outputThing.setNbt(output.func_77978_p());
                TicProxy.registerAlloyRecipe(outputThing, (NNList<Things>)inputs);
            }
        }
    }

    public void addRecipe(@Nonnull IManyToOneRecipe recipe) {
        IRecipe rec = this.getRecipeForStacks(recipe.getInputStacks());
        if (rec != null) {
            Log.warn("The supplied recipe " + recipe + " for " + this.managerName + " may be a duplicate to: " + rec);
        }
        this.recipes.add((Object)recipe);
    }

    private IRecipe getRecipeForStacks(@Nonnull NNList<ItemStack> inputs) {
        NNList ins = new NNList();
        for (ItemStack stack : inputs) {
            ins.add((Object)new MachineRecipeInput(-1, (ItemStack)NullHelper.notnullM((Object)stack, (String)"NNList iterated with null")));
        }
        return this.getRecipeForInputs(RecipeLevel.IGNORE, (NNList<MachineRecipeInput>)ins);
    }

    public IRecipe getRecipeForInputs(@Nonnull RecipeLevel machineLevel, @Nonnull NNList<MachineRecipeInput> inputs) {
        for (IManyToOneRecipe rec : this.recipes) {
            if (!machineLevel.canMake(rec.getRecipeLevel()) || !rec.isInputForRecipe(inputs)) continue;
            return rec;
        }
        return null;
    }

    public boolean isValidInput(@Nonnull RecipeLevel machineLevel, @Nonnull MachineRecipeInput input) {
        if (Prep.isInvalid(input.item)) {
            return false;
        }
        for (IManyToOneRecipe recipe : this.recipes) {
            if (!machineLevel.canMake(recipe.getRecipeLevel())) continue;
            for (IRecipeInput ri : recipe.getInputs()) {
                if (!ri.isInput(input.item) || ri.getSlotNumber() != -1 && input.slotNumber != ri.getSlotNumber()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidRecipeComponents(@Nonnull ItemStack[] inputs) {
        if (inputs.length == 0) {
            return false;
        }
        for (IManyToOneRecipe recipe : this.recipes) {
            if (!recipe.isValidRecipeComponents(inputs)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public List<IManyToOneRecipe> getRecipesThatHaveTheseAsValidRecipeComponents(@Nonnull ItemStack[] inputs) {
        ArrayList<IManyToOneRecipe> result = new ArrayList<IManyToOneRecipe>();
        if (inputs.length > 0) {
            for (IManyToOneRecipe recipe : this.recipes) {
                if (!recipe.isValidRecipeComponents(inputs)) continue;
                result.add(recipe);
            }
        }
        return result;
    }

    public float getExperienceForOutput(@Nonnull ItemStack output) {
        for (IManyToOneRecipe recipe : this.recipes) {
            if (recipe.getOutput().func_77973_b() != output.func_77973_b() || recipe.getOutput().func_77952_i() != output.func_77952_i()) continue;
            return recipe.getOutputs()[0].getExperiance();
        }
        return 0.0f;
    }
}

