/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.IShowPsiBar;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.client.core.handler.KeybindHandler;
import vazkii.psi.client.core.handler.ShaderHandler;
import vazkii.psi.client.core.helper.PsiRenderHelper;
import vazkii.psi.client.gui.GuiLeveling;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.base.IHUDItem;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="psi")
public final class HUDHandler {
    private static final ResourceLocation psiBar = new ResourceLocation("psi:textures/gui/psi_bar.png");
    private static final ResourceLocation psiBarMask = new ResourceLocation("psi:textures/gui/psi_bar_mask.png");
    private static final ResourceLocation psiBarShatter = new ResourceLocation("psi:textures/gui/psi_bar_shatter.png");
    private static final int secondaryTextureUnit = 7;
    private static boolean registeredMask = false;
    private static final int maxRemainingTicks = 30;
    public static boolean showLevelUp = false;
    public static int levelDisplayTime = 0;
    public static int levelValue = 0;
    private static ItemStack remainingDisplayStack;
    private static int remainingTime;
    private static int remainingCount;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onDraw(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ScaledResolution resolution = event.getResolution();
            float partialTicks = event.getPartialTicks();
            HUDHandler.drawPsiBar(resolution, partialTicks);
            HUDHandler.renderSocketableEquippedName(resolution, partialTicks);
            HUDHandler.renderLevelUpIndicator(resolution);
            HUDHandler.renderRemainingItems(resolution, partialTicks);
            HUDHandler.renderHUDItem(resolution, partialTicks);
        }
    }

    public static void tick() {
        if (showLevelUp) {
            ++levelDisplayTime;
        }
        if (remainingTime > 0) {
            --remainingTime;
        }
    }

    private static boolean showsBar(PlayerDataHandler.PlayerData data, ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IShowPsiBar)) {
            return false;
        }
        IShowPsiBar item = (IShowPsiBar)stack.func_77973_b();
        return item.shouldShow(stack, data);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawPsiBar(ScaledResolution res, float pticks) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack cadStack = PsiAPI.getPlayerCAD((EntityPlayer)mc.field_71439_g);
        if (cadStack.func_190926_b()) {
            return;
        }
        ICAD cad = (ICAD)cadStack.func_77973_b();
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((EntityPlayer)mc.field_71439_g);
        if (data.level == 0 && !mc.field_71439_g.field_71075_bZ.field_75098_d) {
            return;
        }
        int totalPsi = data.getTotalPsi();
        int currPsi = data.getAvailablePsi();
        if (ConfigHandler.contextSensitiveBar && currPsi == totalPsi && !HUDHandler.showsBar(data, mc.field_71439_g.func_184614_ca()) && !HUDHandler.showsBar(data, mc.field_71439_g.func_184592_cb())) {
            return;
        }
        GlStateManager.func_179094_E();
        int scaleFactor = res.func_78325_e();
        if (scaleFactor > ConfigHandler.maxPsiBarScale) {
            int guiScale = mc.field_71474_y.field_74335_Z;
            mc.field_71474_y.field_74335_Z = ConfigHandler.maxPsiBarScale;
            res = new ScaledResolution(mc);
            mc.field_71474_y.field_74335_Z = guiScale;
            float s = (float)ConfigHandler.maxPsiBarScale / (float)scaleFactor;
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        }
        boolean right = ConfigHandler.psiBarOnRight;
        int pad = 3;
        int width = 32;
        int height = 140;
        int x = -pad;
        if (right) {
            x = res.func_78326_a() + pad - width;
        }
        int y = res.func_78328_b() / 2 - height / 2;
        if (!registeredMask) {
            mc.field_71446_o.func_110577_a(psiBarMask);
            mc.field_71446_o.func_110577_a(psiBarShatter);
            registeredMask = true;
        }
        mc.field_71446_o.func_110577_a(psiBar);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (float)64.0f, (float)256.0f);
        x += 8;
        y += 26;
        width = 16;
        height = 106;
        float r = 0.6f;
        float g = 0.65f;
        float b = 1.0f;
        int origHeight = height;
        int origY = y;
        int v = 0;
        int texture = 0;
        boolean shaders = ShaderHandler.useShaders();
        if (shaders) {
            OpenGlHelper.func_77473_a((int)33991);
            texture = GL11.glGetInteger((int)32873);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        for (PlayerDataHandler.PlayerData.Deduction d : data.deductions) {
            float a = d.getPercentile(pticks);
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
            height = (int)Math.ceil((double)origHeight * (double)d.deduct / (double)totalPsi);
            int effHeight = (int)((double)origHeight * (double)d.current / (double)totalPsi);
            v = origHeight - effHeight;
            y = origY + v;
            ShaderHandler.useShader(ShaderHandler.psiBar, HUDHandler.generateCallback(a, d.shatter, data.overflowed));
            Gui.func_146110_a((int)x, (int)y, (float)32.0f, (float)v, (int)width, (int)height, (float)64.0f, (float)256.0f);
        }
        float textY = origY;
        if (totalPsi > 0) {
            height = (int)((double)origHeight * (double)data.availablePsi / (double)totalPsi);
            v = origHeight - height;
            y = origY + v;
            if (data.availablePsi != data.lastAvailablePsi) {
                float textHeight = (float)((double)origHeight * ((double)((float)data.availablePsi * pticks) + (double)data.lastAvailablePsi * (1.0 - (double)pticks)) / (double)totalPsi);
                textY = (float)origY + ((float)origHeight - textHeight);
            } else {
                textY = y;
            }
        } else {
            height = 0;
        }
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        ShaderHandler.useShader(ShaderHandler.psiBar, HUDHandler.generateCallback(1.0f, false, data.overflowed));
        Gui.func_146110_a((int)x, (int)y, (float)32.0f, (float)v, (int)width, (int)height, (float)64.0f, (float)256.0f);
        ShaderHandler.releaseShader();
        if (shaders) {
            OpenGlHelper.func_77473_a((int)33991);
            GL11.glBindTexture((int)3553, (int)texture);
            OpenGlHelper.func_77473_a((int)33984);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)textY, (float)0.0f);
        width = 44;
        height = 3;
        int storedPsi = cad.getStoredPsi(cadStack);
        String s1 = storedPsi == -1 ? "\u221e" : "" + data.availablePsi;
        String s2 = "" + storedPsi;
        int offBar = 22;
        int offStr1 = 7 + mc.field_71466_p.func_78256_a(s1);
        int offStr2 = 7 + mc.field_71466_p.func_78256_a(s2);
        if (!right) {
            offBar = 6;
            offStr1 = -23;
            offStr2 = -23;
        }
        int color = cad.getSpellColor(cadStack);
        GlStateManager.func_179131_c((float)((float)PsiRenderHelper.r(color) / 255.0f), (float)((float)PsiRenderHelper.g(color) / 255.0f), (float)((float)PsiRenderHelper.b(color) / 255.0f), (float)1.0f);
        Gui.func_146110_a((int)(x - offBar), (int)-2, (float)0.0f, (float)140.0f, (int)width, (int)height, (float)64.0f, (float)256.0f);
        mc.field_71466_p.func_175063_a(s1, (float)(x - offStr1), -11.0f, 0xFFFFFF);
        GlStateManager.func_179121_F();
        if (storedPsi != -1) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)Math.max(textY + 3.0f, (float)(origY + 100)), (float)0.0f);
            mc.field_71466_p.func_175063_a(s2, (float)(x - offStr2), 0.0f, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderSocketableEquippedName(ScaledResolution res, float pticks) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        String name = ISocketable.getSocketedItemName(stack, "");
        if (stack.func_190926_b() || name == null || name.trim().isEmpty()) {
            return;
        }
        int ticks = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiIngame.class, (Object)mc.field_71456_v, (String[])new String[]{"field_92017_k"});
        if ((ticks -= 10) > 0) {
            ItemStack socketable = ((ISocketable)stack.func_77973_b()).getBulletInSocket(stack, ((ISocketable)stack.func_77973_b()).getSelectedSlot(stack));
            int alpha = Math.min(255, (int)(((float)ticks - pticks) * 256.0f / 10.0f));
            int color = 1295871 + (alpha << 24);
            int x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(name) / 2;
            int y = res.func_78328_b() - 71;
            if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
                y += 14;
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            mc.field_71466_p.func_175063_a(name, (float)x, (float)y, color);
            int w = mc.field_71466_p.func_78256_a(name);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(x + w), (float)(y - 6), (float)0.0f);
            GlStateManager.func_179152_a((float)((float)alpha / 255.0f), (float)1.0f, (float)1.0f);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_175599_af().func_175042_a(socketable, 0, 0);
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
        }
    }

    public static void levelUp(int level) {
        levelValue = level;
        levelDisplayTime = 0;
        showLevelUp = true;
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderLevelUpIndicator(ScaledResolution res) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof GuiLeveling) {
            showLevelUp = false;
        }
        if (!showLevelUp) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179112_b((int)770, (int)771);
        int time = 100;
        int fadeTime = time / 10;
        int fadeoutTime = fadeTime * 2;
        String levelUp = TooltipHelper.local("psimisc.levelup");
        int len = levelUp.length();
        int effLen = Math.min(len, len * levelDisplayTime / fadeTime);
        levelUp = levelUp.substring(0, effLen);
        int swidth = mc.field_71466_p.func_78256_a(levelUp);
        int x = res.func_78326_a() / 4 - swidth / 2;
        int y = 25;
        float a = 1.0f - Math.max(0.0f, Math.min(1.0f, (float)(levelDisplayTime - time) / (float)fadeoutTime));
        int alphaOverlay = (int)(a * 255.0f) << 24;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        mc.field_71466_p.func_175063_a(levelUp, (float)x, (float)y, 1295871 + alphaOverlay);
        String currLevel = "" + levelValue;
        x = res.func_78326_a() / 4;
        y += 10;
        if (levelDisplayTime > fadeTime) {
            if (levelDisplayTime - fadeTime == 1) {
                mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)PsiSoundHandler.levelUp, (float)0.5f));
            }
            float a1 = Math.min(1.0f, (float)(levelDisplayTime - fadeTime) / (float)fadeTime) * a;
            int color1 = 0xFFFFFF + ((int)(a1 * 255.0f) << 24);
            mc.field_71466_p.func_175063_a(TextFormatting.GOLD + currLevel, (float)x, (float)y, color1);
        }
        GlStateManager.func_179121_F();
        if (levelDisplayTime > fadeTime * 2) {
            String s = TooltipHelper.local("psimisc.levelUpInfo1");
            swidth = mc.field_71466_p.func_78256_a(s);
            len = s.length();
            effLen = Math.min(len, len * (levelDisplayTime - fadeTime * 2) / fadeTime);
            s = s.substring(0, effLen);
            x = res.func_78326_a() / 2 - swidth / 2;
            mc.field_71466_p.func_175063_a(s, (float)x, (float)(y += 65), 0xFFFFFF + alphaOverlay);
        }
        if (levelDisplayTime > fadeTime * 3) {
            String s = TooltipHelper.local("psimisc.levelUpInfo2", TextFormatting.GREEN + TooltipHelper.local(KeybindHandler.keybind.getDisplayName()) + TextFormatting.RESET);
            swidth = mc.field_71466_p.func_78256_a(s);
            len = s.length();
            effLen = Math.min(len, len * (levelDisplayTime - fadeTime * 3) / fadeTime);
            s = s.substring(0, effLen);
            x = res.func_78326_a() / 2 - swidth / 2;
            mc.field_71466_p.func_175063_a(s, (float)x, (float)(y += 10), 0xFFFFFF + alphaOverlay);
        }
        GlStateManager.func_179141_d();
        if (levelValue > 1 && levelDisplayTime >= time + fadeoutTime) {
            showLevelUp = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderRemainingItems(ScaledResolution resolution, float partTicks) {
        if (remainingTime > 0 && !remainingDisplayStack.func_190926_b()) {
            int pos = 30 - remainingTime;
            Minecraft mc = Minecraft.func_71410_x();
            int remainingLeaveTicks = 20;
            int x = resolution.func_78326_a() / 2 + 10 + Math.max(0, pos - remainingLeaveTicks);
            int y = resolution.func_78328_b() / 2;
            int start = 30 - remainingLeaveTicks;
            float alpha = (float)remainingTime + partTicks > (float)start ? 1.0f : ((float)remainingTime + partTicks) / (float)start;
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179101_C();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            RenderHelper.func_74520_c();
            int xp = x + (int)(16.0f * (1.0f - alpha));
            GlStateManager.func_179109_b((float)xp, (float)y, (float)0.0f);
            GlStateManager.func_179152_a((float)alpha, (float)1.0f, (float)1.0f);
            mc.func_175599_af().func_180450_b(remainingDisplayStack, 0, 0);
            GlStateManager.func_179152_a((float)(1.0f / alpha), (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(-xp), (float)(-y), (float)0.0f);
            RenderHelper.func_74518_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            String text = TextFormatting.GREEN + remainingDisplayStack.func_82833_r();
            if (remainingCount >= 0) {
                int max = remainingDisplayStack.func_77976_d();
                int stacks = remainingCount / max;
                int rem = remainingCount % max;
                text = stacks == 0 ? "" + remainingCount : remainingCount + " (" + TextFormatting.AQUA + stacks + TextFormatting.RESET + "*" + TextFormatting.GRAY + max + TextFormatting.RESET + "+" + TextFormatting.YELLOW + rem + TextFormatting.RESET + ")";
            } else if (remainingCount == -1) {
                text = "\u221e";
            }
            int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            mc.field_71466_p.func_175063_a(text, (float)(x + 20), (float)(y + 6), color);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderHUDItem(ScaledResolution resolution, float partTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = mc.field_71439_g.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IHUDItem) {
            ((IHUDItem)stack.func_77973_b()).drawHUD(resolution, partTicks, stack);
        }
        if (!(stack = mc.field_71439_g.func_184592_cb()).func_190926_b() && stack.func_77973_b() instanceof IHUDItem) {
            ((IHUDItem)stack.func_77973_b()).drawHUD(resolution, partTicks, stack);
        }
    }

    public static void setRemaining(ItemStack stack, int count) {
        remainingDisplayStack = stack;
        remainingCount = count;
        remainingTime = stack.func_190926_b() ? 0 : 30;
    }

    public static void setRemaining(EntityPlayer player, ItemStack displayStack, Pattern pattern) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(pattern == null ? ItemStack.func_179545_c((ItemStack)displayStack, (ItemStack)stack) : pattern.matcher(stack.func_77977_a()).find())) continue;
            count += stack.func_190916_E();
        }
        HUDHandler.setRemaining(displayStack, count);
    }

    @SideOnly(value=Side.CLIENT)
    private static Consumer<Integer> generateCallback(float percentile, boolean shatter, boolean overflowed) {
        Minecraft mc = Minecraft.func_71410_x();
        return shader -> {
            int percentileUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"percentile");
            int overflowedUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"overflowed");
            int imageUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"image");
            int maskUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"mask");
            OpenGlHelper.func_77473_a((int)33984);
            mc.field_71446_o.func_110577_a(psiBar);
            ARBShaderObjects.glUniform1iARB((int)imageUniform, (int)0);
            OpenGlHelper.func_77473_a((int)33991);
            GlStateManager.func_179098_w();
            mc.field_71446_o.func_110577_a(shatter ? psiBarShatter : psiBarMask);
            ARBShaderObjects.glUniform1iARB((int)maskUniform, (int)7);
            ARBShaderObjects.glUniform1fARB((int)percentileUniform, (float)percentile);
            ARBShaderObjects.glUniform1iARB((int)overflowedUniform, (int)(overflowed ? 1 : 0));
        };
    }
}

