/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.IngredientSorption;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.ITileFluid;
import nc.tile.generator.IItemFluidGenerator;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import nc.util.CollectionHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileItemFluidGenerator
extends TileEnergyFluidSidedInventory
implements IItemFluidGenerator {
    public final int[] slots;
    public final int defaultProcessTime;
    public final int defaultProcessPower;
    public double baseProcessTime = 1.0;
    public double baseProcessPower = 0.0;
    public double baseProcessRadiation = 0.0;
    public double processPower = 0.0;
    public double speedMultiplier = 1.0;
    public final int itemInputSize;
    public final int fluidInputSize;
    public final int itemOutputSize;
    public final int fluidOutputSize;
    public final int otherSlotsSize;
    public double time;
    public boolean isProcessing;
    public boolean hasConsumed;
    public boolean canProcessInputs;
    public final NCRecipes.Type recipeType;
    protected ProcessorRecipe recipe;
    protected ProcessorRecipe cachedRecipe;
    protected Set<EntityPlayer> playersToUpdate;

    public TileItemFluidGenerator(String name, int itemInSize, int fluidInSize, int itemOutSize, int fluidOutSize, int otherSize, @Nonnull List<Integer> fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluids, int capacity, @Nonnull NCRecipes.Type recipeType) {
        super(name, 2 * itemInSize + itemOutSize + otherSize, capacity, ITileEnergy.energyConnectionAll(EnergyConnection.OUT), fluidCapacity, fluidCapacity, allowedFluids, ITileFluid.fluidConnectionAll(tankSorptions));
        this.itemInputSize = itemInSize;
        this.fluidInputSize = fluidInSize;
        this.itemOutputSize = itemOutSize;
        this.fluidOutputSize = fluidOutSize;
        this.otherSlotsSize = otherSize;
        this.setInputTanksSeparated(fluidInSize > 1);
        this.defaultProcessTime = 1;
        this.defaultProcessPower = 0;
        this.recipeType = recipeType;
        this.slots = CollectionHelper.increasingArray(itemInSize + itemOutSize);
        this.playersToUpdate = new HashSet<EntityPlayer>();
    }

    public static List<Integer> defaultTankCapacities(int capacity, int inSize, int outSize) {
        ArrayList<Integer> tankCapacities = new ArrayList<Integer>();
        for (int i = 0; i < 2 * inSize + outSize; ++i) {
            tankCapacities.add(capacity);
        }
        return tankCapacities;
    }

    public static List<TankSorption> defaultTankSorptions(int inSize, int outSize) {
        int i;
        ArrayList<TankSorption> tankSorptions = new ArrayList<TankSorption>();
        for (i = 0; i < inSize; ++i) {
            tankSorptions.add(TankSorption.IN);
        }
        for (i = 0; i < outSize; ++i) {
            tankSorptions.add(TankSorption.OUT);
        }
        for (i = 0; i < inSize; ++i) {
            tankSorptions.add(TankSorption.NON);
        }
        return tankSorptions;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.isProcessing = this.isProcessing();
            this.hasConsumed = this.hasConsumed();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateGenerator();
    }

    public abstract void updateGenerator();

    public void updateBlockType() {
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
        this.setState(this.isProcessing);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    @Override
    public void refreshRecipe() {
        if (this.recipe == null || !this.recipe.matchingInputs(this.getItemInputs(this.hasConsumed), this.getFluidInputs(this.hasConsumed))) {
            this.recipe = this.cachedRecipe != null && this.cachedRecipe.matchingInputs(this.getItemInputs(this.hasConsumed), this.getFluidInputs(this.hasConsumed)) ? this.cachedRecipe : (ProcessorRecipe)this.getRecipeHandler().getRecipeFromInputs(this.getItemInputs(this.hasConsumed), this.getFluidInputs(this.hasConsumed));
            if (this.recipe != null) {
                this.cachedRecipe = this.recipe;
            }
        }
        this.consumeInputs();
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs(false);
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs(true);
    }

    public abstract boolean setRecipeStats();

    public boolean isProcessing() {
        return this.readyToProcess() && this.getIsRedstonePowered();
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasConsumed;
    }

    public boolean hasConsumed() {
        int i;
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (i = 0; i < this.itemInputSize; ++i) {
            if (((ItemStack)this.inventoryStacks.get(i + this.itemInputSize + this.itemOutputSize)).func_190926_b()) continue;
            return true;
        }
        for (i = 0; i < this.fluidInputSize; ++i) {
            if (this.getTanks().get(i + this.fluidInputSize + this.fluidOutputSize).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean canProcessInputs(boolean justProduced) {
        if (!this.setRecipeStats()) {
            if (this.hasConsumed) {
                for (int i = 0; i < this.itemInputSize; ++i) {
                    this.getItemInputs(true).set(i, ItemStack.field_190927_a);
                }
                for (Tank tank : this.getFluidInputs(true)) {
                    tank.setFluidStored(null);
                }
                this.hasConsumed = false;
            }
            return false;
        }
        if (!justProduced && this.time >= this.baseProcessTime) {
            return true;
        }
        return this.canProduceProducts();
    }

    public boolean canProduceProducts() {
        int j;
        for (j = 0; j < this.itemOutputSize; ++j) {
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getMaxStackSize() <= 0) continue;
            if (itemProduct.getStack() == null || itemProduct.getStack() == ItemStack.field_190927_a) {
                return false;
            }
            if (((ItemStack)this.inventoryStacks.get(j + this.itemInputSize)).func_190926_b()) continue;
            if (!((ItemStack)this.inventoryStacks.get(j + this.itemInputSize)).func_77969_a(itemProduct.getStack())) {
                return false;
            }
            if (((ItemStack)this.inventoryStacks.get(j + this.itemInputSize)).func_190916_E() + itemProduct.getMaxStackSize() <= ((ItemStack)this.inventoryStacks.get(j + this.itemInputSize)).func_77976_d()) continue;
            return false;
        }
        for (j = 0; j < this.fluidOutputSize; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize() <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) continue;
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual(fluidProduct.getStack())) {
                return false;
            }
            if (this.getVoidExcessFluidOutput(j) || this.getTanks().get(j + this.fluidInputSize).getFluidAmount() + fluidProduct.getMaxStackSize() <= this.getTanks().get(j + this.fluidInputSize).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs() {
        int i;
        if (this.hasConsumed || this.recipe == null) {
            return;
        }
        List<Integer> itemInputOrder = this.getItemInputOrder();
        List<Integer> fluidInputOrder = this.getFluidInputOrder();
        if (itemInputOrder == AbstractRecipeHandler.INVALID || fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (i = 0; i < this.itemInputSize; ++i) {
            if (((ItemStack)this.inventoryStacks.get(i + this.itemInputSize + this.itemOutputSize)).func_190926_b()) continue;
            this.inventoryStacks.set(i + this.itemInputSize + this.itemOutputSize, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < this.fluidInputSize; ++i) {
            if (this.getTanks().get(i + this.fluidInputSize + this.fluidOutputSize).isEmpty()) continue;
            this.getTanks().get(i + this.fluidInputSize + this.fluidOutputSize).setFluid(null);
        }
        for (i = 0; i < this.itemInputSize; ++i) {
            IItemIngredient itemIngredient = this.getItemIngredients().get(itemInputOrder.get(i));
            if (itemIngredient.getMaxStackSize() > 0) {
                this.inventoryStacks.set(i + this.itemInputSize + this.itemOutputSize, (Object)new ItemStack(((ItemStack)this.inventoryStacks.get(i)).func_77973_b(), itemIngredient.getMaxStackSize(), ((ItemStack)this.inventoryStacks.get(i)).func_77952_i()));
                ((ItemStack)this.inventoryStacks.get(i)).func_190918_g(itemIngredient.getMaxStackSize());
            }
            if (((ItemStack)this.inventoryStacks.get(i)).func_190916_E() > 0) continue;
            this.inventoryStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < this.fluidInputSize; ++i) {
            IFluidIngredient fluidIngredient = this.getFluidIngredients().get(fluidInputOrder.get(i));
            if (fluidIngredient.getMaxStackSize() > 0) {
                this.getTanks().get(i + this.fluidInputSize + this.fluidOutputSize).setFluidStored(new FluidStack(this.getTanks().get(i).getFluid(), fluidIngredient.getMaxStackSize()));
                this.getTanks().get(i).changeFluidAmount(-fluidIngredient.getMaxStackSize());
            }
            if (!this.getTanks().get(i).isEmpty()) continue;
            this.getTanks().get(i).setFluid(null);
        }
        this.hasConsumed = true;
    }

    public void process() {
        this.time += this.speedMultiplier;
        this.getEnergyStorage().changeEnergyStored((int)this.processPower);
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * this.speedMultiplier);
        if (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        if (!this.setRecipeStats()) {
            this.time = 0.0;
            for (int i = 0; i < this.fluidInputSize; ++i) {
                if (!this.getVoidUnusableFluidInput(i)) continue;
                this.getTanks().get(i).setFluid(null);
            }
        } else {
            this.time = MathHelper.func_151237_a((double)(this.time - oldProcessTime), (double)0.0, (double)this.baseProcessTime);
        }
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
    }

    public void produceProducts() {
        int j;
        int i;
        for (i = this.itemInputSize + this.itemOutputSize; i < 2 * this.itemInputSize + this.itemOutputSize; ++i) {
            this.inventoryStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = this.fluidInputSize + this.fluidOutputSize; i < 2 * this.fluidInputSize + this.fluidOutputSize; ++i) {
            this.getTanks().get(i).setFluid(null);
        }
        if (!this.hasConsumed || this.recipe == null) {
            return;
        }
        for (j = 0; j < this.itemOutputSize; ++j) {
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getNextStackSize() <= 0) continue;
            if (((ItemStack)this.inventoryStacks.get(j + this.itemInputSize)).func_190926_b()) {
                this.inventoryStacks.set(j + this.itemInputSize, (Object)itemProduct.getNextStack());
                continue;
            }
            if (!((ItemStack)this.inventoryStacks.get(j + this.itemInputSize)).func_77969_a(itemProduct.getStack())) continue;
            ((ItemStack)this.inventoryStacks.get(j + this.itemInputSize)).func_190917_f(itemProduct.getNextStackSize());
        }
        for (j = 0; j < this.fluidOutputSize; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getNextStackSize() <= 0) continue;
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) {
                this.getTanks().get(j + this.fluidInputSize).setFluidStored(fluidProduct.getNextStack());
                continue;
            }
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual(fluidProduct.getStack())) continue;
            this.getTanks().get(j + this.fluidInputSize).changeFluidAmount(fluidProduct.getNextStackSize());
        }
        this.hasConsumed = false;
    }

    @Override
    public ProcessorRecipeHandler getRecipeHandler() {
        return this.recipeType.getRecipeHandler();
    }

    @Override
    public ProcessorRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public List<ItemStack> getItemInputs(boolean consumed) {
        return consumed ? this.inventoryStacks.subList(this.itemInputSize + this.itemOutputSize, 2 * this.itemInputSize + this.itemOutputSize) : this.inventoryStacks.subList(0, this.itemInputSize);
    }

    @Override
    public List<Tank> getFluidInputs(boolean consumed) {
        return consumed ? this.getTanks().subList(this.fluidInputSize + this.fluidOutputSize, 2 * this.fluidInputSize + this.fluidOutputSize) : this.getTanks().subList(0, this.fluidInputSize);
    }

    @Override
    public List<IItemIngredient> getItemIngredients() {
        return this.recipe.itemIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipe.fluidIngredients();
    }

    @Override
    public List<IItemIngredient> getItemProducts() {
        return this.recipe.itemProducts();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipe.fluidProducts();
    }

    @Override
    public List<Integer> getItemInputOrder() {
        ArrayList<Integer> itemInputOrder = new ArrayList<Integer>();
        List<IItemIngredient> itemIngredients = this.recipe.itemIngredients();
        for (int i = 0; i < this.itemInputSize; ++i) {
            int position = -1;
            for (int j = 0; j < itemIngredients.size(); ++j) {
                if (!itemIngredients.get(j).matches(this.getItemInputs(false).get(i), IngredientSorption.INPUT)) continue;
                position = j;
                break;
            }
            if (position == -1) {
                return AbstractRecipeHandler.INVALID;
            }
            itemInputOrder.add(position);
        }
        return itemInputOrder;
    }

    @Override
    public List<Integer> getFluidInputOrder() {
        ArrayList<Integer> fluidInputOrder = new ArrayList<Integer>();
        List<IFluidIngredient> fluidIngredients = this.recipe.fluidIngredients();
        for (int i = 0; i < this.fluidInputSize; ++i) {
            int position = -1;
            for (int j = 0; j < fluidIngredients.size(); ++j) {
                if (!fluidIngredients.get(j).matches((Object)this.getFluidInputs(false).get(i), IngredientSorption.INPUT)) continue;
                position = j;
                break;
            }
            if (position == -1) {
                return AbstractRecipeHandler.INVALID;
            }
            fluidInputOrder.add(position);
        }
        return fluidInputOrder;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < this.itemInputSize) {
                this.refreshRecipe();
                this.refreshActivity();
            } else if (slot < this.itemInputSize + this.itemOutputSize) {
                this.refreshActivity();
            }
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < this.itemInputSize) {
                this.refreshRecipe();
                this.refreshActivity();
            } else if (slot < this.itemInputSize + this.itemOutputSize) {
                this.refreshActivity();
            }
        }
    }

    public void func_70296_d() {
        this.refreshRecipe();
        this.refreshActivity();
        super.func_70296_d();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return false;
        }
        if (slot >= this.itemInputSize && slot < this.itemInputSize + this.itemOutputSize) {
            return false;
        }
        return NCConfig.smart_processor_input ? this.getRecipeHandler().isValidItemInput(stack, (ItemStack)this.inventoryStacks.get(slot), this.inputItemStacksExcludingSlot(slot)) : this.getRecipeHandler().isValidItemInput(stack);
    }

    public List<ItemStack> inputItemStacksExcludingSlot(int slot) {
        ArrayList<ItemStack> inputItemsExcludingSlot = new ArrayList<ItemStack>(this.getItemInputs(false));
        inputItemsExcludingSlot.remove(slot);
        return inputItemsExcludingSlot;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.slots;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return slot >= this.itemInputSize && slot < this.itemInputSize + this.itemOutputSize;
    }

    @Override
    public boolean isNextToFill(int tankNumber, FluidStack resource) {
        if (tankNumber >= this.fluidInputSize) {
            return false;
        }
        if (!this.getInputTanksSeparated()) {
            return true;
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (tankNumber == i || !this.getTanks().get(i).canFill() || this.getTanks().get(i).getFluid() == null || !this.getTanks().get(i).getFluid().isFluidEqual(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
    }
}

