/*
 * Decompiled with CFR 0.152.
 */
package nc.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.capability.radiation.source.IRadiationSource;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface ITile {
    public World getTileWorld();

    public BlockPos getTilePos();

    public void markTileDirty();

    public Block getTileBlockType();

    public IRadiationSource getRadiationSource();

    default public boolean shouldSaveRadiation() {
        return true;
    }

    public void setState(boolean var1);

    default public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
        this.refreshIsRedstonePowered(world, pos);
    }

    default public boolean checkIsRedstonePowered(World world, BlockPos pos) {
        return world.func_175640_z(pos);
    }

    default public void refreshIsRedstonePowered(World world, BlockPos pos) {
        this.setIsRedstonePowered(this.checkIsRedstonePowered(world, pos));
    }

    public boolean getIsRedstonePowered();

    public void setIsRedstonePowered(boolean var1);

    public boolean getAlternateComparator();

    public void setAlternateComparator(boolean var1);

    public boolean getRedstoneControl();

    public void setRedstoneControl(boolean var1);

    default public void markAndRefresh() {
        this.markAndRefresh(this.getTilePos(), this.getTileWorld().func_180495_p(this.getTilePos()));
    }

    default public void markAndRefresh(IBlockState newState) {
        this.markAndRefresh(this.getTilePos(), newState);
    }

    default public void markAndRefresh(BlockPos pos, IBlockState newState) {
        this.markTileDirty();
        this.getTileWorld().func_184138_a(pos, this.getTileWorld().func_180495_p(pos), newState, 3);
        this.getTileWorld().func_175685_c(pos, this.getTileBlockType(), true);
    }

    @Nonnull
    default public EnumFacing nonNullSide(@Nullable EnumFacing side) {
        return side == null ? EnumFacing.UP : side;
    }
}

