/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.util.ItemStackHelper;
import net.minecraft.item.ItemStack;

public class ItemIngredient
implements IItemIngredient {
    public ItemStack stack;

    public ItemIngredient(@Nonnull ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public ItemStack getStack() {
        return this.stack == null ? null : this.stack.func_77946_l();
    }

    @Override
    public String getIngredientName() {
        return ItemStackHelper.stackName(this.stack);
    }

    @Override
    public String getIngredientNamesConcat() {
        return ItemStackHelper.stackName(this.stack);
    }

    @Override
    public boolean matches(Object object, IngredientSorption type) {
        if (object instanceof ItemStack) {
            ItemStack itemstack = (ItemStack)object;
            if (!itemstack.func_77969_a(this.stack) || !ItemStackHelper.areItemStackTagsEqual(itemstack, this.stack)) {
                return false;
            }
            return type.checkStackSize(this.stack.func_190916_E(), itemstack.func_190916_E());
        }
        if (object instanceof OreIngredient) {
            OreIngredient oreStack = (OreIngredient)object;
            for (ItemStack itemStack : oreStack.cachedStackList) {
                if (!this.matches(itemStack, type)) continue;
                return type.checkStackSize(this.stack.func_190916_E(), oreStack.stackSize);
            }
        } else if (object instanceof ItemIngredient && this.matches(((ItemIngredient)object).stack, type)) {
            return type.checkStackSize(this.getMaxStackSize(), ((ItemIngredient)object).getMaxStackSize());
        }
        return false;
    }

    @Override
    public List<ItemStack> getInputStackList() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.stack});
    }

    @Override
    public List<ItemStack> getOutputStackList() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.stack});
    }

    @Override
    public int getMaxStackSize() {
        return this.stack.func_190916_E();
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        this.stack.func_190920_e(stackSize);
    }

    @Override
    public boolean isValid() {
        return this.stack != null;
    }
}

