/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import java.util.List;
import nc.config.NCConfig;
import nc.recipe.IRecipe;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.tile.generator.TileDecayGenerator;
import nc.tile.internal.fluid.Tank;
import nc.util.InfoHelper;
import nc.util.Lang;
import nc.util.RecipeHelper;
import net.minecraft.item.ItemStack;

public class ProcessorRecipe
implements IRecipe {
    protected List<IItemIngredient> itemIngredients;
    protected List<IItemIngredient> itemProducts;
    protected List<IFluidIngredient> fluidIngredients;
    protected List<IFluidIngredient> fluidProducts;
    private int itemInputSize;
    private int fluidInputSize;
    private int itemOutputSize;
    private int fluidOutputSize;
    protected List extras;
    public boolean isShapeless;

    public ProcessorRecipe(List<IItemIngredient> itemIngredientsList, List<IFluidIngredient> fluidIngredientsList, List<IItemIngredient> itemProductsList, List<IFluidIngredient> fluidProductsList, List extrasList, boolean shapeless) {
        this.itemIngredients = itemIngredientsList;
        this.fluidIngredients = fluidIngredientsList;
        this.itemProducts = itemProductsList;
        this.fluidProducts = fluidProductsList;
        this.itemInputSize = itemIngredientsList.size();
        this.fluidInputSize = fluidIngredientsList.size();
        this.itemOutputSize = itemProductsList.size();
        this.fluidOutputSize = fluidProductsList.size();
        this.extras = extrasList;
        this.isShapeless = shapeless;
    }

    @Override
    public List<IItemIngredient> itemIngredients() {
        return this.itemIngredients;
    }

    @Override
    public List<IFluidIngredient> fluidIngredients() {
        return this.fluidIngredients;
    }

    @Override
    public List<IItemIngredient> itemProducts() {
        return this.itemProducts;
    }

    @Override
    public List<IFluidIngredient> fluidProducts() {
        return this.fluidProducts;
    }

    @Override
    public List extras() {
        return this.extras;
    }

    @Override
    public boolean matchingInputs(List<ItemStack> itemInputs, List<Tank> fluidInputs) {
        return RecipeHelper.matchingIngredients(IngredientSorption.INPUT, this.itemIngredients, this.fluidIngredients, itemInputs, fluidInputs, this.isShapeless);
    }

    @Override
    public boolean matchingOutputs(List<ItemStack> itemOutputs, List<Tank> fluidOutputs) {
        return RecipeHelper.matchingIngredients(IngredientSorption.OUTPUT, this.itemProducts, this.fluidProducts, itemOutputs, fluidOutputs, this.isShapeless);
    }

    @Override
    public boolean matchingIngredients(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients) {
        return RecipeHelper.matchingIngredients(IngredientSorption.INPUT, this.itemIngredients, this.fluidIngredients, itemIngredients, fluidIngredients, this.isShapeless);
    }

    @Override
    public boolean matchingProducts(List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts) {
        return RecipeHelper.matchingIngredients(IngredientSorption.OUTPUT, this.itemProducts, this.fluidProducts, itemProducts, fluidProducts, this.isShapeless);
    }

    public double getProcessTime(double defaultProcessTime) {
        if (this.extras.isEmpty()) {
            return defaultProcessTime;
        }
        if (this.extras.get(0) instanceof Double) {
            return (Double)this.extras.get(0) * defaultProcessTime;
        }
        return defaultProcessTime;
    }

    public double getProcessPower(double defaultProcessPower) {
        if (this.extras.size() < 2) {
            return defaultProcessPower;
        }
        if (this.extras.get(1) instanceof Double) {
            return (Double)this.extras.get(1) * defaultProcessPower;
        }
        return defaultProcessPower;
    }

    public double getProcessRadiation() {
        if (this.extras.size() < 3) {
            return 0.0;
        }
        if (this.extras.get(2) instanceof Double) {
            return (Double)this.extras.get(2);
        }
        return 0.0;
    }

    public long getActiveFissionCoolingRate() {
        if (this.extras.isEmpty()) {
            return 0L;
        }
        if (this.extras.get(0) instanceof Long) {
            return (Long)this.extras.get(0);
        }
        return 0L;
    }

    public long getActiveFusionCoolingRate() {
        if (this.extras.size() < 2) {
            return 0L;
        }
        if (this.extras.get(1) instanceof Long) {
            return (Long)this.extras.get(1);
        }
        return 0L;
    }

    public double getDecayLifetime() {
        if (this.extras.isEmpty()) {
            return TileDecayGenerator.DEFAULT_LIFETIME;
        }
        if (this.extras.get(0) instanceof Double) {
            return (Double)this.extras.get(0) / (double)NCConfig.machine_update_rate;
        }
        return TileDecayGenerator.DEFAULT_LIFETIME;
    }

    public int getDecayPower() {
        if (this.extras.size() < 2) {
            return 0;
        }
        if (this.extras.get(1) instanceof Double) {
            return (int)((Double)this.extras.get(1) * (double)NCConfig.machine_update_rate / 20.0);
        }
        return 0;
    }

    public double getDecayRadiation() {
        if (this.extras.size() < 3) {
            return 0.0;
        }
        if (this.extras.get(2) instanceof Double) {
            return (Double)this.extras.get(2) / 20.0;
        }
        return 0.0;
    }

    public double getFissionFuelTime() {
        if (this.extras.isEmpty()) {
            return 1.0;
        }
        if (this.extras.get(0) instanceof Double) {
            return (Double)this.extras.get(0);
        }
        return 1.0;
    }

    public double getFissionFuelPower() {
        if (this.extras.size() < 2) {
            return 0.0;
        }
        if (this.extras.get(1) instanceof Double) {
            return (Double)this.extras.get(1);
        }
        return 0.0;
    }

    public double getFissionFuelHeat() {
        if (this.extras.size() < 3) {
            return 0.0;
        }
        if (this.extras.get(2) instanceof Double) {
            return (Double)this.extras.get(2);
        }
        return 0.0;
    }

    public double getFissionFuelRadiation() {
        if (this.extras.size() < 5) {
            return 0.0;
        }
        if (this.extras.get(4) instanceof Double) {
            return (Double)this.extras.get(4);
        }
        return 0.0;
    }

    public double getFusionComboTime() {
        if (this.extras.isEmpty()) {
            return 1.0;
        }
        if (this.extras.get(0) instanceof Double) {
            return (Double)this.extras.get(0);
        }
        return 1.0;
    }

    public double getFusionComboPower() {
        if (this.extras.size() < 2) {
            return 0.0;
        }
        if (this.extras.get(1) instanceof Double) {
            return (Double)this.extras.get(1);
        }
        return 0.0;
    }

    public double getFusionComboHeatVariable() {
        if (this.extras.size() < 3) {
            return 1000.0;
        }
        if (this.extras.get(2) instanceof Double) {
            return (Double)this.extras.get(2);
        }
        return 1000.0;
    }

    public double getFusionComboRadiation() {
        if (this.extras.size() < 4) {
            return 0.0;
        }
        if (this.extras.get(3) instanceof Double) {
            return (Double)this.extras.get(3);
        }
        return 0.0;
    }

    public double getSaltFissionFuelTime() {
        if (this.extras.isEmpty()) {
            return 1.0;
        }
        if (this.extras.get(0) instanceof Double) {
            return (Double)this.extras.get(0);
        }
        return 1.0;
    }

    public double getSaltFissionFuelHeat() {
        if (this.extras.size() < 2) {
            return 0.0;
        }
        if (this.extras.get(1) instanceof Double) {
            return (Double)this.extras.get(1);
        }
        return 0.0;
    }

    public double getSaltFissionFuelRadiation() {
        if (this.extras.size() < 3) {
            return 0.0;
        }
        if (this.extras.get(2) instanceof Double) {
            return (Double)this.extras.get(2);
        }
        return 0.0;
    }

    public double getCoolantHeaterCoolingRate() {
        if (this.extras.isEmpty()) {
            return 10.0;
        }
        if (this.extras.get(0) instanceof Double) {
            return (Double)this.extras.get(0);
        }
        return 0.0;
    }

    public String[] getCoolantHeaterJEIInfo() {
        if (this.extras.size() < 2) {
            return null;
        }
        if (this.extras.get(1) instanceof String) {
            return InfoHelper.formattedInfo(Lang.localise((String)this.extras.get(1)), new Object[0]);
        }
        return null;
    }

    public double getHeatExchangerProcessTime(double defaultProcessTime) {
        if (this.extras.isEmpty()) {
            return defaultProcessTime;
        }
        if (this.extras.get(0) instanceof Double) {
            return (Double)this.extras.get(0);
        }
        return defaultProcessTime;
    }

    public int getHeatExchangerInputTemperature() {
        if (this.extras.size() < 2) {
            return 0;
        }
        if (this.extras.get(1) instanceof Integer) {
            return (Integer)this.extras.get(1);
        }
        return 0;
    }

    public int getHeatExchangerOutputTemperature() {
        if (this.extras.size() < 3) {
            return 0;
        }
        if (this.extras.get(2) instanceof Integer) {
            return (Integer)this.extras.get(2);
        }
        return 0;
    }

    public boolean getHeatExchangerIsHeating() {
        return this.getHeatExchangerInputTemperature() - this.getHeatExchangerOutputTemperature() < 0;
    }

    public double getTurbinePowerPerMB() {
        if (this.extras.isEmpty()) {
            return 0.0;
        }
        if (this.extras.get(0) instanceof Double) {
            return (Double)this.extras.get(0);
        }
        return 0.0;
    }
}

