/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.network;

import io.netty.buffer.ByteBuf;
import nc.multiblock.network.MultiblockUpdatePacket;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.tile.TileTurbineController;
import net.minecraft.util.math.BlockPos;

public class TurbineUpdatePacket
extends MultiblockUpdatePacket {
    public boolean isTurbineOn;
    public boolean isProcessing;
    public double power;
    public double rawConductivity;
    public double totalExpansionLevel;
    public double idealTotalExpansionLevel;
    public int recipeRate;
    public int shaftWidth;
    public int bladeLength;
    public int noBladeSets;
    public int capacity;
    public int energy;

    public TurbineUpdatePacket() {
        this.messageValid = false;
    }

    public TurbineUpdatePacket(BlockPos pos, boolean isTurbineOn, double power, double rawConductivity, double totalExpansionLevel, double idealTotalExpansionLevel, int recipeRate, int shaftWidth, int bladeLength, int noBladeSets, boolean isProcessing, int capacity, int energy) {
        this.pos = pos;
        this.isTurbineOn = isTurbineOn;
        this.power = power;
        this.rawConductivity = rawConductivity;
        this.totalExpansionLevel = totalExpansionLevel;
        this.idealTotalExpansionLevel = idealTotalExpansionLevel;
        this.recipeRate = recipeRate;
        this.shaftWidth = shaftWidth;
        this.bladeLength = bladeLength;
        this.noBladeSets = noBladeSets;
        this.isProcessing = isProcessing;
        this.capacity = capacity;
        this.energy = energy;
        this.messageValid = true;
    }

    @Override
    public void readMessage(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.isTurbineOn = buf.readBoolean();
        this.power = buf.readDouble();
        this.rawConductivity = buf.readDouble();
        this.totalExpansionLevel = buf.readDouble();
        this.idealTotalExpansionLevel = buf.readDouble();
        this.recipeRate = buf.readInt();
        this.shaftWidth = buf.readInt();
        this.bladeLength = buf.readInt();
        this.noBladeSets = buf.readInt();
        this.isProcessing = buf.readBoolean();
        this.capacity = buf.readInt();
        this.energy = buf.readInt();
    }

    @Override
    public void writeMessage(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.isTurbineOn);
        buf.writeDouble(this.power);
        buf.writeDouble(this.rawConductivity);
        buf.writeDouble(this.totalExpansionLevel);
        buf.writeDouble(this.idealTotalExpansionLevel);
        buf.writeInt(this.recipeRate);
        buf.writeInt(this.shaftWidth);
        buf.writeInt(this.bladeLength);
        buf.writeInt(this.noBladeSets);
        buf.writeBoolean(this.isProcessing);
        buf.writeInt(this.capacity);
        buf.writeInt(this.energy);
    }

    public static class Handler
    extends MultiblockUpdatePacket.Handler<TurbineUpdatePacket, Turbine, TileTurbineController> {
        public Handler() {
            super(TileTurbineController.class);
        }
    }
}

