/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.tank;

import net.minecraftforge.fluids.FluidStack;
import openblocks.client.renderer.tileentity.tank.DoubledCoords;
import openblocks.client.renderer.tileentity.tank.GridConnection;
import openblocks.client.renderer.tileentity.tank.TankRenderUtils;

public class VerticalConnection
extends GridConnection {
    private FluidStack fluidTop;
    private FluidStack fluidBottom;
    private boolean bottomIsFull;
    private boolean isConnected;

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public void updateTopFluid(FluidStack stack) {
        this.fluidTop = TankRenderUtils.safeCopy(stack);
        this.updateConnection();
    }

    public void clearTopFluid() {
        this.fluidTop = null;
        this.isConnected = false;
    }

    public void updateBottomFluid(FluidStack stack, boolean isFull) {
        this.fluidBottom = TankRenderUtils.safeCopy(stack);
        this.bottomIsFull = isFull;
        this.updateConnection();
    }

    public void clearBottomFluid() {
        this.fluidBottom = null;
        this.bottomIsFull = false;
        this.isConnected = false;
    }

    private void updateConnection() {
        boolean sameLiquid = this.fluidTop != null && this.fluidBottom != null && this.fluidTop.isFluidEqual(this.fluidBottom);
        this.isConnected = sameLiquid && this.bottomIsFull;
    }

    public VerticalConnection(DoubledCoords coords) {
        super(coords);
    }
}

