/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.stations.SpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.network.BasePacket;

public class PacketSpaceStationInfo
extends BasePacket {
    SpaceObject spaceObject;
    int stationNumber;
    boolean isBeingDeleted;
    int direction;
    String clazzId;
    int fuelAmt;
    NBTTagCompound nbt;
    boolean hasWarpCores;

    public PacketSpaceStationInfo() {
    }

    public PacketSpaceStationInfo(int stationNumber, ISpaceObject spaceObject) {
        this.spaceObject = (SpaceObject)spaceObject;
        this.stationNumber = stationNumber;
    }

    public void write(ByteBuf out) {
        NBTTagCompound nbt = new NBTTagCompound();
        out.writeInt(this.stationNumber);
        boolean flag = false;
        if (!flag) {
            try {
                this.spaceObject.writeToNbt(nbt);
                PacketBuffer packetBuffer = new PacketBuffer(out);
                out.writeBoolean(false);
                packetBuffer.func_180714_a(SpaceObjectManager.getSpaceManager().getItentifierFromClass(this.spaceObject.getClass()));
                packetBuffer.func_150786_a(nbt);
                packetBuffer.writeInt(this.spaceObject.getFuelAmount());
                packetBuffer.writeBoolean(this.spaceObject.hasWarpCores);
                out.writeInt(this.spaceObject.getForwardDirection().ordinal());
            }
            catch (NullPointerException e) {
                out.writeBoolean(true);
                Logger.getLogger("advancedRocketry").warning("Dimension " + this.stationNumber + " has thrown an exception trying to write NBT, deleting!");
                DimensionManager.getInstance().deleteDimension(this.stationNumber);
            }
        } else {
            out.writeBoolean(flag);
        }
    }

    public void readClient(ByteBuf in) {
        PacketBuffer packetBuffer = new PacketBuffer(in);
        this.stationNumber = in.readInt();
        this.isBeingDeleted = in.readBoolean();
        if (!this.isBeingDeleted) {
            try {
                this.clazzId = packetBuffer.func_150789_c(127);
                this.nbt = packetBuffer.func_150793_b();
                this.fuelAmt = packetBuffer.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            this.hasWarpCores = in.readBoolean();
            this.direction = in.readInt();
        }
    }

    public void read(ByteBuf in) {
    }

    public void executeClient(EntityPlayer thePlayer) {
        if (this.isBeingDeleted) {
            if (DimensionManager.getInstance().isDimensionCreated(this.stationNumber)) {
                DimensionManager.getInstance().deleteDimension(this.stationNumber);
            }
        } else {
            ISpaceObject iObject = SpaceObjectManager.getSpaceManager().getSpaceStation(this.stationNumber);
            this.spaceObject = (SpaceObject)iObject;
            if (iObject == null) {
                ISpaceObject object = SpaceObjectManager.getSpaceManager().getNewSpaceObjectFromIdentifier(this.clazzId);
                object.readFromNbt(this.nbt);
                object.setProperties(DimensionProperties.createFromNBT(this.stationNumber, this.nbt));
                ((SpaceObject)object).setForwardDirection(EnumFacing.values()[this.direction]);
                SpaceObjectManager.getSpaceManager().registerSpaceObjectClient(object, object.getOrbitingPlanetId(), this.stationNumber);
                ((SpaceObject)object).setFuelAmount(this.fuelAmt);
                ((SpaceObject)object).hasWarpCores = this.hasWarpCores;
            } else {
                iObject.readFromNbt(this.nbt);
                ((SpaceObject)iObject).setForwardDirection(EnumFacing.values()[this.direction]);
                ((SpaceObject)iObject).setFuelAmount(this.fuelAmt);
                ((SpaceObject)iObject).hasWarpCores = this.hasWarpCores;
            }
        }
    }

    public void executeServer(EntityPlayerMP player) {
    }
}

