/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.opencomputers;

import com.google.common.base.Strings;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import li.cil.oc.common.tileentity.Robot;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.terraqueous.common.item.ItemColorizer;

public class EnvironmentColorizer
extends AbstractManagedEnvironment {
    private final EnvironmentHost host;
    private final Robot robot;

    public EnvironmentColorizer(EnvironmentHost host) {
        this.host = host;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Neighbors).withComponent("colorizer").create());
        this.robot = (Robot)host;
    }

    @Callback(direct=true, doc="function([direction:String]):String[3] -- returns ColorName, Hex(RRGGBB), Hex(RGB)")
    public Object[] getBlockColor(Context context, Arguments arguments) {
        EnumFacing facing = this.getFacing(arguments.count() > 0 ? arguments.optString(0, "front") : "front");
        BlockPos pos = this.getBlockPos(facing);
        short index = ItemColorizer.getBlockColorIndex(this.host.world(), pos, null);
        String name = this.indexToName(index);
        String[] hex = this.indexToHex(index);
        return new Object[]{name, hex[0], hex[1]};
    }

    @Callback(direct=true, doc="function(color:String[, direction:String]):boolean -- returns true if the block was colored")
    public Object[] setBlockColor(Context context, Arguments arguments) {
        boolean result = false;
        if (arguments.count() > 0 && !Strings.isNullOrEmpty((String)arguments.optString(0, ""))) {
            short index = this.getIndex(arguments.optString(0, ""));
            EnumFacing facing = this.getFacing(arguments.count() > 1 ? arguments.optString(1, "front") : "front");
            BlockPos pos = this.getBlockPos(facing);
            result = ItemColorizer.setBlockColor(this.host.world(), pos, null, facing.func_176734_d(), index);
            Function.sync((World)this.host.world(), (BlockPos)pos, (IBlockState)this.host.world().func_180495_p(pos));
        }
        return new Object[]{result};
    }

    @Callback(direct=true, doc="function(colorNameOrHex:String):String[3] -- returns ColorName, Hex(RRGGBB), Hex(RGB)")
    public Object[] getColorData(Context context, Arguments arguments) {
        short index = -1;
        if (arguments.count() > 0 && !Strings.isNullOrEmpty((String)arguments.optString(0, ""))) {
            index = this.getIndex(arguments.optString(0, ""));
        }
        String name = this.indexToName(index);
        String[] hex = this.indexToHex(index);
        return new Object[]{name, hex[0], hex[1]};
    }

    @Callback(direct=true, doc="function():String -- returns Accepted Direction Strings")
    public Object[] helpDirections(Context context, Arguments arguments) {
        return new Object[]{"up, down, north, south, east, west, front, back, left, right -- Default: front"};
    }

    private EnumFacing getFacing(String direction) {
        return EnumFacing.NORTH;
    }

    private BlockPos getBlockPos(EnumFacing facing) {
        BlockPos pos = new BlockPos(this.host.xPosition(), this.host.yPosition(), this.host.zPosition());
        return pos.func_177972_a(facing);
    }

    private String indexToName(short index) {
        if (index >= 0 && index <= 4096) {
            return EnumDyeColor.func_176764_b((int)RGB16Helper.getSimpleColor((short)index)).func_176762_d();
        }
        return "noColor";
    }

    private String[] indexToHex(short index) {
        String full = "000000";
        String hex = "000";
        if (index >= 0 && index <= 4096) {
            full = String.format("%X", RGB16Helper.getColor((short)index));
            if (full.length() > 6) {
                full = full.substring(full.length() - 6, full.length());
            }
            byte[] values = RGB16Helper.getValuesFrom((short)index);
            hex = String.format("%X", values[0]) + String.format("%X", values[1]) + String.format("%X", values[2]);
        }
        return new String[]{full, hex};
    }

    private short getIndex(String input) {
        if ((input = input.toLowerCase()).length() == 3 && input.matches("[0-9a-f]*")) {
            return RGB16Helper.getIndexFor((int)Integer.parseInt("" + input.charAt(0), 16), (int)Integer.parseInt("" + input.charAt(1), 16), (int)Integer.parseInt("" + input.charAt(2), 16));
        }
        if (input.length() == 6 && input.matches("[0-9a-f]*")) {
            return RGB16Helper.getIndexFor((int)Integer.parseInt(input, 16));
        }
        return RGB16Helper.getIndexFor((String)input);
    }
}

