/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.crafttweaker;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.terraqueous.api.machines.IEnderTableRecipe;
import shetiphian.terraqueous.modintegration.crafttweaker.EnderTableButtonOption;

class EnderTableRecipe
implements IEnderTableRecipe {
    private final IIngredient enchant;
    private final EnderTableButtonOption first;
    private final EnderTableButtonOption second;
    private final EnderTableButtonOption third;

    static EnderTableRecipe create(IItemStack result, IIngredient inputItem, int experienceCost, float enchantPower, String tooltip, boolean obfuscateTooltip, IIngredient inputMaterial) {
        return EnderTableRecipe.create(inputItem, null, EnderTableButtonOption.create(result, inputMaterial, experienceCost, enchantPower, tooltip, obfuscateTooltip), null);
    }

    static EnderTableRecipe create(IIngredient inputItem, EnderTableButtonOption first, EnderTableButtonOption second, EnderTableButtonOption third) {
        boolean[] nullcheck = new boolean[]{first == null, second == null, third == null};
        if (inputItem == null || nullcheck[0] && nullcheck[1] && nullcheck[2]) {
            return null;
        }
        if (nullcheck[1] && nullcheck[2]) {
            return new EnderTableRecipe(inputItem, null, first, null);
        }
        if (nullcheck[0] && nullcheck[2]) {
            return new EnderTableRecipe(inputItem, null, second, null);
        }
        if (nullcheck[0] && nullcheck[1]) {
            return new EnderTableRecipe(inputItem, null, third, null);
        }
        if (nullcheck[0]) {
            return new EnderTableRecipe(inputItem, second, third, null);
        }
        if (nullcheck[1]) {
            return new EnderTableRecipe(inputItem, first, third, null);
        }
        if (nullcheck[2]) {
            return new EnderTableRecipe(inputItem, first, second, null);
        }
        return new EnderTableRecipe(inputItem, first, second, third);
    }

    private EnderTableRecipe(IIngredient inputItem, EnderTableButtonOption first, EnderTableButtonOption second, EnderTableButtonOption third) {
        this.enchant = inputItem;
        this.first = first;
        this.second = second;
        this.third = third;
    }

    private EnderTableButtonOption getButtonOption(IEnderTableRecipe.EnumOption option) {
        switch (option) {
            case FIRST: {
                return this.first;
            }
            case SECOND: {
                return this.second;
            }
            case THIRD: {
                return this.third;
            }
        }
        return null;
    }

    @Override
    public Pair<Ingredient, Ingredient> getInput(@Nonnull IEnderTableRecipe.EnumOption option) {
        EnderTableButtonOption buttonOption = this.getButtonOption(option);
        if (buttonOption != null) {
            return Pair.of((Object)EnderTableRecipe.convert(this.enchant), (Object)EnderTableRecipe.convert(buttonOption.getMaterial()));
        }
        return Pair.of((Object)Ingredient.field_193370_a, (Object)Ingredient.field_193370_a);
    }

    private static Ingredient convert(IIngredient input) {
        if (input != null) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (IItemStack iItemStack : input.getItemArray()) {
                ItemStack stack;
                Object object = iItemStack.getInternal();
                if (!(object instanceof ItemStack) || (stack = (ItemStack)object).func_190926_b()) continue;
                list.add(stack);
            }
            if (!list.isEmpty()) {
                return Ingredient.func_193369_a((ItemStack[])list.toArray(new ItemStack[list.size()]));
            }
        }
        return Ingredient.field_193370_a;
    }

    @Override
    public boolean matches(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, float enchantPower, @Nonnull IEnderTableRecipe.EnumOption option, World world) {
        EnderTableButtonOption buttonOption;
        if (this.checkMatch(this.enchant, enchantStack, false, 1) && (buttonOption = this.getButtonOption(option)) != null) {
            return enchantPower >= buttonOption.getEPower() && this.checkMatch(buttonOption.getMaterial(), materialStack, true, buttonOption.getMatCost());
        }
        return false;
    }

    private boolean checkMatch(IIngredient target, ItemStack tableItem, boolean checksize, int required) {
        if (target == null) {
            return tableItem.func_190926_b();
        }
        if (checksize && (tableItem.func_190926_b() || tableItem.func_190916_E() < required)) {
            return false;
        }
        return target.matches(CraftTweakerMC.getIItemStack((ItemStack)tableItem));
    }

    @Override
    @Nonnull
    public ItemStack getResult(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        EnderTableButtonOption buttonOption = this.getButtonOption(option);
        return buttonOption != null ? buttonOption.getOutput() : ItemStack.field_190927_a;
    }

    @Override
    public int getExpCost(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        EnderTableButtonOption buttonOption = this.getButtonOption(option);
        return buttonOption != null ? buttonOption.getExpCost() : 0;
    }

    @Override
    public int getMaterialCost(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        EnderTableButtonOption buttonOption = this.getButtonOption(option);
        return buttonOption != null ? buttonOption.getMatCost() : 0;
    }

    @Override
    public float getEPower(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        EnderTableButtonOption buttonOption = this.getButtonOption(option);
        return buttonOption != null ? buttonOption.getEPower() : 0.0f;
    }

    @Override
    public String getTooltip(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        EnderTableButtonOption buttonOption = this.getButtonOption(option);
        return buttonOption != null ? buttonOption.getTooltip() : "";
    }

    @Override
    public boolean obfuscateTooltip(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        EnderTableButtonOption buttonOption = this.getButtonOption(option);
        return buttonOption == null || buttonOption.isObfuscate();
    }

    @Override
    public void doneEnchant(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, float enchantPower, @Nonnull IEnderTableRecipe.EnumOption option, World world) {
    }
}

