/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.crafttweaker;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;

class EnderTableButtonOption {
    private final IIngredient material;
    private final ItemStack output;
    private final int expCost;
    private final int matCost;
    private final float ePower;
    private final String tooltip;
    private final boolean obfuscate;

    static EnderTableButtonOption create(IItemStack result, IIngredient inputMaterial, int experienceCost, float enchantPower, String tooltip, boolean obfuscate) {
        ItemStack output = CraftTweakerMC.getItemStack((IItemStack)result);
        if (output.func_190926_b()) {
            return null;
        }
        return new EnderTableButtonOption(output, inputMaterial, experienceCost, enchantPower, tooltip, obfuscate);
    }

    private EnderTableButtonOption(ItemStack result, IIngredient inputMaterial, int experienceCost, float enchantPower, String tooltip, boolean obfuscate) {
        this.output = result;
        this.material = inputMaterial;
        this.matCost = inputMaterial != null ? inputMaterial.getAmount() : 0;
        this.expCost = Math.max(0, experienceCost);
        this.ePower = Math.max(0.0f, enchantPower);
        this.tooltip = tooltip == null ? "" : tooltip;
        this.obfuscate = obfuscate;
    }

    public IIngredient getMaterial() {
        return this.material;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public int getExpCost() {
        return this.expCost;
    }

    public int getMatCost() {
        return this.matCost;
    }

    public float getEPower() {
        return this.ePower;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean isObfuscate() {
        return this.obfuscate;
    }
}

