/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.IWorldGenerator;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.common.worldgen.GenClouds;
import shetiphian.terraqueous.common.worldgen.GenDoodads;
import shetiphian.terraqueous.common.worldgen.GenFlowers;
import shetiphian.terraqueous.common.worldgen.GenPlants;
import shetiphian.terraqueous.common.worldgen.GenTrees;

public abstract class GenBase
implements IWorldGenerator {
    public static HashBasedTable<ChunkPos, DecorateBiomeEvent.Decorate.EventType, Boolean> GEN_CHECK = HashBasedTable.create();
    private static HashMap<Class, List<DimensionType>> DIM_BLACKLIST = new HashMap();
    boolean mustHaveSky = true;
    boolean ignoreBiome;
    boolean noOffset;

    GenBase() {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        List<DimensionType> dimensionBlacklist;
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c) {
            if (Configuration.GENERATOR.generateInFlatWorlds) {
                this.ignoreBiome = true;
            } else {
                return;
            }
        }
        if (!world.field_73011_w.func_191066_m() && this.mustHaveSky) {
            return;
        }
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        if (DIM_BLACKLIST.isEmpty()) {
            GenBase.buildBlacklist();
        }
        if ((dimensionBlacklist = DIM_BLACKLIST.get(this.getClass())) != null && dimensionBlacklist.contains(world.field_73011_w.func_186058_p())) {
            return;
        }
        if (this.noOffset) {
            this.generate(random, world, new BlockPos(blockX, world.func_72940_L(), blockZ), new ChunkPos(chunkX, chunkZ));
        } else {
            this.generate(random, world, new BlockPos(blockX + 8, world.func_72940_L(), blockZ + 8), new ChunkPos(chunkX, chunkZ));
        }
    }

    protected abstract void generate(Random var1, World var2, BlockPos var3, ChunkPos var4);

    BlockPos getRandomXZ(Random random, BlockPos pos) {
        return pos.func_177982_a(random.nextInt(6) + random.nextInt(6) + random.nextInt(6), 0, random.nextInt(6) + random.nextInt(6) + random.nextInt(6));
    }

    BlockPos getTopBlock(World world, BlockPos pos) {
        boolean spot_good;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos sPos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 24, pos.func_177952_p());
        boolean bl = spot_good = world.func_175623_d(sPos) || chunk.func_177435_g(sPos).func_185904_a().func_76224_d();
        while (sPos.func_177956_o() >= 0) {
            BlockPos downPos = sPos.func_177977_b();
            if (!world.func_175623_d(downPos)) {
                IBlockState state = chunk.func_177435_g(downPos);
                if (spot_good && (state.func_185904_a().func_76224_d() || state.func_177230_c() instanceof BlockDoublePlant || state.func_185904_a().func_76230_c() && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, downPos) && !state.func_177230_c().isFoliage((IBlockAccess)world, downPos))) break;
                spot_good = state.func_185904_a().func_76224_d();
            } else {
                spot_good = true;
            }
            sPos = downPos;
        }
        return sPos;
    }

    boolean canGenerateType(World world, ChunkPos chunkPos, Random random, DecorateBiomeEvent.Decorate.EventType type) {
        if (!Configuration.GENERATOR.ignoreGenerationEvents) {
            if (!GEN_CHECK.contains((Object)chunkPos, (Object)type)) {
                GEN_CHECK.put((Object)chunkPos, (Object)type, (Object)TerrainGen.decorate((World)world, (Random)random, (BlockPos)chunkPos.func_180331_a(0, world.func_72940_L(), 0), (DecorateBiomeEvent.Decorate.EventType)type));
            }
            return (Boolean)GEN_CHECK.get((Object)chunkPos, (Object)type);
        }
        return true;
    }

    public String getName() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public String getModID() {
        return "terraqueous";
    }

    public static void clearBlacklist() {
        DIM_BLACKLIST.clear();
        GenBase.buildBlacklist();
    }

    private static void buildBlacklist() {
        for (DimensionType type : DimensionType.values()) {
            GenBase.checkAndAdd(type, GenClouds.class, Configuration.GENERATOR.DIM_BLACKLIST.clouds);
            GenBase.checkAndAdd(type, GenDoodads.class, Configuration.GENERATOR.DIM_BLACKLIST.doodads);
            GenBase.checkAndAdd(type, GenFlowers.class, Configuration.GENERATOR.DIM_BLACKLIST.flowers);
            GenBase.checkAndAdd(type, GenPlants.class, Configuration.GENERATOR.DIM_BLACKLIST.plants);
            GenBase.checkAndAdd(type, GenTrees.class, Configuration.GENERATOR.DIM_BLACKLIST.trees);
        }
    }

    private static void checkAndAdd(DimensionType type, Class clazz, String[] config) {
        String[] global = Configuration.GENERATOR.DIM_BLACKLIST.global;
        String[] strings = Arrays.copyOf(global, global.length + config.length);
        System.arraycopy(config, 0, strings, global.length, config.length);
        if (strings.length > 0) {
            List list = DIM_BLACKLIST.getOrDefault(clazz, new ArrayList());
            for (String name : strings) {
                try {
                    if (name.startsWith("#")) {
                        int id = Integer.parseInt(name.substring(1));
                        if (type.func_186068_a() != id) continue;
                        list.add(type);
                        continue;
                    }
                    if (!type.func_186065_b().toLowerCase().matches(name.toLowerCase())) continue;
                    list.add(type);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!list.isEmpty() && !DIM_BLACKLIST.containsKey(clazz)) {
                DIM_BLACKLIST.put(clazz, list);
            }
        }
    }
}

