/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.terraqueous.Values;

public class TileEntityFlowerPot
extends TileEntityBase
implements IRGB16_Tile {
    private RGB16 rgb16;
    private ItemStack plantStack = null;
    private EnumFacing plantFacing = EnumFacing.SOUTH;
    private RenderStyle renderStyle = null;

    public void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74777_a("rgb16", this.getRGB16(null).getIndex());
        if (this.plantStack != null) {
            nbtTag.func_74782_a("pStack", (NBTBase)this.plantStack.func_77955_b(new NBTTagCompound()));
            nbtTag.func_74778_a("pFacing", this.plantFacing.func_176610_l());
        }
    }

    public void processNBT(NBTTagCompound nbtTag) {
        this.loadRGB16(nbtTag.func_74765_d("rgb16"));
        if (nbtTag.func_74764_b("pStack")) {
            this.plantStack = new ItemStack(nbtTag.func_74775_l("pStack"));
            this.plantFacing = EnumFacing.func_176739_a((String)nbtTag.func_74779_i("pFacing"));
        }
    }

    private boolean loadRGB16(short rgbIndex) {
        return rgbIndex > -1 && rgbIndex < 4096 && this.getRGB16(null).setValues(rgbIndex);
    }

    public RGB16 getRGB16(EntityPlayer player) {
        if (this.rgb16 == null) {
            this.rgb16 = new RGB16(10, 5, 4);
        }
        return this.rgb16;
    }

    public boolean setRGB16(short rgbIndex, EntityPlayer player) {
        boolean result = this.loadRGB16(rgbIndex);
        if (result) {
            Function.syncTile((TileEntity)this);
        }
        return result;
    }

    public ItemStack getPlantStack() {
        return this.plantStack;
    }

    public boolean setPlantStack(ItemStack stack) {
        if (stack == null || stack.func_77973_b() instanceof ItemBlock) {
            this.plantStack = stack;
            if (this.func_145831_w().field_72995_K) {
                this.setRenderStyle();
            }
            return true;
        }
        return false;
    }

    public EnumFacing getPlantFacing() {
        return this.plantFacing;
    }

    public void setPlantFacing(EnumFacing facing) {
        this.plantFacing = facing.func_176736_b() < 0 ? EnumFacing.SOUTH : facing;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderStyle getRenderStyle() {
        if (this.renderStyle == null) {
            this.setRenderStyle();
        }
        return this.renderStyle;
    }

    @SideOnly(value=Side.CLIENT)
    private void setRenderStyle() {
        if (this.plantStack == null) {
            this.renderStyle = RenderStyle.NONE;
            return;
        }
        ResourceLocation resourceName = this.plantStack.func_77973_b().getRegistryName();
        if (resourceName != null) {
            String name = resourceName.func_110624_b() + ":" + resourceName.func_110623_a();
            if (Values.flowerpotOverrides.contains((Object)name, (Object)this.plantStack.func_77952_i())) {
                this.renderStyle = RenderStyle.getStyle((Byte)Values.flowerpotOverrides.get((Object)name, (Object)this.plantStack.func_77952_i()));
                return;
            }
            if (Values.flowerpotOverrides.contains((Object)name, (Object)-1)) {
                this.renderStyle = RenderStyle.getStyle((Byte)Values.flowerpotOverrides.get((Object)name, (Object)-1));
                return;
            }
        }
        this.renderStyle = RenderStyle.DEFAULT;
    }

    public static enum RenderStyle {
        CROSS,
        BLOCK,
        PANE,
        TALL,
        DEFAULT,
        NONE;


        static RenderStyle getStyle(byte style) {
            return RenderStyle.values()[MathHelper.func_76125_a((int)style, (int)0, (int)RenderStyle.values().length)];
        }
    }
}

