/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;

public class TileEntityDoodad
extends TileEntity {
    private double place;
    private List<String> modelGroup = new ArrayList<String>();
    private final IModelState modelState = new ModelState();

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        this.place = this.func_174877_v().func_177958_n() * this.func_174877_v().func_177952_p() / (this.func_174877_v().func_177956_o() != 0 ? this.func_174877_v().func_177956_o() : 1);
        if (this.place < 0.0) {
            this.place = 1.0 - this.place;
        }
    }

    public IModelState getModelState(String prefix, int group) {
        if (this.modelGroup.isEmpty()) {
            this.modelGroup.add(prefix + ((int)(this.place % (double)group) + 1));
        }
        return this.modelState;
    }

    private class ModelState
    implements IModelState {
        private TRSRTransformation transform;

        private ModelState() {
        }

        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            UnmodifiableIterator parts;
            if (part.isPresent() && (parts = Models.getParts((IModelPart)part.get())).hasNext()) {
                String name = (String)parts.next();
                if (!parts.hasNext() && !TileEntityDoodad.this.modelGroup.contains(name)) {
                    return Optional.of(TRSRTransformation.identity());
                }
            }
            return Optional.of(this.getTransform());
        }

        private TRSRTransformation getTransform() {
            if (this.transform == null) {
                Matrix4f matrix = new Matrix4f(TRSRTransformation.getMatrix((EnumFacing)EnumFacing.NORTH));
                matrix.setScale(0.5f);
                matrix.setTranslation(new Vector3f(0.5f, 0.0f, 0.5f));
                float rotation = (float)(TileEntityDoodad.this.place % 12.0 * 30.0);
                matrix.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, -rotation * ((float)Math.PI / 180)));
                this.transform = new TRSRTransformation(matrix);
            }
            return this.transform;
        }
    }
}

