/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.tileentity.TileEntityFacingBase;

public abstract class TileEntityCrafting
extends TileEntityFacingBase
implements ISidedWrapper {
    public InventoryInternal inventory;
    ISidedWrapper.SidedWrapper sidedWrapper;

    protected boolean isFacingValid(EnumFacing facing) {
        return facing != null && facing.func_176740_k() != EnumFacing.Axis.Y;
    }

    protected void buildNBT(NBTTagCompound nbtTag) {
        this.sidedWrapper.writeToNBT(nbtTag);
    }

    protected void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        this.inventory.writeToNBT(nbtTag, "items");
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.sidedWrapper.readFromNBT(nbtTag);
    }

    protected void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        this.inventory.readFromNBT(nbtTag, nbtTag.func_74764_b("items") ? "items" : "inventoryItems");
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.sidedWrapper.getWrapper(this.getFacing(), facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.sidedWrapper.getWrapper(this.getFacing(), facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public ISidedWrapper.SidedWrapper getSidedWrapper() {
        return this.sidedWrapper;
    }

    public boolean rotateBlock(EnumFacing axis) {
        this.setFacing(this.getFacing().func_176746_e());
        Function.syncTile((TileEntity)this);
        return true;
    }

    ItemStack itemReader(NBTTagCompound nbtTag, String name) {
        NBTBase compound = nbtTag.func_74781_a(name);
        return compound instanceof NBTTagCompound ? new ItemStack((NBTTagCompound)compound) : ItemStack.field_190927_a;
    }

    ItemStack[] listReader(NBTTagList listStacks, int length) {
        ItemStack[] stacks = new ItemStack[length];
        for (int slot = 0; slot < stacks.length; ++slot) {
            stacks[slot] = ItemStack.field_190927_a;
        }
        for (int index = 0; index < listStacks.func_74745_c(); index = (int)((byte)(index + 1))) {
            NBTTagCompound entry = listStacks.func_150305_b(index);
            byte slot = entry.func_74771_c("slot");
            if (slot < 0 || slot >= length) continue;
            stacks[slot] = new ItemStack(entry);
        }
        return stacks;
    }

    public byte getOutputSlot(ItemStack[] itemsOutput, ItemStack item, boolean smelted) {
        if (smelted) {
            item = this.getSmelted(item);
        }
        if (item != null) {
            boolean useFreeSlot = !item.func_77985_e();
            for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
                for (byte slot = 0; slot < itemsOutput.length; slot = (byte)(slot + 1)) {
                    if (!this.canPlaceInSlot(itemsOutput[slot], item, useFreeSlot)) continue;
                    return slot;
                }
                useFreeSlot = true;
            }
        }
        return -1;
    }

    boolean canPlaceInSlot(ItemStack output, ItemStack item, boolean useFreeSlot) {
        if (useFreeSlot) {
            return output.func_190926_b();
        }
        return !output.func_190926_b() && output.func_77969_a(item) && output.func_190916_E() + item.func_190916_E() <= item.func_77976_d();
    }

    public boolean isItemSmeltable(ItemStack input) {
        return !this.getSmelted(input).func_190926_b();
    }

    @Nonnull
    ItemStack getSmelted(ItemStack input) {
        if (input.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(input);
        return !smelted.func_190926_b() ? smelted.func_77946_l() : ItemStack.field_190927_a;
    }

    public ITextComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }
}

