/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.IBonemealable;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.misc.PlantFunctions;
import shetiphian.terraqueous.common.worldgen.GenTrees;

public class BlockTreeSapling
extends Block
implements IBonemealable {
    private static final AxisAlignedBB AABB_SAPLING = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);
    private GenTrees genTrees = new GenTrees();

    public BlockTreeSapling() {
        super(Material.field_151584_j);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.2f);
        this.func_149675_a(true);
        this.func_149713_g(1);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PlantAPI.TREEVARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PlantAPI.TREEVARIANT, (Comparable)((Object)PlantAPI.TreeType.byID(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return PlantAPI.getTreeType(state).getID();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity, boolean p_185477_7_) {
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)Block.field_185506_k);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB_SAPLING;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos pos2) {
        if (world.field_72995_K) {
            return;
        }
        BlockPos gPos = pos.func_177977_b();
        IBlockState gState = world.func_180495_p(gPos);
        Block gBlock = gState.func_177230_c();
        if (!gBlock.canSustainPlant(gState, (IBlockAccess)world, gPos, EnumFacing.UP, (IPlantable)Blocks.field_150345_g)) {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        }
        super.func_189540_a(state, world, pos, neighbor, pos2);
    }

    public boolean canGrow(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean canUseBonemeal(World world, Random random, BlockPos pos, IBlockState state) {
        return random.nextFloat() < 0.45f;
    }

    public void grow(World world, Random rand, BlockPos pos, IBlockState state) {
        this.genTrees.growSapling(world.field_73012_v, world, pos, PlantAPI.getTreeType(state));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (PlantFunctions.canSaplingGrow((IBlockAccess)world, pos, PlantAPI.getTreeType(state))) {
            this.grow(world, rand, pos, state);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

