/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockTallGrass
extends net.minecraft.block.BlockTallGrass
implements IColored {
    public BlockTallGrass() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS));
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149675_a(true);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K || !world.func_72935_r()) {
            return;
        }
        BlockTallGrass.EnumType type = (BlockTallGrass.EnumType)state.func_177229_b((IProperty)net.minecraft.block.BlockTallGrass.field_176497_a);
        if (type == BlockTallGrass.EnumType.FERN && random.nextInt(30) == 0) {
            super.func_176474_b(world, random, pos, state);
        } else if (type == BlockTallGrass.EnumType.GRASS) {
            if (PlantFunctions.canSpread(world, pos, PlantAPI.PlantType.GRASS) && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Values.blockFlowerPot) {
                this.spreadGrass(world, pos, state, random);
            } else if (PlantFunctions.canGrow(world, pos, PlantAPI.PlantType.GRASS)) {
                super.func_176474_b(world, random, pos, state);
            }
        }
    }

    private void spreadGrass(World world, BlockPos pos, IBlockState state, Random random) {
        byte maxAttempts = PlantFunctions.getMaxPlacementAttempts((IBlockAccess)world, pos, PlantAPI.PlantType.GRASS);
        byte[] spreadRadius = PlantFunctions.getSpreadRadius((IBlockAccess)world, pos, PlantAPI.PlantType.GRASS);
        for (byte attempt = 0; attempt < maxAttempts; attempt = (byte)(attempt + 1)) {
            BlockPos sPos = pos.func_177982_a(this.getOffset(spreadRadius[0], random), this.getOffset(spreadRadius[1], random), this.getOffset(spreadRadius[0], random));
            if (world.func_175623_d(sPos) && this.func_180671_f(world, sPos, state) && this.canSpreadHere(world, sPos)) {
                Function.setBlock((World)world, (BlockPos)sPos, (IBlockState)state, (boolean)true);
                return;
            }
            pos = sPos;
        }
    }

    private int getOffset(int spreadRadius, Random random) {
        return random.nextInt(spreadRadius) - random.nextInt(spreadRadius);
    }

    private boolean canSpreadHere(World world, BlockPos pos) {
        if (Values.blockFlowerPot != null && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Values.blockFlowerPot) {
            return false;
        }
        int touching = 0;
        int total = 0;
        int air = 0;
        for (int sX = -1; sX < 2; ++sX) {
            for (int sZ = -1; sZ < 2; ++sZ) {
                if (sX == 0 && sZ == 0) continue;
                BlockPos sPos = pos.func_177982_a(sX, 0, sZ);
                if (world.func_180495_p(sPos).func_177230_c() == this) {
                    total = (byte)(total + 1);
                    if (sX == 0 || sZ == 0) {
                        touching = (byte)(touching + 1);
                    }
                }
                if (!world.func_175623_d(sPos)) continue;
                air = (byte)(air + 1);
            }
        }
        return touching < 2 && total < 2 && air > 4;
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Values.blockFlowerPot) {
            return true;
        }
        Chunk chunk = world.func_175726_f(pos);
        Biome biome = chunk.func_177411_a(pos, world.func_72959_q());
        if (BiomeDictionary.hasAnyType((Biome)biome) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150458_ak && super.func_180671_f(world, pos, state);
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 100;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)Blocks.field_150329_H), 1, state.func_177230_c().func_176201_c(state));
    }

    public int getColorFor(IColored.Data data, int index) {
        if (data.state != null && data.state.func_177229_b((IProperty)net.minecraft.block.BlockTallGrass.field_176497_a) == BlockTallGrass.EnumType.DEAD_BUSH) {
            return 0xFFFFFF;
        }
        return Minecraft.func_71410_x().func_184125_al().func_186724_a(Blocks.field_150329_H.func_176223_P(), data.world, data.pos, index);
    }
}

