/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.common.Function;
import shetiphian.core.common.MaterialImmovable;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.tileentity.TileEntityDoodad;

public class BlockDoodad
extends Block {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static Map<EnumType, List<DropEntry>> cacheDropList = new HashMap<EnumType, List<DropEntry>>();
    private static final AxisAlignedBB AABB_ENDIMIUM = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB AABB_BURNIUM = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);
    private static final AxisAlignedBB AABB_FLAT = new AxisAlignedBB(0.05, 0.0, 0.05, 0.95, 0.15, 0.95);

    public BlockDoodad() {
        super((Material)MaterialImmovable.TRANSLUCENT);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149672_a(SoundType.field_185851_d);
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            EnumType type = BlockDoodad.getEnumType(state);
            this.setHarvestLevel(type.getTool(), type.getToolLevel(), state);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{VARIANT}, new IUnlistedProperty[]{Properties.AnimationProperty});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return BlockDoodad.getEnumType(state).getValue();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDoodad && state.func_177230_c() == this) {
            EnumType type = BlockDoodad.getEnumType(state);
            return ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)((TileEntityDoodad)tile).getModelState(type.getPrefix(), type == EnumType.GLASSSHARDS ? 1 : 5));
        }
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityDoodad();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        EnumType type = BlockDoodad.getEnumType(state);
        return type == EnumType.BONE || type == EnumType.GLASSSHARDS ? 0.25f : 0.75f;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockDoodad.getEnumType(state);
        if (type == EnumType.ENDIMIUM) {
            return AABB_ENDIMIUM;
        }
        if (type == EnumType.BURNIUM) {
            return AABB_BURNIUM;
        }
        return AABB_FLAT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos pos2) {
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP, false)) {
            this.func_176226_b(world, pos, state, 0);
            Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumType type = BlockDoodad.getEnumType(state);
        switch (type) {
            case BRANCH: {
                this.buildDrops(drops, fortune, type, Configuration.TWEAKS.DOODADS.STICK.dropAttempts, Configuration.TWEAKS.DOODADS.STICK.dropChance, Configuration.TWEAKS.DOODADS.STICK.dropCount);
                break;
            }
            case STONE: {
                this.buildDrops(drops, fortune, type, Configuration.TWEAKS.DOODADS.STONE.dropAttempts, Configuration.TWEAKS.DOODADS.STONE.dropChance, Configuration.TWEAKS.DOODADS.STONE.dropCount);
                break;
            }
            case BONE: {
                this.buildDrops(drops, fortune, type, Configuration.TWEAKS.DOODADS.BONE.dropAttempts, Configuration.TWEAKS.DOODADS.BONE.dropChance, Configuration.TWEAKS.DOODADS.BONE.dropCount);
                break;
            }
            case SANDSTONE: {
                this.buildDrops(drops, fortune, type, Configuration.TWEAKS.DOODADS.SANDSTONE.dropAttempts, Configuration.TWEAKS.DOODADS.SANDSTONE.dropChance, Configuration.TWEAKS.DOODADS.SANDSTONE.dropCount);
                break;
            }
            case REDSANDSTONE: {
                this.buildDrops(drops, fortune, type, Configuration.TWEAKS.DOODADS.REDSANDSTONE.dropAttempts, Configuration.TWEAKS.DOODADS.REDSANDSTONE.dropChance, Configuration.TWEAKS.DOODADS.REDSANDSTONE.dropCount);
                break;
            }
            case ENDIMIUM: {
                this.buildDrops(drops, fortune, type, Configuration.TWEAKS.DOODADS.ENDIMIUM.dropAttempts, Configuration.TWEAKS.DOODADS.ENDIMIUM.dropChance, Configuration.TWEAKS.DOODADS.ENDIMIUM.dropCount);
                break;
            }
            case BURNIUM: {
                this.buildDrops(drops, fortune, type, Configuration.TWEAKS.DOODADS.BURNIUM.dropAttempts, Configuration.TWEAKS.DOODADS.BURNIUM.dropChance, Configuration.TWEAKS.DOODADS.BURNIUM.dropCount);
                break;
            }
            case GLASSSHARDS: {
                drops.add((Object)new ItemStack((Block)this, 1, 6));
            }
        }
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        EnumType type = BlockDoodad.getEnumType(state);
        if (entity instanceof EntityDragon && type == EnumType.ENDIMIUM) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        boolean hasBoots;
        EnumType type = BlockDoodad.getEnumType(state);
        boolean bl = hasBoots = entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
        if (type == EnumType.ENDIMIUM || type == EnumType.BURNIUM || type == EnumType.GLASSSHARDS && !hasBoots) {
            entity.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float f) {
        boolean hasBoots;
        EnumType type = BlockDoodad.getEnumType(world.func_180495_p(pos));
        boolean bl = hasBoots = entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
        if (type == EnumType.ENDIMIUM || type == EnumType.BURNIUM || type == EnumType.GLASSSHARDS) {
            entity.func_70097_a(DamageSource.field_76377_j, type == EnumType.GLASSSHARDS && hasBoots ? 1.0f : 2.5f);
        }
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = BlockDoodad.getEnumType(state);
        return type.value;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockDoodad.getEnumType(state);
        return type == EnumType.ENDIMIUM ? 6 : (type == EnumType.BURNIUM ? 10 : 0);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockDoodad.getEnumType(state);
        return type == EnumType.BURNIUM || type == EnumType.ENDIMIUM ? PathNodeType.DANGER_CACTUS : super.getAiPathNodeType(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    private void buildDrops(NonNullList<ItemStack> drops, int fortune, EnumType type, int dropAttempts, int dropChance, int dropCount) {
        List<DropEntry> dropList;
        if (Values.rebuildDustList) {
            cacheDropList.clear();
            for (EnumType enumType : EnumType.values()) {
                cacheDropList.put(enumType, BlockDoodad.generateDropList(enumType));
            }
            Values.rebuildDustList = false;
        }
        if ((dropList = cacheDropList.get((Object)type)) == null) {
            dropList = BlockDoodad.generateDropList(type);
            cacheDropList.put(type, dropList);
        }
        if (dropList != null && !dropList.isEmpty()) {
            int maxAttempts = this.getNumber(dropAttempts);
            if (dropChance > 1) {
                dropChance = Math.max(2, (int)((double)dropChance * (1.0 - (double)Math.min(fortune, 5) / 10.0)));
            }
            if (dropChance > 1 && fortune > 5) {
                maxAttempts += fortune - 5;
            }
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                if (dropChance <= 0 || Function.random.nextInt(dropChance) != 0) continue;
                for (int drop = 0; drop < this.getNumber(dropCount) + Function.random.nextInt(fortune + 1); ++drop) {
                    DropEntry dropEntry = dropList.get(Function.random.nextInt(dropList.size()));
                    drops.add((Object)dropEntry.getStack(fortune));
                }
                return;
            }
        }
    }

    private int getNumber(int value) {
        if (value < 0) {
            return Function.random.nextInt(1 - value) + 1;
        }
        return value;
    }

    private static List<DropEntry> generateDropList(EnumType type) {
        String[] whitelist = null;
        String[] blacklist = null;
        switch (type) {
            case BRANCH: {
                whitelist = Configuration.TWEAKS.DOODADS.STICK.whitelist;
                blacklist = Configuration.TWEAKS.DOODADS.STICK.blacklist;
                break;
            }
            case STONE: {
                whitelist = Configuration.TWEAKS.DOODADS.STONE.whitelist;
                blacklist = Configuration.TWEAKS.DOODADS.STONE.blacklist;
                break;
            }
            case BONE: {
                whitelist = Configuration.TWEAKS.DOODADS.BONE.whitelist;
                blacklist = Configuration.TWEAKS.DOODADS.BONE.blacklist;
                break;
            }
            case SANDSTONE: {
                whitelist = Configuration.TWEAKS.DOODADS.SANDSTONE.whitelist;
                blacklist = Configuration.TWEAKS.DOODADS.SANDSTONE.blacklist;
                break;
            }
            case REDSANDSTONE: {
                whitelist = Configuration.TWEAKS.DOODADS.REDSANDSTONE.whitelist;
                blacklist = Configuration.TWEAKS.DOODADS.REDSANDSTONE.blacklist;
                break;
            }
            case ENDIMIUM: {
                whitelist = Configuration.TWEAKS.DOODADS.ENDIMIUM.whitelist;
                blacklist = Configuration.TWEAKS.DOODADS.ENDIMIUM.blacklist;
                break;
            }
            case BURNIUM: {
                whitelist = Configuration.TWEAKS.DOODADS.BURNIUM.whitelist;
                blacklist = Configuration.TWEAKS.DOODADS.BURNIUM.blacklist;
            }
        }
        if (whitelist != null && blacklist != null) {
            String name;
            HashMap<String, String> categories = new HashMap<String, String>();
            HashMap<Object, String> items = new HashMap<Object, String>();
            Pattern patternOre = Pattern.compile("ore:(.*)#(.*)");
            Pattern patternItem = Pattern.compile("(.*)#(.*)");
            for (String include : whitelist) {
                try {
                    String[] item;
                    Pair<ResourceLocation, Integer> data;
                    Matcher matcher;
                    if (include.startsWith("ore")) {
                        matcher = patternOre.matcher(include);
                        if (!matcher.find()) continue;
                        name = matcher.group(1);
                        String count = matcher.group(2);
                        if (name.contains("*")) {
                            name = name.replaceAll("\\*", ".*");
                            String[] stringArray = OreDictionary.getOreNames();
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String entry = stringArray[i];
                                if (!entry.matches(name)) continue;
                                categories.put(entry, count);
                            }
                            continue;
                        }
                        categories.put(name, count);
                        continue;
                    }
                    matcher = patternItem.matcher(include);
                    if (!matcher.find() || (data = BlockDoodad.getItemData(matcher.group(1), false)) == null || (item = (String[])Item.field_150901_e.func_82594_a(data.getKey())) == null) continue;
                    ItemStack stack = new ItemStack((Item)item, 1, (Integer)data.getValue() == Short.MAX_VALUE ? 0 : (Integer)data.getValue());
                    items.put(stack, matcher.group(2));
                }
                catch (Exception data) {
                    // empty catch block
                }
            }
            for (String exclude : blacklist) {
                if (!exclude.startsWith("ore")) continue;
                name = exclude.substring(4);
                if (name.contains("*")) {
                    name = name.replaceAll("\\*", ".*");
                    for (String entry : OreDictionary.getOreNames()) {
                        if (!entry.matches(name)) continue;
                        categories.remove(entry);
                    }
                    continue;
                }
                categories.remove(name);
            }
            for (Map.Entry entry : categories.entrySet()) {
                NonNullList odList = OreDictionary.getOres((String)((String)entry.getKey()));
                if (odList.isEmpty()) continue;
                items.put(odList.get(0), (String)entry.getValue());
            }
            ArrayList<ItemStack> listRemove = new ArrayList<ItemStack>();
            for (String exclude : blacklist) {
                Pair<ResourceLocation, Integer> data;
                ResourceLocation registryEntry;
                ItemStack stack;
                if (exclude.startsWith("mod")) {
                    String name2 = exclude.substring(4);
                    for (Map.Entry item : items.entrySet()) {
                        stack = (ItemStack)item.getKey();
                        registryEntry = stack.func_77973_b().getRegistryName();
                        if (registryEntry == null || !registryEntry.func_110624_b().equals(name2)) continue;
                        listRemove.add(stack);
                    }
                    continue;
                }
                if (exclude.startsWith("ore") || (data = BlockDoodad.getItemData(exclude, true)) == null) continue;
                for (Map.Entry item : items.entrySet()) {
                    stack = (ItemStack)item.getKey();
                    registryEntry = stack.func_77973_b().getRegistryName();
                    if (registryEntry == null || !registryEntry.equals(data.getKey()) || (Integer)data.getValue() != Short.MAX_VALUE && ((Integer)data.getValue()).intValue() != stack.func_77952_i()) continue;
                    listRemove.add(stack);
                }
            }
            for (ItemStack stack : listRemove) {
                items.remove(stack);
            }
            ArrayList<DropEntry> arrayList = new ArrayList<DropEntry>();
            for (Map.Entry item : items.entrySet()) {
                DropEntry entry = DropEntry.create((ItemStack)item.getKey(), (String)item.getValue());
                if (entry == null) continue;
                arrayList.add(entry);
            }
            return arrayList;
        }
        return new ArrayList<DropEntry>();
    }

    private static Pair<ResourceLocation, Integer> getItemData(String data, boolean defaultWild) {
        if (!Strings.isNullOrEmpty((String)data)) {
            int meta;
            String name = data;
            int n = meta = defaultWild ? Short.MAX_VALUE : 0;
            if (data.contains("@")) {
                String[] split = data.split("@");
                name = split[0];
                try {
                    meta = Integer.parseInt(split[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (meta < 0) {
                    meta = Short.MAX_VALUE;
                }
            }
            ResourceLocation resource = null;
            try {
                resource = new ResourceLocation(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resource != null) {
                return Pair.of((Object)resource, (Object)meta);
            }
        }
        return null;
    }

    public static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.BRANCH;
            Terraqueous.errorPropertyNotFound("BlockDoodad.VARIANT", "BRANCH", state.toString());
        }
        return type;
    }

    private static class DropEntry {
        private final ItemStack stack;
        private final int min;
        private final int max;

        public static DropEntry create(@Nonnull ItemStack stack, String meta) {
            int min = 1;
            int max = 1;
            try {
                if (meta.contains("-")) {
                    min = Integer.parseInt(meta.split("-")[0]);
                    max = Integer.parseInt(meta.split("-")[1]);
                } else {
                    min = max = Integer.parseInt(meta);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new DropEntry(stack, min, max);
        }

        private DropEntry(ItemStack stack, int min, int max) {
            this.stack = stack;
            this.min = min < max ? min : max;
            this.max = max > min ? max : min;
        }

        @Nonnull
        public ItemStack getStack(int fortune) {
            ItemStack returnStack = this.stack.func_77946_l();
            int count = this.max == this.min ? this.max : Function.random.nextInt(this.max - this.min) + this.min;
            int boost = fortune;
            if (fortune > 5) {
                fortune = (fortune - 5) / 2 + 1;
                boost = 5 + fortune + Function.random.nextInt(fortune);
            }
            returnStack.func_190920_e(MathHelper.func_76125_a((int)(count + boost), (int)1, (int)returnStack.func_77976_d()));
            return returnStack;
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        BRANCH(0, "axe", 0, SoundType.field_185848_a),
        STONE(1, "pickaxe", 0, SoundType.field_185851_d),
        BONE(2, "shovel", 0, SoundType.field_185851_d),
        SANDSTONE(3, "pickaxe", 0, SoundType.field_185851_d),
        ENDIMIUM(4, "pickaxe", 2, SoundType.field_185853_f),
        BURNIUM(5, "pickaxe", 1, SoundType.field_185853_f),
        GLASSSHARDS(6, "shovel", 0, SoundType.field_185853_f),
        REDSANDSTONE(7, "pickaxe", 0, SoundType.field_185851_d);

        private static final EnumType[] array;
        private final byte value;
        private final String tool;
        private final byte toolLevel;
        private final SoundType soundType;

        private EnumType(int value, String tool, int toolLevel, SoundType soundType) {
            this.value = (byte)value;
            this.tool = tool;
            this.toolLevel = (byte)toolLevel;
            this.soundType = soundType;
        }

        public byte getValue() {
            return this.value;
        }

        public String getTool() {
            return this.tool;
        }

        public byte getToolLevel() {
            return this.toolLevel;
        }

        public SoundType getSoundType() {
            return this.soundType;
        }

        public IBlockState state() {
            if (Values.blockDoodad != null) {
                return Values.blockDoodad.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)this));
            }
            return null;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? BRANCH : type;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String getPrefix() {
            return this.func_176610_l().replace("branch", "stick").replace("redsandstone", "sandstone").replace("glassshards", "shards");
        }

        static {
            array = new EnumType[8];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

