/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.plant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shetiphian.terraqueous.api.plant.IPlantControl;

public class PlantAPI {
    private static List<IPlantControl> plantControllers = Collections.synchronizedList(new ArrayList());
    public static final PropertyEnum<TreeType> TREEVARIANT = PropertyEnum.func_177709_a((String)"treevariant", TreeType.class);
    public static final PropertyEnum<PlantType> PLANTVARIANT = PropertyEnum.func_177709_a((String)"plantvariant", PlantType.class);
    protected static Logger logPlant = LogManager.getLogger((String)"Terraqueous|PlantAPI");

    public static void registerPlantController(IPlantControl controller) {
        plantControllers.add(controller);
    }

    public static int getTreeEventChance(TreeEvent event, TreeType type, IBlockAccess world, BlockPos pos, int defaultChance) {
        double chance = defaultChance;
        for (IPlantControl plantController : plantControllers) {
            chance *= plantController.getChanceMultiplier(event, type, world, pos);
        }
        return MathHelper.func_76143_f((double)chance);
    }

    public static int getPlantEventChance(PlantEvent event, PlantType type, IBlockAccess world, BlockPos pos, int defaultChance) {
        double chance = defaultChance;
        for (IPlantControl plantController : plantControllers) {
            chance *= plantController.getChanceMultiplier(event, type, world, pos);
        }
        return MathHelper.func_76143_f((double)chance);
    }

    public static byte getPlacementValue(PlacementValue placement, IBlockAccess world, BlockPos pos, int defaultValue) {
        double value = defaultValue;
        for (IPlantControl plantController : plantControllers) {
            value *= plantController.getValueMultiplier(placement, world, pos);
        }
        return (byte)MathHelper.func_76143_f((double)value);
    }

    public static TreeType getTreeType(IBlockState state) {
        TreeType type;
        try {
            type = (TreeType)((Object)state.func_177229_b(TREEVARIANT));
        }
        catch (Exception e) {
            type = TreeType.APPLE;
            PlantAPI.errorPropertyNotFound("PlantAPI.TREEVARIANT", "APPLE", state.toString());
        }
        return type;
    }

    public static PlantType getPlantType(IBlockState state) {
        PlantType type;
        try {
            type = (PlantType)((Object)state.func_177229_b(PLANTVARIANT));
        }
        catch (Exception e) {
            type = PlantType.FLOWER;
            PlantAPI.errorPropertyNotFound("PlantAPI.PLANTVARIANT", "FLOWER", state.toString());
        }
        return type;
    }

    public static void errorPropertyNotFound(String property, String returning, String state) {
        logPlant.error("PropertyEnum '" + property + "' not found in provided BlockState, returning '" + returning + "'. Provided BlockState: " + state);
    }

    public static enum PlacementValue {
        FlowerSpreadRadius,
        FlowerMaxAttempts,
        GrassSpreadRadius,
        GrassMaxAttempts;

    }

    public static enum PlantEvent {
        PlantGrow,
        PlantSpread,
        FruitGrow;

    }

    public static enum TreeEvent {
        FruitFlower,
        FruitGrow,
        FruitFall,
        SaplingGrow,
        SaplingDrop;

    }

    public static enum PlantType implements IStringSerializable
    {
        FLOWER(0),
        GRASS(1),
        PINEAPPLE(2),
        CACTUS(3),
        GRAPEVINE(4),
        LIFEVINE(5),
        DEATHVINE(6);

        private static final PlantType[] array;
        private final byte id;

        private PlantType(int id) {
            this.id = (byte)id;
        }

        public byte getID() {
            return this.id;
        }

        public static PlantType byID(int id) {
            return array[MathHelper.func_76125_a((int)id, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new PlantType[7];
            PlantType[] plantTypeArray = PlantType.values();
            int n = plantTypeArray.length;
            for (int i = 0; i < n; ++i) {
                PlantType value;
                PlantType.array[value.getID()] = value = plantTypeArray[i];
            }
        }
    }

    public static enum TreeType implements IStringSerializable
    {
        APPLE(0),
        CHERRY(1),
        ORANGE(2),
        PEAR(3),
        PEACH(4),
        MANGO(5),
        LEMON(6),
        PLUM(7),
        COCONUT(8),
        BANANA(9);

        private static final TreeType[] array;
        private final byte id;

        private TreeType(int id) {
            this.id = (byte)id;
        }

        public byte getID() {
            return this.id;
        }

        public static TreeType byID(int id) {
            return array[MathHelper.func_76125_a((int)id, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new TreeType[]{APPLE, CHERRY, ORANGE, PEAR, PEACH, MANGO, LEMON, PLUM, COCONUT, BANANA};
        }
    }
}

