/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous;

import com.google.common.base.Strings;
import java.lang.reflect.Method;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.misc.BlueFlowerHandler;
import shetiphian.terraqueous.common.misc.PlantFunctions;
import shetiphian.terraqueous.common.worldgen.GenClouds;

@Config(modid="terraqueous", name="terraqueous")
public class Configuration {
    @Config.RequiresMcRestart
    @Config.Comment(value={"Controls what blocks are added by Terraqueous", "Disabling a block after it was added will remove it from the world"})
    public static Menu_Blocks BLOCKS = new Menu_Blocks();
    @Config.RequiresMcRestart
    @Config.Comment(value={"Controls what items are added by Terraqueous", "Disabling an item after it was added will remove it from the world"})
    public static Menu_Items ITEMS = new Menu_Items();
    @Config.Comment(value={"Make adjustments to how different blocks/items function"})
    public static Menu_Tweaks TWEAKS = new Menu_Tweaks();
    @Config.Comment(value={""})
    public static Menu_GUI GUI_STYLE = new Menu_GUI();
    @Config.Comment(value={" "})
    public static Menu_Permissions PERMISSIONS = new Menu_Permissions();
    @Config.Comment(value={"Options used by the world generator"})
    public static Menu_Generator GENERATOR = new Menu_Generator();
    @Config.RequiresMcRestart
    @Config.Comment(value={"Disable DustCrafting if another mod add the same recipes and these override them.", "Disable CraftToDust if unneeded and/or another mod adds a machine that does this."})
    public static Menu_Crafting CRAFTING = new Menu_Crafting();
    @Config.RequiresMcRestart
    @Config.Comment(value={"Mod integration can be disabled to solve compatibility issues, remove unwanted/unneeded features, etc."})
    public static Menu_Integration INTEGRATION = new Menu_Integration();

    @Mod.EventBusSubscriber
    static class EventHandler {
        EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("terraqueous")) {
                ConfigManager.sync((String)"terraqueous", (Config.Type)Config.Type.INSTANCE);
                EventHandler.process();
                GenClouds.clearBlacklist();
            }
        }

        public static void cleanup() {
            net.minecraftforge.common.config.Configuration config = null;
            try {
                Method method = ConfigManager.class.getDeclaredMethod("getConfiguration", String.class, String.class);
                method.setAccessible(true);
                config = (net.minecraftforge.common.config.Configuration)method.invoke(null, "terraqueous", "");
            }
            catch (Exception method) {
                // empty catch block
            }
            if (config != null) {
                Property property;
                ConfigCategory category = config.getCategory("general.tweaks");
                if (category != null && (property = category.get("enableGlassShardDrops")) != null) {
                    boolean enableGlassShardDrops = property.getBoolean();
                    category.remove((Object)"enableGlassShardDrops");
                    Configuration.TWEAKS.GLASSSHARDS.enableGlassShardDropsForBlocks = enableGlassShardDrops;
                    Configuration.TWEAKS.GLASSSHARDS.enableGlassShardDropsForPotions = enableGlassShardDrops;
                    config.save();
                }
                if ((category = config.getCategory("general.tweaks.doodads")) != null) {
                    category.remove((Object)"dropLumps");
                    category.remove((Object)"dustWhiteList");
                    category.remove((Object)"dustBlackList");
                    config.save();
                }
                config.moveProperty("general.tweaks", "fruitStaysOnTrees", "general.tweaks.trees");
                config.moveProperty("general.tweaks", "flowersRequireShears", "general.tweaks.plants");
                category = config.getCategory("general.tweaks");
                if (category != null) {
                    category.remove((Object)"enableFlowerSpread");
                    category.remove((Object)"enableGrassSpread");
                }
                if ((category = config.getCategory("general.generator")) != null && category.containsKey("cloudDimensionBlacklist")) {
                    if (Configuration.GENERATOR.DIM_BLACKLIST.clouds.length == 0) {
                        try {
                            Configuration.GENERATOR.DIM_BLACKLIST.clouds = category.get("cloudDimensionBlacklist").getStringList();
                            config.getCategory("general.generator.dim_blacklist").get("clouds").set(Configuration.GENERATOR.DIM_BLACKLIST.clouds);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    category.remove((Object)"cloudDimensionBlacklist");
                    config.save();
                }
                config.moveProperty("general.generator", "cloudDimensionBlacklist", "general.generator.dim_blacklist");
                config.renameProperty("general.generator.dim_blacklist", "cloudDimensionBlacklist", "clouds");
                config.moveProperty("general.generator", "cloudHeightOverride", "general.generator.clouds");
                config.moveProperty("general.generator", "generateCloud_Light", "general.generator.clouds");
                config.moveProperty("general.generator", "generateCloud_Dense", "general.generator.clouds");
                config.moveProperty("general.generator", "generateCloud_Storm", "general.generator.clouds");
                config.moveProperty("general.generator", "generatePlant_Pineapple", "general.generator.plants");
                config.moveProperty("general.generator", "generatePlant_CactusPear", "general.generator.plants");
                category = config.getCategory("general.blocks");
                if (category != null && category.containsKey("addCraftables")) {
                    category.remove((Object)"addCraftables");
                    config.save();
                }
            }
        }

        public static void process() {
            BlueFlowerHandler.INSTANCE.buildList(Configuration.TWEAKS.listTricksterBloomEffects);
            PlantFunctions.load();
            Values.rebuildDustList = true;
            Values.flowerpotOverrides.clear();
            EventHandler.processRenderList(0, Configuration.TWEAKS.FLOWERPOTS.forceCrossRender);
            EventHandler.processRenderList(1, Configuration.TWEAKS.FLOWERPOTS.forceBlockRender);
            EventHandler.processRenderList(2, Configuration.TWEAKS.FLOWERPOTS.forcePaneRender);
            EventHandler.processRenderList(3, Configuration.TWEAKS.FLOWERPOTS.forceTallRender);
        }

        private static void processRenderList(int style, String[] items) {
            for (String item : items) {
                if (Strings.isNullOrEmpty((String)item)) continue;
                String[] split = item.split("@");
                int damage = split.length > 1 ? Integer.parseInt(split[1]) : -1;
                Values.flowerpotOverrides.put((Object)split[0], (Object)damage, (Object)((byte)style));
            }
        }
    }

    public static class Menu_Integration {
        @Config.Comment(value={"Enables the CloudTalisman and WaterPearl to be equipped as a bauble"})
        public boolean enableBaubles = true;
        @Config.Comment(value={"Facade changes; adds missing blocks and removes blocks that look bad"})
        public boolean enableBuildCraft = true;
        @Config.Comment(value={"Adds: fruit to squeezer, saplings to fermenter, and various items to backpacks"})
        public boolean enableForestry = true;
        @Config.Comment(value={"Adds: fruit to the BioReactor, endimium/burnium ore to the LaserDrill, and flowers/cactus pear/pineapple/banana stalk to the Plant Gatherer"})
        public boolean enableIndustrialForegoing = true;
        @Config.Comment(value={"Adds Colorizer Module for Robots"})
        public boolean enableOpenComputers = true;
        @Config.Comment(value={"Adds color data to tooltips"})
        public boolean enableWAILA = true;
    }

    public static class Menu_Crafting {
        @Config.Comment(value={"Craft Wool into String"})
        public boolean enableWoolToString = true;
        @Config.Comment(value={"Craft tiny piles of Ender Dust into piles"})
        public boolean enableCrafting_TinyDustToEnderDust = true;
        @Config.Comment(value={"Craft tiny piles of Iron Dust into piles"})
        public boolean enableCrafting_TinyDustToIronDust = true;
        @Config.Comment(value={"Craft tiny piles of Gold Dust into piles"})
        public boolean enableCrafting_TinyDustToGoldDust = true;
        @Config.Comment(value={"Craft tiny piles of Coal Dust into piles"})
        public boolean enableCrafting_TinyDustToCoalDust = true;
        @Config.Comment(value={"Craft tiny piles of Diamond Dust into piles"})
        public boolean enableCrafting_TinyDustToDiamondDust = true;
        @Config.Comment(value={"Craft tiny piles of Emerald Dust into piles"})
        public boolean enableCrafting_TinyDustToEmeraldDust = true;
        @Config.Comment(value={"Craft tiny piles of Lapis Dust into Lapis"})
        public boolean enableCrafting_TinyDustToLapis = true;
        @Config.Comment(value={"Craft tiny piles of Redstone Dust into Redstone Dust"})
        public boolean enableCrafting_TinyDustToRedstone = true;
        @Config.Comment(value={"Craft lumps of Sandstone into a block"})
        public boolean enableCrafting_LumpToSandstone = true;
        @Config.Comment(value={"Craft lumps of Gravel into a block"})
        public boolean enableCrafting_LumpToGravel = true;
        @Config.Comment(value={"Craft lumps of Red Sandstone into a block"})
        public boolean enableCrafting_LumpToRedSandstone = true;
        @Config.Comment(value={"Smash Ender Pearls into Dust"})
        public boolean enableSmashing_EnderPearlsToDust = true;
        @Config.Comment(value={"Smash Coal into Dust"})
        public boolean enableSmashing_CoalToDust = true;
        @Config.Comment(value={"Smash Diamonds into Dust"})
        public boolean enableSmashing_DiamondToDust = true;
    }

    public static class Menu_Generator {
        @Config.Comment(value={"It is recommended to leave this off unless you have other blocks that generate in flat worlds, otherwise Trees and Flowers will take over"})
        public boolean generateInFlatWorlds = false;
        @Config.Comment(value={"Generation events allow other mods to disable my generators on a chunk by chunk basis, they are ignored by default"})
        public boolean ignoreGenerationEvents = true;
        @Config.Comment(value={"This is a general on/off toggle", "For more control see the sub menu"})
        public boolean generateClouds = true;
        @Config.Comment(value={"This is a general on/off toggle", "For more control see the sub menu"})
        public boolean generateDoodads = true;
        @Config.Comment(value={"This is a general on/off toggle", "For more control see the sub menu"})
        public boolean generateFlowers = true;
        @Config.Comment(value={"This is a general on/off toggle", "For more control see the sub menu"})
        public boolean generatePlants = true;
        @Config.Comment(value={"This is a general on/off toggle", "For more control see the sub menu"})
        public boolean generateTrees = true;
        @Config.Comment(value={"Generators will not generate in the dimensions on this list", "The registered name is expected. [eg: overworld, the_nether, the_end] (regex supported)", "To use the Id it must be prefixed with '#'. [eg: #0, #-1, #1]", "Finding the registered name:", "With an open source mod, running a search for DimensionType.register should get you the name. If not you'll need to look at the WorldProvider.", "With closed sourced mods, asking the author or using a decompiler like JD-GUI are your options."})
        public SubMenu_DimBlacklist DIM_BLACKLIST = new SubMenu_DimBlacklist();
        public SubMenu_Clouds CLOUDS = new SubMenu_Clouds();
        public SubMenu_Doodads DOODADS = new SubMenu_Doodads();
        public SubMenu_Flowers FLOWERS = new SubMenu_Flowers();
        public SubMenu_Plants PLANTS = new SubMenu_Plants();
        public SubMenu_Trees TREES = new SubMenu_Trees();
        public SubMenu_Village VILLAGE = new SubMenu_Village();

        public static class SubMenu_Village {
            @Config.Comment(value={"Generates a Pergola in villages, enabled vines have a chance to spawn it"})
            public boolean generateVillage_Vineyard = true;
            @Config.Comment(value={"Enables Death Fruit vines to generate on the Pergola"})
            public boolean enableDeathFruitVines = true;
            @Config.Comment(value={"Enables Life Fruit vines to generate on the Pergola"})
            public boolean enableLifeFruitVines = true;
            @Config.Comment(value={"Enables Grape vines to generate on the Pergola"})
            public boolean enableGrapeVines = true;
            @Config.Comment(value={"When a pergola generates a random number [0-19] is chosen to pick the vine overlay", "This is a list of values that result in the DeathFruitVine"})
            @Config.RangeInt(min=0, max=19)
            public int[] valuesDeathFruitVine = new int[]{5, 19};
            @Config.Comment(value={"When a pergola generates a random number [0-19] is chosen to pick the vine overlay", "This is a list of values that result in the LifeFruitVine"})
            @Config.RangeInt(min=0, max=19)
            public int[] valuesLifeFruitVine = new int[]{0, 14};
            @Config.Comment(value={"When a pergola generates a random number [0-19] is chosen to pick the vine overlay", "This is a list of values that result in the GrapeVine"})
            @Config.RangeInt(min=0, max=19)
            public int[] valuesGrapeVine = new int[]{1, 4, 8, 9, 10, 11, 15, 18};
        }

        public static class SubMenu_Trees {
            @Config.Comment(value={"The chance the generator has at excuting in each chunk", "This is only used if 'generateInFlatWorlds' is true and the biome ones are ignored"})
            @Config.RangeInt(min=0, max=100)
            public int chunkChance = 35;
            @Config.Comment(value={"The chance the generator has at excuting in this biome per chunk", "Trees Found Here: Coconut"})
            @Config.RangeInt(min=0, max=100)
            public int biomeChance_Beach = 40;
            @Config.Comment(value={"The chance the generator has at excuting in this biome per chunk", "Trees Found Here: Apple, Pear, Mango"})
            @Config.RangeInt(min=0, max=100)
            public int biomeChance_Forest = 50;
            @Config.Comment(value={"The chance the generator has at excuting in this biome per chunk", "Trees Found Here: Cherry, Orange, Lemon, Plum"})
            @Config.RangeInt(min=0, max=100)
            public int biomeChance_Hills = 30;
            @Config.Comment(value={"The chance the generator has at excuting in this biome per chunk", "Trees Found Here: Banana"})
            @Config.RangeInt(min=0, max=100)
            public int biomeChance_Jungle = 50;
            @Config.Comment(value={"The chance the generator has at excuting in this biome per chunk", "Trees Found Here: Peach"})
            @Config.RangeInt(min=0, max=100)
            public int biomeChance_Mountain = 35;
            @Config.Comment(value={""})
            public boolean generateTree_Apple = true;
            @Config.Comment(value={""})
            public boolean generateTree_Cherry = true;
            @Config.Comment(value={""})
            public boolean generateTree_Orange = true;
            @Config.Comment(value={""})
            public boolean generateTree_Pear = true;
            @Config.Comment(value={""})
            public boolean generateTree_Peach = true;
            @Config.Comment(value={""})
            public boolean generateTree_Mango = true;
            @Config.Comment(value={""})
            public boolean generateTree_Lemon = true;
            @Config.Comment(value={""})
            public boolean generateTree_Plum = true;
            @Config.Comment(value={""})
            public boolean generateTree_Coconut = true;
            @Config.Comment(value={""})
            public boolean generateTree_Banana = true;
        }

        public static class SubMenu_Flowers {
            @Config.Comment(value={"The chance the generator has at excuting in each chunk", "This is only used if 'generateInFlatWorlds' is true and the biome ones are ignored"})
            @Config.RangeInt(min=0, max=100)
            public int chunkChance = 50;
            @Config.Comment(value={"The chance the generator has at excuting in this biome per chunk"})
            @Config.RangeInt(min=0, max=100)
            public int biomeChance_Forest = 50;
            @Config.Comment(value={"The chance the generator has at excuting in this biome per chunk"})
            @Config.RangeInt(min=0, max=100)
            public int biomeChance_Jungle = 50;
            @Config.Comment(value={"The chance the generator has at excuting in this biome per chunk"})
            @Config.RangeInt(min=0, max=100)
            public int biomeChance_Magical = 50;
            @Config.Comment(value={"The chance the generator has at excuting in this biome per chunk"})
            @Config.RangeInt(min=0, max=100)
            public int biomeChance_Mountain = 50;
            @Config.Comment(value={"The chance the generator has at excuting in this biome per chunk"})
            @Config.RangeInt(min=0, max=100)
            public int biomeChance_Plains = 50;
            @Config.Comment(value={"The chance the generator has at excuting in this biome per chunk"})
            @Config.RangeInt(min=0, max=100)
            public int biomeChance_Water = 50;
        }

        public static class SubMenu_Doodads {
            @Config.Comment(value={""})
            public boolean generateDoodad_Stick = true;
            @Config.Comment(value={""})
            public boolean generateDoodad_Stone = true;
            @Config.Comment(value={""})
            public boolean generateDoodad_Bone = true;
            @Config.Comment(value={""})
            public boolean generateDoodad_Endimium = true;
            @Config.Comment(value={""})
            public boolean generateDoodad_Burnium = true;
            @Config.Comment(value={"The chance the generator has at excuting in each chunk"})
            @Config.RangeInt(min=0, max=100)
            public int chunkChance_Stick = 75;
            @Config.Comment(value={"The chance the generator has at excuting in each chunk"})
            @Config.RangeInt(min=0, max=100)
            public int chunkChance_Stone = 75;
            @Config.Comment(value={"The chance the generator has at excuting in each chunk"})
            @Config.RangeInt(min=0, max=100)
            public int chunkChance_Bone = 75;
            @Config.Comment(value={"The chance the generator has at excuting in each chunk"})
            @Config.RangeInt(min=0, max=100)
            public int chunkChance_Endimium = 75;
            @Config.Comment(value={"The chance the generator has at excuting in each chunk"})
            @Config.RangeInt(min=0, max=100)
            public int chunkChance_Burnium = 75;
        }

        public static class SubMenu_Plants {
            @Config.Comment(value={""})
            public boolean generatePlant_Pineapple = true;
            @Config.Comment(value={""})
            public boolean generatePlant_CactusPear = true;
            @Config.Comment(value={"The chance the generator has at excuting in each chunk", "This is only used if 'generateInFlatWorlds' is true and the chunk ones are ignored"})
            @Config.RangeInt(min=0, max=100)
            public int chunkChance = 50;
            @Config.Comment(value={"The chance the generator has at excuting in each chunk"})
            @Config.RangeInt(min=0, max=100)
            public int chunkChance_Pineapple = 100;
            @Config.Comment(value={"The chance the generator has at excuting in each chunk"})
            @Config.RangeInt(min=0, max=100)
            public int chunkChance_CactusPear = 75;
        }

        public static class SubMenu_Clouds {
            @Config.Comment(value={"A value greater then zero will be used as the clouds generation height"})
            @Config.RangeInt(min=0, max=2048)
            public int cloudHeightOverride = 0;
            @Config.Comment(value={""})
            public boolean generateCloud_Light = true;
            @Config.Comment(value={""})
            public boolean generateCloud_Dense = true;
            @Config.Comment(value={""})
            public boolean generateCloud_Storm = true;
        }

        public static class SubMenu_DimBlacklist {
            @Config.Comment(value={"Dimensions here are blacklist from all generators"})
            public String[] global = new String[]{"Spectre", "CompactMachines"};
            public String[] clouds = new String[0];
            public String[] doodads = new String[0];
            public String[] flowers = new String[0];
            public String[] plants = new String[0];
            public String[] trees = new String[0];
        }
    }

    public static class Menu_Permissions {
        @Config.Comment(value={"Controls who has permission to create a StormForge.", "0 = No One, 1 = OP's Only, 2 = OP's and Creative Players, 3 = Everyone", "NOTE: Does not disable/remove existing StormForges", "NOTE: StormForges require addCraftables"})
        @Config.RangeInt(min=0, max=3)
        public int permissionStormForge = 3;
    }

    public static class Menu_GUI {
        public STYLE cloud_furnace = STYLE.DEFAULT;
        public STYLE cloud_workbench = STYLE.DEFAULT;
        public STYLE cloud_craftbench = STYLE.DEFAULT;
        public STYLE cloud_craftfurnace = STYLE.DEFAULT;
        public STYLE colorizer = STYLE.DEFAULT;
        public STYLE craftbench = STYLE.DEFAULT;
        public STYLE craftfurnace = STYLE.DEFAULT;
        public STYLE endertable = STYLE.DEFAULT;
        public STYLE stormforge = STYLE.DEFAULT;

        public static enum STYLE {
            DEFAULT,
            VANILLA;

        }
    }

    public static class Menu_Tweaks {
        @Config.Comment(value={"Stops Terraqueous fences from visually connecting to blocks with a hardness at or less then this number.", "to disable set to -1"})
        @Config.RangeDouble(min=-1.0, max=20.0)
        public double fenceConnectionCutoff = 0.6;
        @Config.Comment(value={"List of effects Trickster Bloom can apply"})
        public String[] listTricksterBloomEffects = BlueFlowerHandler.DEFAULTS;
        public SubMenu_Chests CHESTS = new SubMenu_Chests();
        public SubMenu_Doodads DOODADS = new SubMenu_Doodads();
        public SubMenu_FlowerPots FLOWERPOTS = new SubMenu_FlowerPots();
        public SubMenu_GlassShards GLASSSHARDS = new SubMenu_GlassShards();
        public SubMenu_Mobs MOBS = new SubMenu_Mobs();
        public SubMenu_Trees TREES = new SubMenu_Trees();
        public SubMenu_Plants PLANTS = new SubMenu_Plants();
        public SubMenu_WaterPearl WATER_PEARL = new SubMenu_WaterPearl();
        @Config.Comment(value={"1EU = 4RF = 10J = 0.4MJ (http://ftbwiki.org/Power_Systems)"})
        public SubMenu_Stormforge STORMFORGE = new SubMenu_Stormforge();

        public static class SubMenu_WaterPearl {
            @Config.Comment(value={"Prevent breath loss while held, or in the hotbar, or equipped as a bauble"})
            public boolean enableWaterBreathing = true;
            @Config.Comment(value={"Allows the placement water into the world"})
            public boolean enableWorldPlacement = false;
            @Config.Comment(value={"Register's the item to the OreDictionary under 'listAllWater' enabling its use in recipes"})
            public boolean enableInfiniteWaterBucket = true;
            @Config.Comment(value={""})
            public boolean enableInfiniteWaterTank = true;
        }

        public static class SubMenu_Plants {
            @Config.Comment(value={"If enabled Terraqueous flowers require shears to harvest, otherwise nothing will drop"})
            public boolean flowersRequireShears = false;
            @Config.Comment(value={"'1 in x' chance the flower will grow on the next block update"})
            @Config.RangeInt(min=0)
            public int flower_Grow_normal = 10;
            @Config.Comment(value={"'1 in x' chance the flower will grow on the next block update"})
            @Config.RangeInt(min=0)
            public int flower_Grow_rain = 9;
            @Config.Comment(value={"'1 in x' chance the flower will spread on the next block update"})
            @Config.RangeInt(min=0)
            public int flower_Spread_normal = 20;
            @Config.Comment(value={"'1 in x' chance the flower will spread on the next block update"})
            @Config.RangeInt(min=0)
            public int flower_Spread_rain = 18;
            @Config.Comment(value={"'1 in x' chance the grass will become double tall on the next block update"})
            @Config.RangeInt(min=0)
            public int grass_Grow_normal = 95;
            @Config.Comment(value={"'1 in x' chance the grass will become double tall on the next block update"})
            @Config.RangeInt(min=0)
            public int grass_Grow_rain = 75;
            @Config.Comment(value={"'1 in x' chance the grass will spread on the next block update"})
            @Config.RangeInt(min=0)
            public int grass_Spread_normal = 20;
            @Config.Comment(value={"'1 in x' chance the grass will spread on the next block update"})
            @Config.RangeInt(min=0)
            public int grass_Spread_rain = 18;
            @Config.Comment(value={"'1 in x' chance the pineapple will grow on the next block update"})
            @Config.RangeInt(min=0)
            public int pineapple_PlantGrow_normal = 8;
            @Config.Comment(value={"'1 in x' chance the pineapple will grow on the next block update"})
            @Config.RangeInt(min=0)
            public int pineapple_PlantGrow_rain = 5;
            @Config.Comment(value={"'1 in x' chance a fully grown pineapple will grow fruit on the next block update"})
            @Config.RangeInt(min=0)
            public int pineapple_FruitGrow_normal = 40;
            @Config.Comment(value={"'1 in x' chance a fully grown pineapple will grow fruit on the next block update"})
            @Config.RangeInt(min=0)
            public int pineapple_FruitGrow_rain = 40;
            @Config.Comment(value={"'1 in x' chance the cactus will grow on the next block update"})
            @Config.RangeInt(min=0)
            public int cactus_PlantGrow_day = 0;
            @Config.Comment(value={"'1 in x' chance the cactus will grow on the next block update"})
            @Config.RangeInt(min=0)
            public int cactus_PlantGrow_night = 8;
            @Config.Comment(value={"'1 in x' chance a fully grown cactus will grow fruit on the next block update"})
            @Config.RangeInt(min=0)
            public int cactus_FruitGrow_day = 0;
            @Config.Comment(value={"'1 in x' chance a fully grown cactus will grow fruit on the next block update"})
            @Config.RangeInt(min=0)
            public int cactus_FruitGrow_night = 40;
            @Config.Comment(value={"'1 in x' chance the grapevine will spread on the next block update"})
            @Config.RangeInt(min=0)
            public int grapevine_Spread_normal = 15;
            @Config.Comment(value={"'1 in x' chance the grapevine will spread on the next block update"})
            @Config.RangeInt(min=0)
            public int grapevine_Spread_rain = 13;
            @Config.Comment(value={"'1 in x' chance a grapevine will grow fruit on the next block update"})
            @Config.RangeInt(min=0)
            public int grapevine_FruitGrow_normal = 40;
            @Config.Comment(value={"'1 in x' chance a grapevine will grow fruit on the next block update"})
            @Config.RangeInt(min=0)
            public int grapevine_FruitGrow_rain = 40;
            @Config.Comment(value={"'1 in x' chance the lifevine will spread on the next block update"})
            @Config.RangeInt(min=0)
            public int lifevine_Spread_normal = 15;
            @Config.Comment(value={"'1 in x' chance the lifevine will spread on the next block update"})
            @Config.RangeInt(min=0)
            public int lifevine_Spread_rain = 13;
            @Config.Comment(value={"'1 in x' chance a lifevine will grow fruit on the next block update"})
            @Config.RangeInt(min=0)
            public int lifevine_FruitGrow_normal = 40;
            @Config.Comment(value={"'1 in x' chance a lifevine will grow fruit on the next block update"})
            @Config.RangeInt(min=0)
            public int lifevine_FruitGrow_rain = 40;
            @Config.Comment(value={"'1 in x' chance the deathvine will spread on the next block update"})
            @Config.RangeInt(min=0)
            public int deathvine_Spread_normal = 15;
            @Config.Comment(value={"'1 in x' chance the deathvine will spread on the next block update"})
            @Config.RangeInt(min=0)
            public int deathvine_Spread_rain = 13;
            @Config.Comment(value={"'1 in x' chance a deathvine will grow fruit on the next block update"})
            @Config.RangeInt(min=0)
            public int deathvine_FruitGrow_normal = 40;
            @Config.Comment(value={"'1 in x' chance a deathvine will grow fruit on the next block update"})
            @Config.RangeInt(min=0)
            public int deathvine_FruitGrow_rain = 40;
        }

        public static class SubMenu_Trees {
            @Config.Comment(value={"Controls if the fruit stays on the trees or randomly falls off"})
            public boolean fruitStaysOnTrees = false;
            public SubMenu_SaplingGrow SAPLING_GROW = new SubMenu_SaplingGrow();
            public SubMenu_FlowerGrow FLOWER_GROW = new SubMenu_FlowerGrow();
            public SubMenu_FruitGrow FRUIT_GROW = new SubMenu_FruitGrow();
            public SubMenu_FruitFall FRUIT_FALL = new SubMenu_FruitFall();
            public SubMenu_SaplingDrop SAPLING_DROP = new SubMenu_SaplingDrop();

            public static class SubMenu_SaplingDrop
            implements ITreeConfig {
                @Config.Comment(value={"'1 in x' chance a sapling will drop when leaves are broken"})
                @Config.RangeInt(min=0)
                public int apple = 15;
                @Config.Comment(value={"'1 in x' chance a sapling will drop when leaves are broken"})
                @Config.RangeInt(min=0)
                public int cherry = 20;
                @Config.Comment(value={"'1 in x' chance a sapling will drop when leaves are broken"})
                @Config.RangeInt(min=0)
                public int orange = 15;
                @Config.Comment(value={"'1 in x' chance a sapling will drop when leaves are broken"})
                @Config.RangeInt(min=0)
                public int pear = 20;
                @Config.Comment(value={"'1 in x' chance a sapling will drop when leaves are broken"})
                @Config.RangeInt(min=0)
                public int peach = 15;
                @Config.Comment(value={"'1 in x' chance a sapling will drop when leaves are broken"})
                @Config.RangeInt(min=0)
                public int mango = 20;
                @Config.Comment(value={"'1 in x' chance a sapling will drop when leaves are broken"})
                @Config.RangeInt(min=0)
                public int lemon = 12;
                @Config.Comment(value={"'1 in x' chance a sapling will drop when leaves are broken"})
                @Config.RangeInt(min=0)
                public int plum = 15;
                @Config.Comment(value={"'1 in x' chance a sapling will drop when leaves are broken"})
                @Config.RangeInt(min=0)
                public int coconut = 8;
                @Config.Comment(value={"'1 in x' chance a sapling will drop when leaves are broken"})
                @Config.RangeInt(min=0)
                public int banana = 8;
            }

            public static class SubMenu_FruitFall
            implements ITreeConfig {
                @Config.Comment(value={"'1 in x' chance a fruit will fall on the next block update", "If 'fruitStaysOnTrees' is set true, fruit will never drop"})
                @Config.RangeInt(min=0)
                public int apple = 50;
                @Config.Comment(value={"'1 in x' chance a fruit will fall on the next block update", "If 'fruitStaysOnTrees' is set true, fruit will never drop"})
                @Config.RangeInt(min=0)
                public int cherry = 50;
                @Config.Comment(value={"'1 in x' chance a fruit will fall on the next block update", "If 'fruitStaysOnTrees' is set true, fruit will never drop"})
                @Config.RangeInt(min=0)
                public int orange = 50;
                @Config.Comment(value={"'1 in x' chance a fruit will fall on the next block update", "If 'fruitStaysOnTrees' is set true, fruit will never drop"})
                @Config.RangeInt(min=0)
                public int pear = 60;
                @Config.Comment(value={"'1 in x' chance a fruit will fall on the next block update", "If 'fruitStaysOnTrees' is set true, fruit will never drop"})
                @Config.RangeInt(min=0)
                public int peach = 50;
                @Config.Comment(value={"'1 in x' chance a fruit will fall on the next block update", "If 'fruitStaysOnTrees' is set true, fruit will never drop"})
                @Config.RangeInt(min=0)
                public int mango = 60;
                @Config.Comment(value={"'1 in x' chance a fruit will fall on the next block update", "If 'fruitStaysOnTrees' is set true, fruit will never drop"})
                @Config.RangeInt(min=0)
                public int lemon = 40;
                @Config.Comment(value={"'1 in x' chance a fruit will fall on the next block update", "If 'fruitStaysOnTrees' is set true, fruit will never drop"})
                @Config.RangeInt(min=0)
                public int plum = 50;
                @Config.Comment(value={"'1 in x' chance a fruit will fall on the next block update", "If 'fruitStaysOnTrees' is set true, fruit will never drop"})
                @Config.RangeInt(min=0)
                public int coconut = 50;
            }

            public static class SubMenu_FruitGrow
            implements ITreeConfig {
                @Config.Comment(value={"'1 in x' chance the fruit will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int apple = 40;
                @Config.Comment(value={"'1 in x' chance the fruit will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int cherry = 40;
                @Config.Comment(value={"'1 in x' chance the fruit will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int orange = 40;
                @Config.Comment(value={"'1 in x' chance the fruit will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int pear = 50;
                @Config.Comment(value={"'1 in x' chance the fruit will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int peach = 40;
                @Config.Comment(value={"'1 in x' chance the fruit will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int mango = 50;
                @Config.Comment(value={"'1 in x' chance the fruit will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int lemon = 30;
                @Config.Comment(value={"'1 in x' chance the fruit will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int plum = 40;
                @Config.Comment(value={"'1 in x' chance the fruit will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int coconut = 20;
                @Config.Comment(value={"'1 in x' chance the fruit will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int banana = 20;
            }

            public static class SubMenu_FlowerGrow
            implements ITreeConfig {
                @Config.Comment(value={"'1 in x' chance the fruit flower will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int apple = 25;
                @Config.Comment(value={"'1 in x' chance the fruit flower will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int cherry = 25;
                @Config.Comment(value={"'1 in x' chance the fruit flower will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int orange = 25;
                @Config.Comment(value={"'1 in x' chance the fruit flower will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int pear = 25;
                @Config.Comment(value={"'1 in x' chance the fruit flower will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int peach = 25;
                @Config.Comment(value={"'1 in x' chance the fruit flower will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int mango = 25;
                @Config.Comment(value={"'1 in x' chance the fruit flower will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int lemon = 15;
                @Config.Comment(value={"'1 in x' chance the fruit flower will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int plum = 25;
                @Config.Comment(value={"'1 in x' chance the fruit flower will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int banana = 15;
            }

            public static class SubMenu_SaplingGrow
            implements ITreeConfig {
                @Config.Comment(value={"'1 in x' chance the sapling will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int apple = 10;
                @Config.Comment(value={"'1 in x' chance the sapling will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int cherry = 10;
                @Config.Comment(value={"'1 in x' chance the sapling will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int orange = 10;
                @Config.Comment(value={"'1 in x' chance the sapling will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int pear = 10;
                @Config.Comment(value={"'1 in x' chance the sapling will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int peach = 10;
                @Config.Comment(value={"'1 in x' chance the sapling will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int mango = 10;
                @Config.Comment(value={"'1 in x' chance the sapling will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int lemon = 10;
                @Config.Comment(value={"'1 in x' chance the sapling will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int plum = 10;
                @Config.Comment(value={"'1 in x' chance the sapling will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int coconut = 10;
                @Config.Comment(value={"'1 in x' chance the sapling will grow on the next block update"})
                @Config.RangeInt(min=0)
                public int banana = 10;
            }

            public static interface ITreeConfig {
                public static final int apple = 0;
                public static final int cherry = 0;
                public static final int orange = 0;
                public static final int pear = 0;
                public static final int peach = 0;
                public static final int mango = 0;
                public static final int lemon = 0;
                public static final int plum = 0;
                public static final int coconut = 0;
                public static final int banana = 0;
            }
        }

        public static class SubMenu_Stormforge {
            @Config.Comment(value={"When charging with Energy Units, sfPowerPerTickBase times this equals the base EU/t"})
            @Config.RangeDouble(min=0.001, max=1000.0)
            public double sfPowerMultiplierEU = 1.0;
            @Config.Comment(value={"When charging with Forge Units, sfPowerPerTickBase times this equals the base FU/t"})
            @Config.RangeDouble(min=0.001, max=1000.0)
            public double sfPowerMultiplierFU = 4.0;
            @Config.Comment(value={"When charging with Immersive Flux, sfPowerPerTickBase times this equals the base IF/t"})
            @Config.RangeDouble(min=0.001, max=1000.0)
            public double sfPowerMultiplierIF = 4.0;
            @Config.Comment(value={"When charging with Joules, sfPowerPerTickBase times this equals the base J/t"})
            @Config.RangeDouble(min=0.001, max=1000.0)
            public double sfPowerMultiplierJ = 10.0;
            @Config.Comment(value={"When charging with Redstone Flux, sfPowerPerTickBase times this equals the base RF/t"})
            @Config.RangeDouble(min=0.001, max=1000.0)
            public double sfPowerMultiplierRF = 4.0;
            @Config.Comment(value={"When charging with Tesla, sfPowerPerTickBase times this equals the base Tesla/t"})
            @Config.RangeDouble(min=0.001, max=1000.0)
            public double sfPowerMultiplierTesla = 4.0;
            @Config.Comment(value={"The base amount of energy charged per tick", "This value is multiplied by the PowerMultiplier that matches the items requirements"})
            @Config.RangeInt(min=1, max=2048)
            public int sfPowerPerTickBase = 32;
            @Config.Comment(value={"The number of ticks needed to repair an item by one point"})
            @Config.RangeInt(min=20, max=6000)
            public int sfTicksPerRepairPoint = 100;
            @Config.Comment(value={"The number of ticks needed to smelt an item, for reference a furnace takes 200"})
            @Config.RangeInt(min=20, max=6000)
            public int sfTicksToSmelt = 400;
        }

        public static class SubMenu_Mobs {
            @Config.Comment(value={"Must be enabled for any of the ones bellow to work"})
            public boolean enableMobDropTweaks = true;
            @Config.Comment(value={"Adds Burnium Dust and Coal Dust"})
            public boolean enableBlazeDropTweaks = true;
            @Config.Comment(value={"Adds feather moulting"})
            public boolean enableChickenDropTweaks = true;
            @Config.Comment(value={"Adds Endimium Dust and Ender Dust"})
            public boolean enableEndermanDropTweaks = true;
            @Config.Comment(value={"Adds Burnium Dust and Coal Dust"})
            public boolean enableMagmaCubeDropTweaks = true;
            @Config.Comment(value={"Adds Burnium Dust and Coal Dust"})
            public boolean enablePigZombieDropTweaks = true;
            @Config.Comment(value={"Adds Golden Apple"})
            public boolean enableSkeletonDropTweaks = true;
            @Config.Comment(value={"Adds Worn Leather Boots and Belt"})
            public boolean enableZombieDropTweaks = true;
            @Config.Comment(value={"Adds two AITasks", "Animals the follow for wheat will also follow for hay", "Animals that eat grass will also eat hay"})
            public boolean addHayAITasks = true;
        }

        public static class SubMenu_GlassShards {
            @Config.Comment(value={"Glass Blocks will drop shards when broken, if it would otherwise drop nothing"})
            public boolean enableGlassShardDropsForBlocks = true;
            @Config.Comment(value={"Splash Potions will drop a shard when broken"})
            public boolean enableGlassShardDropsForPotions = true;
        }

        static class SubMenu_FlowerPots {
            @Config.Comment(value={"Items Listed will render in flower pots using the Cross render style"})
            public String[] forceCrossRender = new String[0];
            @Config.Comment(value={"Items Listed will render in flower pots using the Block render style"})
            public String[] forceBlockRender = new String[0];
            @Config.Comment(value={"Items Listed will render in flower pots using the Pane render style"})
            public String[] forcePaneRender = new String[]{"minecraft:golden_rail", "minecraft:detector_rail", "minecraft:ladder", "minecraft:rail", "minecraft:iron_bars", "minecraft:glass_pane", "minecraft:vine", "minecraft:waterlily", "minecraft:activator_rail", "minecraft:stained_glass_pane", "terraqueous:blockFlowerPot"};
            @Config.Comment(value={"Items Listed will render in flower pots using the Tall render style"})
            public String[] forceTallRender = new String[]{"minecraft:cactus"};

            SubMenu_FlowerPots() {
            }
        }

        public static class SubMenu_Doodads {
            public SubMenu_Branch STICK = new SubMenu_Branch();
            public SubMenu_Stone STONE = new SubMenu_Stone();
            public SubMenu_Bone BONE = new SubMenu_Bone();
            public SubMenu_SandStone SANDSTONE = new SubMenu_SandStone();
            public SubMenu_RedSandStone REDSANDSTONE = new SubMenu_RedSandStone();
            public SubMenu_Endimium ENDIMIUM = new SubMenu_Endimium();
            public SubMenu_Burnium BURNIUM = new SubMenu_Burnium();

            public static class SubMenu_Burnium {
                @Config.Comment(value={"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropAttempts = 1;
                @Config.Comment(value={"'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist"})
                @Config.RangeInt(min=0)
                public int dropChance = 1;
                @Config.Comment(value={"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropCount = -3;
                @Config.Comment(value={"Items listed here have a chance to drop", "Formats: Dictionary Item: 'ore:<dictionary name>#<count>', Mod Item: '<modId>:<itemId>@<meta>#<count>'"})
                public String[] whitelist = new String[]{"ore:gemBurnium#1-3", "ore:dustBurnium#1-2", "ore:dustTinyBurnium#1-4"};
                @Config.Comment(value={"Items listed here can never drop", "Formats: Dictionary Item: 'ore:<dictionary name>', Mod Item: '<modId>:<itemId>', Exact Mod Item: '<modId>:<itemId>@<meta>', Entire Mod: 'mod:<modId>'"})
                public String[] blacklist = new String[0];
            }

            public static class SubMenu_Endimium {
                @Config.Comment(value={"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropAttempts = 1;
                @Config.Comment(value={"'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist"})
                @Config.RangeInt(min=0)
                public int dropChance = 1;
                @Config.Comment(value={"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropCount = -3;
                @Config.Comment(value={"Items listed here have a chance to drop", "Formats: Dictionary Item: 'ore:<dictionary name>#<count>', Mod Item: '<modId>:<itemId>@<meta>#<count>'"})
                public String[] whitelist = new String[]{"ore:gemEndimium#1-3", "ore:dustEndimium#1-2", "ore:dustTinyEndimium#1-4"};
                @Config.Comment(value={"Items listed here can never drop", "Formats: Dictionary Item: 'ore:<dictionary name>', Mod Item: '<modId>:<itemId>', Exact Mod Item: '<modId>:<itemId>@<meta>', Entire Mod: 'mod:<modId>'"})
                public String[] blacklist = new String[0];
            }

            public static class SubMenu_RedSandStone {
                @Config.Comment(value={"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropAttempts = 1;
                @Config.Comment(value={"'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist"})
                @Config.RangeInt(min=0)
                public int dropChance = 1;
                @Config.Comment(value={"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropCount = -2;
                @Config.Comment(value={"Items listed here have a chance to drop", "Formats: Dictionary Item: 'ore:<dictionary name>#<count>', Mod Item: '<modId>:<itemId>@<meta>#<count>'"})
                public String[] whitelist = new String[]{"ore:dust*#1", "terraqueous:item_main@216#1"};
                @Config.Comment(value={"Items listed here can never drop", "Formats: Dictionary Item: 'ore:<dictionary name>', Mod Item: '<modId>:<itemId>', Exact Mod Item: '<modId>:<itemId>@<meta>', Entire Mod: 'mod:<modId>'"})
                public String[] blacklist = new String[]{"ore:dust*Burnium", "ore:dust*Endimium"};
            }

            public static class SubMenu_SandStone {
                @Config.Comment(value={"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropAttempts = 1;
                @Config.Comment(value={"'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist"})
                @Config.RangeInt(min=0)
                public int dropChance = 1;
                @Config.Comment(value={"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropCount = -2;
                @Config.Comment(value={"Items listed here have a chance to drop", "Formats: Dictionary Item: 'ore:<dictionary name>#<count>', Mod Item: '<modId>:<itemId>@<meta>#<count>'"})
                public String[] whitelist = new String[]{"ore:dust*#1", "terraqueous:item_main@214#1"};
                @Config.Comment(value={"Items listed here can never drop", "Formats: Dictionary Item: 'ore:<dictionary name>', Mod Item: '<modId>:<itemId>', Exact Mod Item: '<modId>:<itemId>@<meta>', Entire Mod: 'mod:<modId>'"})
                public String[] blacklist = new String[]{"ore:dust*Burnium", "ore:dust*Endimium"};
            }

            public static class SubMenu_Bone {
                @Config.Comment(value={"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropAttempts = 1;
                @Config.Comment(value={"'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist"})
                @Config.RangeInt(min=0)
                public int dropChance = 1;
                @Config.Comment(value={"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropCount = -2;
                @Config.Comment(value={"Items listed here have a chance to drop", "Formats: Dictionary Item: 'ore:<dictionary name>#<count>', Mod Item: '<modId>:<itemId>@<meta>#<count>'"})
                public String[] whitelist = new String[]{"minecraft:bone@0#1", "minecraft:dye@15#1-3"};
                @Config.Comment(value={"Items listed here can never drop", "Formats: Dictionary Item: 'ore:<dictionary name>', Mod Item: '<modId>:<itemId>', Exact Mod Item: '<modId>:<itemId>@<meta>', Entire Mod: 'mod:<modId>'"})
                public String[] blacklist = new String[0];
            }

            public static class SubMenu_Stone {
                @Config.Comment(value={"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropAttempts = 1;
                @Config.Comment(value={"'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist"})
                @Config.RangeInt(min=0)
                public int dropChance = 1;
                @Config.Comment(value={"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropCount = -2;
                @Config.Comment(value={"Items listed here have a chance to drop", "Formats: Dictionary Item: 'ore:<dictionary name>#<count>', Mod Item: '<modId>:<itemId>@<meta>#<count>'"})
                public String[] whitelist = new String[]{"ore:dust*#1", "terraqueous:item_main@215#1"};
                @Config.Comment(value={"Items listed here can never drop", "Formats: Dictionary Item: 'ore:<dictionary name>', Mod Item: '<modId>:<itemId>', Exact Mod Item: '<modId>:<itemId>@<meta>', Entire Mod: 'mod:<modId>'"})
                public String[] blacklist = new String[]{"ore:dust*Burnium", "ore:dust*Endimium"};
            }

            public static class SubMenu_Branch {
                @Config.Comment(value={"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropAttempts = 1;
                @Config.Comment(value={"'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist"})
                @Config.RangeInt(min=0)
                public int dropChance = 1;
                @Config.Comment(value={"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"})
                public int dropCount = -2;
                @Config.Comment(value={"Items listed here have a chance to drop", "Formats: Dictionary Item: 'ore:<dictionary name>#<count>', Mod Item: '<modId>:<itemId>#<count>', Exact Mod Item: '<modId>:<itemId>@<meta>#<count>'"})
                public String[] whitelist = new String[]{"minecraft:stick@0#1-3"};
                @Config.Comment(value={"Items listed here can never drop", "Formats: Dictionary Item: 'ore:<dictionary name>', Mod Item: '<modId>:<itemId>', Exact Mod Item: '<modId>:<itemId>@<meta>', Entire Mod: 'mod:<modId>'"})
                public String[] blacklist = new String[0];
            }
        }

        public static class SubMenu_Chests {
            @Config.Comment(value={"Spawn Bonus Chests can contain LifeFruit"})
            public boolean chestSpawnBonus_LifeFruit = true;
            @Config.Comment(value={"Mineshaft Chests can contain DeathFruit"})
            public boolean chestMineshaft_DeathFruit = true;
            @Config.Comment(value={"Village Blacksmith Chests can contain a Molecular Colorizer"})
            public boolean chestBlacksmith_Colorizer = true;
            @Config.Comment(value={"Dungeon Chests can contain a Molecular Colorizer"})
            public boolean chestDungeon_Colorizer = true;
            @Config.Comment(value={"Stronghold Library Chests can contain a Strange Scroll"})
            public boolean chestStronghold_Scroll = true;
            @Config.Comment(value={"Nether Bridge Chests can contain a Strange Scroll"})
            public boolean chestNetherBridge_Scroll = true;
            @Config.Comment(value={"Dungeon Chests can contain the Toon Trotters"})
            public boolean chestDungeon_ToonTrotters = true;
        }
    }

    public static class Menu_Items {
        @Config.Comment(value={"Temporary protection from heat", "IDs: burnium_belt"})
        public boolean addBurniumBelt = true;
        @Config.Comment(value={"IDs: multifood & Entity: coconut"})
        public boolean addFood = true;
        @Config.Comment(value={"IDs: colorizer, hammer, multitool, scythe"})
        public boolean addTools = true;
        @Config.Comment(value={"Defy ..er.. Delay Gravity", "IDs: toon_trotters"})
        public boolean addToonTrotters = true;
        @Config.Comment(value={"Adds a craftable infinite 'water bucket'", "IDs: water_pearl"})
        public boolean addWaterPearl = true;
    }

    public static class Menu_Blocks {
        @Config.Comment(value={"IDs: border"})
        public boolean addBorders = true;
        @Config.Comment(value={"IDs: clouds, cloudfancy, cloud_staff, cloud_talisman", "NOTE: enables addEnderTable because it is needed to craft the Talisman used to walk-on clouds"})
        public boolean addClouds = true;
        @Config.Comment(value={"Adds: Cloud Doors, TrapDoors, Fences, FenceGates, Water Vapor & Glow Vapor", "IDs: type_cloud"})
        public boolean addCraftables_Cloud = true;
        @Config.Comment(value={"Adds: Wood Doors, TrapDoors, Fences, FenceGates, Paper Block & Glow Paper", "type_earth"})
        public boolean addCraftables_Wood = true;
        @Config.Comment(value={"Adds: CloudWorkbench, CloudFurnace, Cloud&Earth CraftBench, Cloud&Earth CraftFurnace, StormForge", "IDs: crafting"})
        public boolean addCrafting = true;
        @Config.Comment(value={"Adds: Breakable ground objects", "IDs: doodads"})
        public boolean addDoodads = true;
        @Config.Comment(value={"Adds: An Enchanting Table that uses EnderPowder, and an EnderMonocle to read from it", "IDs: ender_table, ender_monocle"})
        public boolean addEnderTable = true;
        @Config.Comment(value={"Adds: Two types of flower pots", "Changes: default Flower Pot recipe", "IDs: flowerpot"})
        public boolean addFlowerPots = true;
        @Config.Comment(value={"Adds: 16 new flowers that can spread and grow (see TWEAKS.enableFlowerSpread)", "IDs: flowers_cluster, flowers_single"})
        public boolean addFlowers = true;
        @Config.Comment(value={"Adds: Hay blocks, thresh, loose hay", "IDs: hay"})
        public boolean addHayBlocks = true;
        @Config.Comment(value={"IDs: earth_ore"})
        public boolean addOres = true;
        @Config.Comment(value={"Adds: Pergolas", "IDs: pergola"})
        public boolean addPergolas = true;
        @Config.Comment(value={"Adds: Pineapple, Cactus Pear, & Grapes(also requires Pergolas)", "IDs: plants"})
        public boolean addPlants = true;
        @Config.Comment(value={"Adds: Tall Grass that can spread and grow into Double Tall Grass", "IDs: tall_grass"})
        public boolean addTallGrass = true;
        @Config.Comment(value={"Adds: Apple, Chery, Orange, Coconut, & Banana Trees", "IDs: planks, sapling, trunk1, trunk2, foliage1, foliage2, foliage3, foliage4, foliage5"})
        public boolean addTrees = true;
    }
}

