/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.EntityId;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityTools {
    private static final EntityId FIXER = new EntityId();

    public static String fixEntityId(String id) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("id", id);
        nbt = FIXER.func_188217_a(nbt);
        return nbt.func_74779_i("id");
    }

    public static String findEntityIdByClass(Class<? extends Entity> clazz) {
        ResourceLocation key = EntityList.func_191306_a(clazz);
        return key == null ? null : key.toString();
    }

    public static String findEntityUnlocNameByClass(Class<? extends Entity> clazz) {
        ResourceLocation key = EntityList.func_191306_a(clazz);
        if (key == null) {
            return null;
        }
        EntityEntry value = (EntityEntry)ForgeRegistries.ENTITIES.getValue(key);
        if (value == null) {
            return null;
        }
        return value.getName();
    }

    public static String getEntityName(Entity entity) {
        return entity.func_70005_c_();
    }

    public static String findEntityLocNameByClass(Class<? extends Entity> clazz) {
        String nameByClass = EntityTools.findEntityIdByClass(clazz);
        if (nameByClass == null) {
            return null;
        }
        return I18n.func_74838_a((String)nameByClass);
    }

    public static Stream<String> getEntities() {
        Set keys = ForgeRegistries.ENTITIES.getKeys();
        return keys.stream().map(s -> s.toString());
    }

    public static Class<? extends Entity> findClassById(String id) {
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
        return entry == null ? null : entry.getEntityClass();
    }

    public static EntityLiving createEntity(World world, String mobId) {
        Class clazz = "WitherSkeleton".equals(mobId) ? EntityWitherSkeleton.class : ("StraySkeleton".equals(mobId) ? EntityStray.class : ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(mobId))).getEntityClass());
        EntityLiving entityLiving = null;
        try {
            entityLiving = (EntityLiving)clazz.getConstructor(World.class).newInstance(world);
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return entityLiving;
    }

    public static String findId(Class<? extends Entity> clazz, Entity entity) {
        return EntityList.func_191306_a(clazz).toString();
    }

    public static void moveEntity(Entity entity, double x, double y, double z) {
        entity.func_70091_d(MoverType.SELF, x, y, z);
    }

    public static void setSpawnerEntity(@Nonnull World world, @Nonnull TileEntityMobSpawner spawner, @Nonnull ResourceLocation resourceLocation, @Nonnull String entityName) {
        MobSpawnerBaseLogic mobspawnerbaselogic = spawner.func_145881_a();
        mobspawnerbaselogic.func_190894_a(resourceLocation);
        spawner.func_70296_d();
    }

    public static void registerModEntity(ResourceLocation resourceLocation, Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)resourceLocation, entityClass, (String)entityName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public static void registerModEntity(ResourceLocation resourceLocation, Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.registerModEntity((ResourceLocation)resourceLocation, entityClass, (String)entityName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)eggPrimary, (int)eggSecondary);
    }
}

