/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.tcinventoryscan.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.blay09.mods.tcinventoryscan.CommonProxy;
import net.blay09.mods.tcinventoryscan.TCInventoryScanning;
import net.blay09.mods.tcinventoryscan.net.MessageScanSelf;
import net.blay09.mods.tcinventoryscan.net.MessageScanSlot;
import net.blay09.mods.tcinventoryscan.net.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ScanningManager;

public class ClientProxy
extends CommonProxy {
    private static final int SCAN_TICKS = 25;
    private static final int SOUND_TICKS = 3;
    private static final int INVENTORY_PLAYER_X = 26;
    private static final int INVENTORY_PLAYER_Y = 8;
    private static final int INVENTORY_PLAYER_WIDTH = 52;
    private static final int INVENTORY_PLAYER_HEIGHT = 70;
    private Item thaumometer;
    private SoundEvent researchSound;
    private boolean missingMessageSent;
    private Slot mouseSlot;
    private Slot lastScannedSlot;
    private int ticksHovered;
    private Object currentScan;
    private boolean isHoveringPlayer;
    private boolean renderAspectsInGuiHasErrored;
    private Object hudHandlerInstance;
    private Method renderAspectsInGuiMethod;
    private boolean drawTagHasErrored;
    private Method drawTagMethod;

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        this.thaumometer = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("thaumcraft", "thaumometer"));
        this.researchSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("thaumcraft", "scan"));
    }

    private boolean isHoldingThaumometer() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return false;
        }
        ItemStack mouseItem = mc.field_71439_g.field_71071_by.func_70445_o();
        return !mouseItem.func_190926_b() && mouseItem.func_77973_b() == this.thaumometer;
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP entityPlayer = mc.field_71439_g;
        if (entityPlayer != null) {
            if (!TCInventoryScanning.isServerSideInstalled) {
                if (!this.missingMessageSent) {
                    entityPlayer.func_146105_b((ITextComponent)new TextComponentTranslation("tcinventoryscan:serverNotInstalled", new Object[0]), false);
                    this.missingMessageSent = true;
                }
                return;
            }
            if (this.isHoldingThaumometer()) {
                if (this.isHoveringPlayer && this.currentScan != null || this.mouseSlot != null && !this.mouseSlot.func_75211_c().func_190926_b() && this.mouseSlot.func_82869_a((EntityPlayer)entityPlayer) && this.mouseSlot != this.lastScannedSlot && !(this.mouseSlot instanceof SlotCrafting)) {
                    ++this.ticksHovered;
                    if (this.currentScan == null) {
                        this.currentScan = this.mouseSlot.func_75211_c();
                    }
                    if (ScanningManager.isThingStillScannable((EntityPlayer)entityPlayer, (Object)this.currentScan)) {
                        if (this.ticksHovered > 3 && this.ticksHovered % 4 == 0) {
                            entityPlayer.field_70170_p.func_184134_a(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, this.researchSound, SoundCategory.NEUTRAL, 0.2f, 0.45f + entityPlayer.field_70170_p.field_73012_v.nextFloat() * 0.1f, false);
                        }
                        if (this.ticksHovered >= 25) {
                            if (this.currentScan instanceof EntityPlayer) {
                                NetworkHandler.instance.sendToServer((IMessage)new MessageScanSelf());
                            } else {
                                NetworkHandler.instance.sendToServer((IMessage)new MessageScanSlot(this.mouseSlot.field_75222_d));
                            }
                            this.ticksHovered = 0;
                            this.lastScannedSlot = this.mouseSlot;
                            this.currentScan = null;
                        }
                    } else {
                        this.currentScan = null;
                        this.lastScannedSlot = this.mouseSlot;
                    }
                }
            } else {
                this.ticksHovered = 0;
                this.currentScan = null;
                this.lastScannedSlot = null;
            }
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (TCInventoryScanning.isServerSideInstalled && event.getItemStack().func_77973_b() == this.thaumometer) {
            event.getToolTip().add(TextFormatting.GOLD + I18n.func_135052_a((String)"tcinventoryscan:thaumometerTooltip", (Object[])new Object[0]));
            if (GuiScreen.func_146272_n()) {
                String[] lines;
                for (String line : lines = I18n.func_135052_a((String)"tcinventoryscan:thaumometerTooltipMore", (Object[])new Object[0]).split("\\\\n")) {
                    event.getToolTip().add(TextFormatting.DARK_AQUA + line);
                }
            }
        }
    }

    @SubscribeEvent
    public void onTooltipPostText(RenderTooltipEvent.PostText event) {
        if (this.isHoldingThaumometer() && !GuiScreen.func_146272_n()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r instanceof GuiContainer && !ScanningManager.isThingStillScannable((EntityPlayer)mc.field_71439_g, (Object)event.getStack())) {
                this.renderAspectsInGui((GuiContainer)mc.field_71462_r, (EntityPlayer)mc.field_71439_g, event.getStack(), 0, event.getX(), event.getY());
            }
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (TCInventoryScanning.isServerSideInstalled && event.getGui() instanceof GuiContainer && !(event.getGui() instanceof GuiContainerCreative)) {
            ItemStack mouseItem;
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP entityPlayer = mc.field_71439_g;
            boolean oldHoveringPlayer = this.isHoveringPlayer;
            this.isHoveringPlayer = this.isHoveringPlayer((GuiContainer)event.getGui(), event.getMouseX(), event.getMouseY());
            if (!this.isHoveringPlayer) {
                Slot oldMouseSlot = this.mouseSlot;
                this.mouseSlot = ((GuiContainer)event.getGui()).getSlotUnderMouse();
                if (oldMouseSlot != this.mouseSlot) {
                    this.ticksHovered = 0;
                    this.currentScan = null;
                }
            }
            if (oldHoveringPlayer != this.isHoveringPlayer) {
                this.ticksHovered = 0;
                if (this.isHoveringPlayer) {
                    this.currentScan = entityPlayer;
                    if (!ScanningManager.isThingStillScannable((EntityPlayer)entityPlayer, (Object)this.currentScan)) {
                        this.currentScan = null;
                    }
                }
            }
            if (!(mouseItem = entityPlayer.field_71071_by.func_70445_o()).func_190926_b() && mouseItem.func_77973_b() == this.thaumometer) {
                if (this.mouseSlot != null && !this.mouseSlot.func_75211_c().func_190926_b()) {
                    if (this.currentScan != null) {
                        this.renderScanningProgress(event.getGui(), event.getMouseX(), event.getMouseY(), (float)this.ticksHovered / 25.0f);
                    }
                    event.getGui().func_146285_a(this.mouseSlot.func_75211_c(), event.getMouseX(), event.getMouseY());
                } else if (this.isHoveringPlayer) {
                    if (this.currentScan != null) {
                        this.renderScanningProgress(event.getGui(), event.getMouseX(), event.getMouseY(), (float)this.ticksHovered / 25.0f);
                    }
                    if (!ScanningManager.isThingStillScannable((EntityPlayer)entityPlayer, (Object)entityPlayer)) {
                        this.renderPlayerAspects(event.getGui(), event.getMouseX(), event.getMouseY());
                    }
                }
            }
        }
    }

    private void renderAspectsInGui(GuiContainer guiContainer, EntityPlayer player, ItemStack itemStack, int d, int x, int y) {
        if (this.renderAspectsInGuiHasErrored) {
            return;
        }
        if (this.hudHandlerInstance == null) {
            try {
                Class<?> renderEventHandler = Class.forName("thaumcraft.client.lib.events.RenderEventHandler");
                Object instance = renderEventHandler.getField("INSTANCE").get(null);
                this.hudHandlerInstance = renderEventHandler.getField("hudHandler").get(instance);
                Class<?> hudHandler = Class.forName("thaumcraft.client.lib.events.HudHandler");
                this.renderAspectsInGuiMethod = hudHandler.getMethod("renderAspectsInGui", GuiContainer.class, EntityPlayer.class, ItemStack.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                this.renderAspectsInGuiHasErrored = true;
                e.printStackTrace();
                return;
            }
        }
        try {
            this.renderAspectsInGuiMethod.invoke(this.hudHandlerInstance, guiContainer, player, itemStack, d, x, y);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.renderAspectsInGuiHasErrored = true;
            e.printStackTrace();
        }
    }

    private void drawTag(int x, int y, Aspect aspect, float amount, int bonus, double zLevel) {
        if (this.drawTagHasErrored) {
            return;
        }
        if (this.drawTagMethod == null) {
            try {
                Class<?> utilsFX = Class.forName("thaumcraft.client.lib.UtilsFX");
                this.drawTagMethod = utilsFX.getMethod("drawTag", Integer.TYPE, Integer.TYPE, Aspect.class, Float.TYPE, Integer.TYPE, Double.TYPE);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                this.drawTagHasErrored = true;
                e.printStackTrace();
                return;
            }
        }
        try {
            this.drawTagMethod.invoke(null, x, y, aspect, Float.valueOf(amount), bonus, zLevel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.drawTagHasErrored = true;
            e.printStackTrace();
        }
    }

    private void renderPlayerAspects(GuiScreen gui, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushAttrib((int)1048575);
        GlStateManager.func_179140_f();
        int x = mouseX + 17;
        int y = mouseY + 7 - 33;
        EntityPlayerSP entityPlayer = FMLClientHandler.instance().getClientPlayerEntity();
        AspectList aspectList = AspectHelper.getEntityAspects((Entity)entityPlayer);
        if (aspectList != null && aspectList.size() > 0) {
            Aspect[] sortedAspects;
            GlStateManager.func_179097_i();
            for (Aspect aspect : sortedAspects = aspectList.getAspectsSortedByAmount()) {
                if (aspect == null) continue;
                this.drawTag(x, y, aspect, aspectList.getAmount(aspect), 0, gui.field_73735_i);
                x += 18;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
    }

    private void renderScanningProgress(GuiScreen gui, int mouseX, int mouseY, float progress) {
        StringBuilder sb = new StringBuilder("\u00a76");
        sb.append(I18n.func_135052_a((String)"tcinventoryscan:scanning", (Object[])new Object[0]));
        if (progress >= 0.75f) {
            sb.append("...");
        } else if (progress >= 0.5f) {
            sb.append("..");
        } else if (progress >= 0.25f) {
            sb.append(".");
        }
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        float oldZLevel = gui.field_73735_i;
        gui.field_73735_i = 300.0f;
        Minecraft.func_71410_x().field_71466_p.func_175063_a(sb.toString(), (float)mouseX, (float)(mouseY - 30), -1);
        gui.field_73735_i = oldZLevel;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    private boolean isHoveringPlayer(GuiContainer gui, int mouseX, int mouseY) {
        return gui instanceof GuiInventory && mouseX >= gui.field_147003_i + 26 && mouseX < gui.field_147003_i + 26 + 52 && mouseY >= gui.field_147009_r + 8 && mouseY < gui.field_147009_r + 8 + 70;
    }
}

