/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import jaredbgreat.dldungeons.pieces.chests.LootItem;
import jaredbgreat.dldungeons.pieces.chests.LootList;
import jaredbgreat.dldungeons.pieces.chests.LootListSet;
import jaredbgreat.dldungeons.pieces.chests.LootType;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;

public class LootCategory {
    public static final int LEVELS = 7;
    private final LootListSet lists;
    public LootList[] gear;
    public LootList[] heal;
    public LootList[] loot;

    public LootCategory(LootListSet listset) {
        this.lists = listset;
        this.gear = new LootList[]{this.lists.gear1, this.lists.gear2, this.lists.gear3, this.lists.gear4, this.lists.gear5, this.lists.gear6, this.lists.gear7};
        this.heal = new LootList[]{this.lists.heal1, this.lists.heal2, this.lists.heal3, this.lists.heal4, this.lists.heal5, this.lists.heal6, this.lists.heal7};
        this.loot = new LootList[]{this.lists.loot1, this.lists.loot2, this.lists.loot3, this.lists.loot4, this.lists.loot5, this.lists.loot6, this.lists.loot7};
    }

    public ItemStack getLoot(LootType type, int level, Random random) {
        if (level <= 6) {
            level = Math.min(6, level + random.nextInt(2) - random.nextInt(2));
        }
        if (level < 0) {
            level = 0;
        }
        switch (type) {
            case GEAR: {
                if (random.nextBoolean()) {
                    return this.getEnchantedGear(level, random);
                }
                return this.gear[Math.min(6, level)].getLoot(random).getStack(random);
            }
            case HEAL: {
                return this.heal[Math.min(6, level)].getLoot(random).getStack(random);
            }
            case LOOT: {
                if (level > 6) {
                    if (level > random.nextInt(100)) {
                        return this.lists.special.getLoot(random).getStack(random);
                    }
                    level = 6;
                }
                if (random.nextInt(10) == 0) {
                    return this.getEnchantedBook(level, random);
                }
                return this.loot[level].getLoot(random).getStack(random);
            }
        }
        switch (random.nextInt(3)) {
            case 0: {
                return this.getLoot(LootType.GEAR, level, random);
            }
            case 1: {
                return this.getLoot(LootType.HEAL, level, random);
            }
        }
        return this.getLoot(LootType.LOOT, level, random);
    }

    private ItemStack getEnchantedGear(int lootLevel, Random random) {
        ItemStack out = null;
        float portion = random.nextFloat() / 2.0f;
        int lootPart = Math.min(6, Math.max(0, (int)((float)lootLevel * (1.0f - portion) + 0.5f)));
        int enchPart = Math.min(30, Math.max(0, (int)((float)lootLevel * portion * 10.0f)));
        LootItem item = this.gear[lootPart].getLoot(random);
        if (enchPart >= 1 && this.isEnchantable(item)) {
            out = item.getStack(random);
            out = EnchantmentHelper.func_77504_a((Random)random, (ItemStack)out, (int)enchPart, (boolean)true);
        } else {
            out = this.gear[Math.min(6, lootLevel)].getLoot(random).getStack(random);
        }
        return out;
    }

    private boolean isEnchantable(LootItem in) {
        Item item = in.item;
        return item instanceof ItemSword || item instanceof ItemTool || item instanceof ItemArmor || item instanceof ItemBow;
    }

    private ItemStack getEnchantedBook(int level, Random random) {
        ItemStack out = new ItemStack(Items.field_151122_aG, 1);
        out = EnchantmentHelper.func_77504_a((Random)random, (ItemStack)out, (int)Math.min(30, (int)((double)level * 7.5)), (boolean)true);
        return out;
    }

    public LootListSet getLists() {
        return this.lists;
    }
}

