/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.entity;

import com.google.common.collect.ImmutableList;
import com.rwtema.careerbees.bees.CareerBeeSpecies;
import com.rwtema.careerbees.entity.BeeEntry;
import com.rwtema.careerbees.entity.PlacedBeeManager;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosome;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class YenteBeeManager
extends PlacedBeeManager<BeeEntry.YentaBeeEntry> {
    static final List<EnumTolerance> toleranceList = ImmutableList.of((Object)EnumTolerance.BOTH_5, (Object)EnumTolerance.BOTH_4, (Object)EnumTolerance.BOTH_3, (Object)EnumTolerance.BOTH_2, (Object)EnumTolerance.BOTH_1, (Object)EnumTolerance.UP_5, (Object)EnumTolerance.DOWN_5, (Object)EnumTolerance.UP_4, (Object)EnumTolerance.DOWN_4, (Object)EnumTolerance.UP_3, (Object)EnumTolerance.DOWN_3, (Object)EnumTolerance.UP_2, (Object[])new EnumTolerance[]{EnumTolerance.DOWN_2, EnumTolerance.UP_1, EnumTolerance.DOWN_1, EnumTolerance.NONE}).reverse();

    public YenteBeeManager() {
        super(CareerBeeSpecies.YENTE);
    }

    @Override
    protected void onPlaced(@Nonnull EntityPlayer entityPlayer) {
        entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("careerbees.message.placed.yente.bee", new Object[0]));
    }

    @Override
    protected boolean isValidBeeType(EnumBeeType type, IAlleleBeeSpecies primary, IAlleleBeeSpecies secondary) {
        return primary == secondary && primary == CareerBeeSpecies.YENTE.get() && type == EnumBeeType.PRINCESS;
    }

    @Override
    @Nonnull
    protected BeeEntry.YentaBeeEntry createEntry(IBeeHousing tileEntity, NBTTagCompound tag) {
        return new BeeEntry.YentaBeeEntry(tag);
    }

    @Override
    @Nonnull
    protected BeeEntry.YentaBeeEntry recreateBeeEntry(NBTTagCompound stack) {
        return new BeeEntry.YentaBeeEntry(stack);
    }

    @Override
    protected boolean updateTile(Chunk chunk, Map.Entry<BlockPos, BeeEntry.YentaBeeEntry> k, @Nonnull IBeeHousing hou, @Nonnull TileEntity tileEntity) {
        IBeeHousingInventory beeInventory = hou.getBeeInventory();
        IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (capability == null) {
            return true;
        }
        if (beeInventory.getQueen().func_190926_b()) {
            int bestSlot = -1;
            int bestScore = Integer.MIN_VALUE;
            for (int i = 0; i < capability.getSlots(); ++i) {
                int score;
                IBee bee;
                ItemStack stackInSlot = capability.extractItem(i, 1, true);
                if (stackInSlot.func_190926_b() || BeeManager.beeRoot.getType(stackInSlot) != EnumBeeType.PRINCESS || (bee = BeeManager.beeRoot.getMember(stackInSlot)) == null || (score = bee.getGenome().getPrimary().getComplexity() + bee.getGenome().getSecondary().getComplexity()) <= bestScore) continue;
                bestSlot = i;
                bestScore = score;
            }
            if (bestSlot != -1) {
                ItemStack itemStack = capability.extractItem(bestSlot, 1, false);
                beeInventory.setQueen(itemStack);
            }
        }
        if (!beeInventory.getQueen().func_190926_b() && beeInventory.getDrone().func_190926_b()) {
            EnumBeeType type = BeeManager.beeRoot.getType(beeInventory.getQueen());
            IBee queenBee = BeeManager.beeRoot.getMember(beeInventory.getQueen());
            if (type == EnumBeeType.PRINCESS && queenBee != null) {
                IBeeGenome queenGenome = queenBee.getGenome();
                int bestSlot = -1;
                int bestScore = Integer.MIN_VALUE;
                for (int i = 0; i < capability.getSlots(); ++i) {
                    IBee bee;
                    ItemStack stackInSlot = capability.extractItem(i, 1, true);
                    if (stackInSlot.func_190926_b() || BeeManager.beeRoot.getType(stackInSlot) != EnumBeeType.DRONE || (bee = BeeManager.beeRoot.getMember(stackInSlot)) == null) continue;
                    int score = 0;
                    IBeeGenome droneGenome = bee.getGenome();
                    for (int j = 0; j < queenGenome.getChromosomes().length; ++j) {
                        IChromosome droneChromosome = droneGenome.getChromosomes()[j];
                        IChromosome queenChromosome = queenGenome.getChromosomes()[j];
                        for (IAllele a : new IAllele[]{droneChromosome.getPrimaryAllele(), droneChromosome.getSecondaryAllele()}) {
                            for (IAllele b : new IAllele[]{queenChromosome.getPrimaryAllele(), queenChromosome.getSecondaryAllele()}) {
                                if (a != b) continue;
                                score += 5;
                            }
                        }
                        for (IAllele a : new IAllele[]{droneChromosome.getPrimaryAllele(), droneChromosome.getSecondaryAllele()}) {
                            score += this.evaluate(EnumBeeChromosome.values()[j], a);
                        }
                    }
                    if (score <= bestScore) continue;
                    bestSlot = i;
                    bestScore = score;
                }
                if (bestSlot != -1) {
                    ItemStack itemStack = capability.extractItem(bestSlot, 1, false);
                    beeInventory.setDrone(itemStack);
                }
            }
        }
        return false;
    }

    public int evaluate(@Nonnull EnumBeeChromosome chromosome, @Nonnull IAllele a) {
        int score = 0;
        switch (chromosome) {
            case SPECIES: {
                score += ((IAlleleSpecies)a).getComplexity() * 10;
                break;
            }
            case SPEED: {
                score += Math.round(((IAlleleFloat)a).getValue() * 10.0f);
                break;
            }
            case FERTILITY: {
                score += ((IAlleleInteger)a).getValue() * 2;
                break;
            }
            case TEMPERATURE_TOLERANCE: 
            case HUMIDITY_TOLERANCE: {
                EnumTolerance tolerance = ((IAlleleTolerance)a).getValue();
                score += toleranceList.indexOf(tolerance);
                break;
            }
            case NEVER_SLEEPS: 
            case TOLERATES_RAIN: 
            case CAVE_DWELLING: {
                score += ((IAlleleBoolean)a).getValue() ? 5 : 0;
                break;
            }
            case TERRITORY: {
                Vec3i value = ((IAlleleArea)a).getValue();
                score += (value.func_177958_n() + value.func_177956_o() + value.func_177952_p()) / 3;
                break;
            }
        }
        return score;
    }
}

