/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.integration.jei.rending;

import com.google.common.collect.Maps;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.abyssalcraft.integration.jei.rending.RendingEntry;
import com.shinoow.abyssalcraft.lib.NecronomiconText;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class RendingRecipeWrapper
implements IRecipeWrapper {
    private final ItemStack output;
    private final int dimension;
    private final String description;
    private final RendingEntry entry;
    private Map<Integer, String> dimToString = Maps.newHashMap();

    public RendingRecipeWrapper(@Nonnull RendingEntry entry) {
        this.output = entry.output;
        this.dimension = entry.dimension;
        this.description = entry.description;
        this.entry = entry;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ItemStack> getOutputs() {
        return Collections.singletonList(this.output);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.dimToString.putAll(RitualRegistry.instance().getDimensionNameMappings());
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        if (this.entry.dimension != -1) {
            fr.func_78279_b(I18n.func_135052_a((String)NecronomiconText.LABEL_LOCATION, (Object[])new Object[0]) + ": " + this.getDimension(this.entry.dimension), 2, 20, 180, 0);
            fr.func_78279_b("Energy type: " + this.entry.type, 2, 40, 180, 0);
            fr.func_78279_b(this.entry.description, 2, 70, 180, 0);
        } else {
            fr.func_78279_b("Energy type: " + this.entry.type, 2, 20, 180, 0);
            fr.func_78279_b(this.entry.description, 2, 40, 180, 0);
        }
    }

    private String getDimension(int dim) {
        if (!this.dimToString.containsKey(dim)) {
            this.dimToString.put(dim, "DIM" + dim);
        }
        return this.dimToString.get(dim);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }
}

