/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.integration.jei.crystallizer;

import com.google.common.collect.ImmutableList;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityCrystallizer;
import com.shinoow.abyssalcraft.integration.jei.JEIUtils;
import com.shinoow.abyssalcraft.integration.jei.crystallizer.CrystallizerFuelRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class CrystallizerFuelRecipeMaker {
    @Nonnull
    public static List<CrystallizerFuelRecipe> getFuelRecipes(JEIUtils itemRegistry, IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        IStackHelper stackHelper = helpers.getStackHelper();
        ImmutableList<ItemStack> fuelStacks = itemRegistry.getCrystallizerFuels();
        HashSet<String> oreDictNames = new HashSet<String>();
        ArrayList<CrystallizerFuelRecipe> fuelRecipes = new ArrayList<CrystallizerFuelRecipe>(fuelStacks.size());
        for (ItemStack fuelStack : fuelStacks) {
            int burnTime;
            if (fuelStack == null) continue;
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)fuelStack);
            if (oreIDs.length > 0) {
                for (int oreID : oreIDs) {
                    int burnTime2;
                    String name = OreDictionary.getOreName((int)oreID);
                    if (oreDictNames.contains(name)) continue;
                    oreDictNames.add(name);
                    NonNullList oreDictFuels = OreDictionary.getOres((String)name);
                    List oreDictFuelsSet = stackHelper.getAllSubtypes((Iterable)oreDictFuels);
                    CrystallizerFuelRecipeMaker.removeNoBurnTime(oreDictFuelsSet);
                    if (oreDictFuelsSet.isEmpty() || (burnTime2 = CrystallizerFuelRecipeMaker.getBurnTime((ItemStack)oreDictFuelsSet.get(0))) <= 0) continue;
                    fuelRecipes.add(new CrystallizerFuelRecipe(guiHelper, oreDictFuelsSet, burnTime2));
                }
                continue;
            }
            List subtypes = stackHelper.getSubtypes(fuelStack);
            ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
            for (ItemStack subtype : subtypes) {
                if (TileEntityCrystallizer.getCrystallizationTime(subtype) <= 0) continue;
                fuels.add(subtype);
            }
            if (fuels.isEmpty() || (burnTime = CrystallizerFuelRecipeMaker.getBurnTime((ItemStack)fuels.get(0))) <= 0) continue;
            fuelRecipes.add(new CrystallizerFuelRecipe(guiHelper, fuels, burnTime));
        }
        return fuelRecipes;
    }

    private static void removeNoBurnTime(Collection<ItemStack> itemStacks) {
        itemStacks.removeIf(stack -> CrystallizerFuelRecipeMaker.getBurnTime(stack) == 0);
    }

    private static int getBurnTime(ItemStack itemStack) {
        return TileEntityCrystallizer.getCrystallizationTime(itemStack);
    }
}

