/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.integration.jei;

import com.google.common.collect.ImmutableList;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityCrystallizer;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityTransmutator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredientRegistry;
import net.minecraft.item.ItemStack;

public class JEIUtils {
    @Nonnull
    private final ImmutableList<ItemStack> transmutatorFuels;
    @Nonnull
    private final ImmutableList<ItemStack> crystallizerFuels;

    public JEIUtils(IIngredientRegistry registry) {
        ArrayList<ItemStack> fuelsTMutable = new ArrayList<ItemStack>();
        ArrayList<ItemStack> fuelsCMutable = new ArrayList<ItemStack>();
        for (ItemStack stack : registry.getAllIngredients(ItemStack.class)) {
            this.addItemStack(stack, AbyssalCraftAPI.FuelType.TRANSMUTATOR, fuelsTMutable);
            this.addItemStack(stack, AbyssalCraftAPI.FuelType.CRYSTALLIZER, fuelsCMutable);
        }
        this.transmutatorFuels = ImmutableList.copyOf(fuelsTMutable);
        this.crystallizerFuels = ImmutableList.copyOf(fuelsCMutable);
    }

    @Nonnull
    public ImmutableList<ItemStack> getTransmutatorFuels() {
        return this.transmutatorFuels;
    }

    @Nonnull
    public ImmutableList<ItemStack> getCrystallizerFuels() {
        return this.crystallizerFuels;
    }

    private void addItemStack(@Nonnull ItemStack stack, @Nonnull AbyssalCraftAPI.FuelType type, @Nonnull List<ItemStack> fuels) {
        switch (type) {
            case CRYSTALLIZER: {
                if (!TileEntityCrystallizer.isItemFuel(stack)) break;
                fuels.add(stack);
                break;
            }
            case FURNACE: {
                break;
            }
            case TRANSMUTATOR: {
                if (!TileEntityTransmutator.isItemFuel(stack)) break;
                fuels.add(stack);
                break;
            }
        }
    }
}

