/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.entity;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.entity.ICoraliumEntity;
import com.shinoow.abyssalcraft.common.entity.EntityDragonBoss;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLoot;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityDragonMinion
extends EntityMob
implements IEntityMultiPart,
ICoraliumEntity {
    public static final float innerRotation = 0.0f;
    public double targetX;
    public double targetY;
    public double targetZ;
    public double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    public MultiPartEntityPart[] dragonPartArray;
    public MultiPartEntityPart dragonPartHead = new MultiPartEntityPart((IEntityMultiPart)this, "head", 3.0f, 3.0f);
    public MultiPartEntityPart dragonPartBody = new MultiPartEntityPart((IEntityMultiPart)this, "body", 4.0f, 4.0f);
    public MultiPartEntityPart dragonPartTail1 = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 2.0f, 2.0f);
    public MultiPartEntityPart dragonPartTail2 = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 2.0f, 2.0f);
    public MultiPartEntityPart dragonPartTail3 = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 2.0f, 2.0f);
    public MultiPartEntityPart dragonPartWing1 = new MultiPartEntityPart((IEntityMultiPart)this, "wing", 2.0f, 2.0f);
    public MultiPartEntityPart dragonPartWing2 = new MultiPartEntityPart((IEntityMultiPart)this, "wing", 2.0f, 2.0f);
    public float prevAnimTime;
    public float animTime;
    public boolean forceNewTarget;
    private Entity target;
    public EntityDragonBoss healingcircle;

    public EntityDragonMinion(World par1World) {
        super(par1World);
        this.dragonPartArray = new MultiPartEntityPart[]{this.dragonPartHead, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartWing1, this.dragonPartWing2};
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(8.0f, 3.0f);
        this.field_70145_X = true;
        this.targetY = 100.0;
        this.field_70178_ae = true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (ACConfig.hardcoreMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public double[] getMovementOffsets(int par1, float par2) {
        if (this.func_110143_aJ() <= 0.0f) {
            par2 = 0.0f;
        }
        par2 = 1.0f - par2;
        int j = this.ringBufferIndex - par1 * 1 & 0x3F;
        int k = this.ringBufferIndex - par1 * 1 - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[j][0];
        double d1 = MathHelper.func_76138_g((double)(this.ringBuffer[k][0] - d0));
        adouble[0] = d0 + d1 * (double)par2;
        d0 = this.ringBuffer[j][1];
        d1 = this.ringBuffer[k][1] - d0;
        adouble[1] = d0 + d1 * (double)par2;
        adouble[2] = this.ringBuffer[j][2] + (this.ringBuffer[k][2] - this.ringBuffer[j][2]) * (double)par2;
        return adouble;
    }

    protected ResourceLocation func_184647_J() {
        return ACLoot.ENTITY_SPECTRAL_DRAGON;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70636_d() {
        float f1;
        float f;
        if (this.field_70170_p.field_72995_K) {
            f = MathHelper.func_76134_b((float)(this.animTime * (float)Math.PI * 2.0f));
            f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
            }
        }
        this.prevAnimTime = this.animTime;
        if (this.func_110143_aJ() <= 0.0f) {
            f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            if (ACConfig.particleEntity) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            float f3;
            double d2;
            double d1;
            double d3;
            this.updateHealingCircle();
            f = 0.2f / (MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 10.0f + 1.0f);
            this.animTime += (f *= (float)Math.pow(2.0, this.field_70181_x));
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.field_70177_z;
                    this.ringBuffer[i][1] = this.field_70163_u;
                }
            }
            if (++this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
            this.ringBuffer[this.ringBufferIndex][1] = this.field_70163_u;
            if (this.field_70170_p.field_72995_K) {
                if (this.field_70716_bi > 0) {
                    d3 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
                    double d0 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
                    d1 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
                    d2 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                    this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                    this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
                    --this.field_70716_bi;
                    this.func_70107_b(d3, d0, d1);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else {
                d3 = this.targetX - this.field_70165_t;
                double d0 = this.targetY - this.field_70163_u;
                d1 = this.targetZ - this.field_70161_v;
                d2 = d3 * d3 + d0 * d0 + d1 * d1;
                if (this.target != null) {
                    this.targetX = this.target.field_70165_t;
                    this.targetZ = this.target.field_70161_v;
                    double d4 = this.targetX - this.field_70165_t;
                    double d5 = this.targetZ - this.field_70161_v;
                    double d6 = Math.sqrt(d4 * d4 + d5 * d5);
                    double d7 = (double)0.4f + d6 / 80.0 - 1.0;
                    if (d7 > 10.0) {
                        d7 = 10.0;
                    }
                    this.targetY = this.target.func_174813_aQ().field_72338_b + d7;
                } else {
                    this.targetX += this.field_70146_Z.nextGaussian() * 2.0;
                    this.targetZ += this.field_70146_Z.nextGaussian() * 2.0;
                }
                if (this.forceNewTarget || d2 < 100.0 || d2 > 22500.0 || this.field_70123_F || this.field_70124_G) {
                    this.setNewTarget();
                }
                if ((d0 /= (double)MathHelper.func_76133_a((double)(d3 * d3 + d1 * d1))) < (double)(-(f3 = 0.6f))) {
                    d0 = -f3;
                }
                if (d0 > (double)f3) {
                    d0 = f3;
                }
                this.field_70181_x += d0 * (double)0.1f;
                this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
                double d8 = 180.0 - Math.atan2(d3, d1) * 180.0 / Math.PI;
                double d9 = MathHelper.func_76138_g((double)(d8 - (double)this.field_70177_z));
                if (d9 > 50.0) {
                    d9 = 50.0;
                }
                if (d9 < -50.0) {
                    d9 = -50.0;
                }
                Vec3d vec3 = new Vec3d(this.targetX - this.field_70165_t, this.targetY - this.field_70163_u, this.targetZ - this.field_70161_v).func_72432_b();
                Vec3d vec31 = new Vec3d((double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)), this.field_70181_x, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)))).func_72432_b();
                float f4 = (float)(vec31.func_72430_b(vec3) + 0.5) / 1.5f;
                if (f4 < 0.0f) {
                    f4 = 0.0f;
                }
                this.field_70704_bt *= 0.8f;
                float f5 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 1.0f + 1.0f;
                double d10 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 1.0 + 1.0;
                if (d10 > 40.0) {
                    d10 = 40.0;
                }
                this.field_70704_bt = (float)((double)this.field_70704_bt + d9 * ((double)0.7f / d10 / (double)f5));
                this.field_70177_z += this.field_70704_bt * 0.1f;
                float f6 = (float)(2.0 / (d10 + 1.0));
                float f7 = 0.06f;
                this.func_191958_b(0.0f, 0.0f, -1.0f, f7 * (f4 * f6 + (1.0f - f6)));
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                Vec3d vec32 = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
                float f8 = (float)(vec32.func_72430_b(vec31) + 1.0) / 2.5f;
                f8 = 0.8f + 0.15f * f8;
                this.field_70159_w *= (double)f8;
                this.field_70179_y *= (double)f8;
                this.field_70181_x *= (double)0.91f;
            }
            this.field_70761_aq = this.field_70177_z;
            this.dragonPartHead.field_70131_O = 1.5f;
            this.dragonPartHead.field_70130_N = 1.5f;
            this.dragonPartTail1.field_70131_O = 1.0f;
            this.dragonPartTail1.field_70130_N = 1.0f;
            this.dragonPartTail2.field_70131_O = 1.0f;
            this.dragonPartTail2.field_70130_N = 1.0f;
            this.dragonPartTail3.field_70131_O = 1.0f;
            this.dragonPartTail3.field_70130_N = 1.0f;
            this.dragonPartBody.field_70131_O = 1.5f;
            this.dragonPartBody.field_70130_N = 2.5f;
            this.dragonPartWing1.field_70131_O = 1.0f;
            this.dragonPartWing1.field_70130_N = 2.0f;
            this.dragonPartWing2.field_70131_O = 1.0f;
            this.dragonPartWing2.field_70130_N = 2.0f;
            f1 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f / 180.0f * (float)Math.PI;
            float f2 = MathHelper.func_76134_b((float)f1);
            float f9 = -MathHelper.func_76126_a((float)f1);
            float f10 = this.field_70177_z * (float)Math.PI / 180.0f;
            float f11 = MathHelper.func_76126_a((float)f10);
            float f12 = MathHelper.func_76134_b((float)f10);
            this.dragonPartBody.func_70071_h_();
            this.dragonPartBody.func_70012_b(this.field_70165_t + (double)(f11 * 0.1f), this.field_70163_u, this.field_70161_v - (double)(f12 * 0.1f), 0.0f, 0.0f);
            this.dragonPartWing1.func_70071_h_();
            this.dragonPartWing1.func_70012_b(this.field_70165_t + (double)(f12 * 2.2f), this.field_70163_u + 1.0, this.field_70161_v + (double)(f11 * 2.2f), 0.0f, 0.0f);
            this.dragonPartWing2.func_70071_h_();
            this.dragonPartWing2.func_70012_b(this.field_70165_t - (double)(f12 * 2.2f), this.field_70163_u + 1.0, this.field_70161_v - (double)(f11 * 2.2f), 0.0f, 0.0f);
            if (!this.field_70170_p.field_72995_K && this.field_70737_aN == 0) {
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing1.func_174813_aQ().func_72314_b(1.0, 0.5, 1.0).func_72317_d(0.0, -0.5, 0.0)));
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing2.func_174813_aQ().func_72314_b(1.0, 0.5, 1.0).func_72317_d(0.0, -0.5, 0.0)));
                this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartHead.func_174813_aQ().func_72314_b(0.25, 0.25, 0.25)));
            }
            double[] adouble = this.getMovementOffsets(5, 1.0f);
            double[] adouble1 = this.getMovementOffsets(0, 1.0f);
            f3 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f - this.field_70704_bt * 0.01f));
            float f13 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f - this.field_70704_bt * 0.01f));
            this.dragonPartHead.func_70071_h_();
            this.dragonPartHead.func_70012_b(this.field_70165_t + (double)(f3 * 2.5f * f2), this.field_70163_u + (adouble1[1] - adouble[1]) * 1.0 + (double)(f9 * 2.5f), this.field_70161_v - (double)(f13 * 2.5f * f2), 0.0f, 0.0f);
            for (int j = 0; j < 3; ++j) {
                MultiPartEntityPart entitydragonpart = null;
                if (j == 0) {
                    entitydragonpart = this.dragonPartTail1;
                }
                if (j == 1) {
                    entitydragonpart = this.dragonPartTail2;
                }
                if (j == 2) {
                    entitydragonpart = this.dragonPartTail3;
                }
                double[] adouble2 = this.getMovementOffsets(12 + j * 2, 1.0f);
                float f14 = this.field_70177_z * (float)Math.PI / 180.0f + this.simplifyAngle(adouble2[0] - adouble[0]) * (float)Math.PI / 180.0f * 1.0f;
                float f15 = MathHelper.func_76126_a((float)f14);
                float f16 = MathHelper.func_76134_b((float)f14);
                float f17 = 0.1f;
                float f18 = (float)(j + 1) * 1.5f;
                entitydragonpart.func_70071_h_();
                entitydragonpart.func_70012_b(this.field_70165_t - (double)((f11 * f17 + f15 * f18) * f2), this.field_70163_u + (adouble2[1] - adouble[1]) * 1.0 - (double)((f18 + f17) * f9) + 1.0, this.field_70161_v + (double)((f12 * f17 + f16 * f18) * f2), 0.0f, 0.0f);
            }
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        this.func_174826_a(this.func_174813_aQ().func_72317_d(x, y, z));
        this.func_174829_m();
        try {
            this.func_145775_I();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
            this.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    protected void func_145775_I() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72340_a + 0.001), (double)(axisalignedbb.field_72338_b + 0.001), (double)(axisalignedbb.field_72339_c + 0.001));
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos1 = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72336_d - 0.001), (double)(axisalignedbb.field_72337_e - 0.001), (double)(axisalignedbb.field_72334_f - 0.001));
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos2 = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (this.field_70170_p.func_175707_a((BlockPos)blockpos$pooledmutableblockpos, (BlockPos)blockpos$pooledmutableblockpos1)) {
            for (int i = blockpos$pooledmutableblockpos.func_177958_n(); i <= blockpos$pooledmutableblockpos1.func_177958_n(); ++i) {
                for (int j = blockpos$pooledmutableblockpos.func_177956_o(); j <= blockpos$pooledmutableblockpos1.func_177956_o(); ++j) {
                    for (int k = blockpos$pooledmutableblockpos.func_177952_p(); k <= blockpos$pooledmutableblockpos1.func_177952_p(); ++k) {
                        blockpos$pooledmutableblockpos2.func_181079_c(i, j, k);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos2);
                        if (iblockstate.func_185904_a() != Material.field_151567_E) continue;
                        this.func_70024_g(this.field_70159_w > 0.0 ? -3.0 : 3.0, this.field_70181_x > 0.0 ? -3.0 : 3.0, this.field_70179_y > 0.0 ? -3.0 : 3.0);
                    }
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        blockpos$pooledmutableblockpos1.func_185344_t();
        blockpos$pooledmutableblockpos2.func_185344_t();
    }

    private void updateHealingCircle() {
        if (this.healingcircle != null) {
            if (this.healingcircle.field_70128_L) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70965_a(this.dragonPartHead, DamageSource.func_94539_a((Explosion)null), 100.0f);
                }
                this.healingcircle = null;
            } else if (this.field_70173_aa % 10 == 0 && this.healingcircle.func_110143_aJ() < this.healingcircle.func_110138_aP()) {
                this.func_70606_j(this.func_110143_aJ() - 1.0f);
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            float f = 32.0f;
            List list = this.field_70170_p.func_72872_a(EntityDragonBoss.class, this.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f));
            EntityDragonBoss entitydragonboss = null;
            double d0 = Double.MAX_VALUE;
            for (EntityDragonBoss entitydragonboss1 : list) {
                double d1 = entitydragonboss1.func_70068_e((Entity)this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entitydragonboss = entitydragonboss1;
            }
            this.healingcircle = entitydragonboss;
        }
    }

    private void collideWithEntities(List<?> par1List) {
        if (!ACConfig.hardcoreMode) {
            return;
        }
        double d0 = (this.dragonPartBody.func_174813_aQ().field_72340_a + this.dragonPartBody.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (this.dragonPartBody.func_174813_aQ().field_72339_c + this.dragonPartBody.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : par1List) {
            if (!(entity instanceof EntityLivingBase)) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 4.0, (double)0.2f, d3 / d4 * 4.0);
        }
    }

    private void attackEntitiesInList(List<?> par1List) {
        for (int i = 0; i < par1List.size(); ++i) {
            Entity entity = (Entity)par1List.get(i);
            if (entity instanceof EntityLivingBase && !EntityUtil.isEntityCoralium((EntityLivingBase)entity)) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(AbyssalCraftAPI.coralium_plague, 200));
            }
            if (!ACConfig.hardcoreMode || !(entity instanceof EntityPlayer)) continue;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h().func_151518_m(), 1.0f);
        }
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        if (this.field_70146_Z.nextInt(2) == 0 && !this.field_70170_p.field_73010_i.isEmpty()) {
            this.target = (Entity)this.field_70170_p.field_73010_i.get(this.field_70146_Z.nextInt(this.field_70170_p.field_73010_i.size()));
        } else {
            double d2;
            double d1;
            double d0;
            boolean flag = false;
            do {
                this.targetX = 0.0;
                this.targetY = 70.0f + this.field_70146_Z.nextFloat() * 50.0f;
                this.targetZ = 0.0;
                this.targetX += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                this.targetZ += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
            } while (!(flag = (d0 = this.field_70165_t - this.targetX) * d0 + (d1 = this.field_70163_u - this.targetY) * d1 + (d2 = this.field_70161_v - this.targetZ) * d2 > 100.0));
            this.target = null;
        }
    }

    private float simplifyAngle(double par1) {
        return (float)MathHelper.func_76138_g((double)par1);
    }

    public boolean func_70965_a(MultiPartEntityPart par1EntityDragonPart, DamageSource par2DamageSource, float par3) {
        if (par1EntityDragonPart != this.dragonPartHead) {
            par3 = par3 / 2.0f + 1.0f;
        }
        float f1 = this.field_70177_z * (float)Math.PI / 180.0f;
        float f2 = MathHelper.func_76126_a((float)f1);
        float f3 = MathHelper.func_76134_b((float)f1);
        this.targetX = this.field_70165_t + (double)(f2 * 5.0f) + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 2.0f);
        this.targetY = this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.0f) + 1.0;
        this.targetZ = this.field_70161_v - (double)(f3 * 5.0f) + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 2.0f);
        this.target = null;
        if (par2DamageSource.func_76346_g() instanceof EntityPlayer || par2DamageSource.func_94541_c()) {
            super.func_70097_a(par2DamageSource, par3);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.dragonPartArray;
    }

    public boolean func_70067_L() {
        return false;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187521_aK;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187526_aP;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }
}

