/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.recipe.TransmutatorRecipes;
import com.shinoow.abyssalcraft.common.blocks.BlockTransmutator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityTransmutator
extends TileEntity
implements ISidedInventory,
ITickable {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    private NonNullList<ItemStack> transmutatorItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public int transmutatorBurnTime;
    public int currentItemBurnTime;
    public int transmutatorProcessTime;
    private String containerName;
    private ItemStack processingStack = ItemStack.field_190927_a;
    private boolean recheck;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.transmutatorItemStacks.size();
    }

    public ItemStack func_70301_a(int par1) {
        return (ItemStack)this.transmutatorItemStacks.get(par1);
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (par1 == 2) {
            this.recheck = true;
        }
        if (par1 == 0) {
            ItemStack stack = ItemStackHelper.func_188382_a(this.transmutatorItemStacks, (int)par1, (int)par2);
            if (((ItemStack)this.transmutatorItemStacks.get(0)).func_190926_b()) {
                this.processingStack = ItemStack.field_190927_a;
                this.recheck = true;
            }
            return stack;
        }
        return ItemStackHelper.func_188382_a(this.transmutatorItemStacks, (int)par1, (int)par2);
    }

    public ItemStack func_70304_b(int par1) {
        return ItemStackHelper.func_188383_a(this.transmutatorItemStacks, (int)par1);
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.transmutatorItemStacks.set(par1, (Object)par2ItemStack);
        if (par1 == 0) {
            if (this.processingStack.func_190926_b() && !par2ItemStack.func_190926_b()) {
                this.processingStack = TransmutatorRecipes.instance().getTransmutationResult(par2ItemStack);
                this.recheck = true;
            } else if (!this.processingStack.func_190926_b()) {
                ItemStack stack = TransmutatorRecipes.instance().getTransmutationResult(par2ItemStack);
                if (!stack.func_77969_a(this.processingStack)) {
                    this.processingStack = ((ItemStack)this.transmutatorItemStacks.get(2)).func_190926_b() ? stack : ItemStack.field_190927_a;
                    this.recheck = true;
                } else {
                    this.processingStack = stack;
                }
            }
        }
        if (par1 == 2) {
            this.recheck = true;
        }
        if (!par2ItemStack.func_190926_b() && par2ItemStack.func_190916_E() > par2ItemStack.func_77976_d()) {
            par2ItemStack.func_190920_e(par2ItemStack.func_77976_d());
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.containerName : "container.abyssalcraft.transmutator";
    }

    public boolean func_145818_k_() {
        return this.containerName != null && this.containerName.length() > 0;
    }

    public void func_145951_a(String par1) {
        this.containerName = par1;
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.transmutatorItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)par1, this.transmutatorItemStacks);
        this.transmutatorBurnTime = par1.func_74765_d("BurnTime");
        this.transmutatorProcessTime = par1.func_74765_d("ProcessTime");
        this.currentItemBurnTime = TileEntityTransmutator.getItemBurnTime((ItemStack)this.transmutatorItemStacks.get(1));
        NBTTagCompound nbtItem = par1.func_74775_l("ProcessingStack");
        this.processingStack = new ItemStack(nbtItem);
        this.recheck = true;
        if (par1.func_150297_b("CustomName", 8)) {
            this.containerName = par1.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1) {
        super.func_189515_b(par1);
        par1.func_74777_a("BurnTime", (short)this.transmutatorBurnTime);
        par1.func_74777_a("ProcessTime", (short)this.transmutatorProcessTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)par1, this.transmutatorItemStacks);
        NBTTagCompound nbtItem = new NBTTagCompound();
        if (!this.processingStack.func_190926_b()) {
            this.processingStack.func_77955_b(nbtItem);
        }
        par1.func_74782_a("ProcessingStack", (NBTBase)nbtItem);
        if (this.func_145818_k_()) {
            par1.func_74778_a("CustomName", this.containerName);
        }
        return par1;
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getProcessProgressScaled(int par1) {
        return this.transmutatorProcessTime * par1 / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.transmutatorBurnTime * par1 / this.currentItemBurnTime;
    }

    public boolean isTransmuting() {
        return this.transmutatorBurnTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.transmutatorBurnTime > 0;
        boolean flag1 = false;
        if (this.transmutatorBurnTime > 0) {
            --this.transmutatorBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.transmutatorBurnTime == 0 && this.canProcess()) {
                ItemStack stack = (ItemStack)this.transmutatorItemStacks.get(1);
                this.currentItemBurnTime = this.transmutatorBurnTime = TileEntityTransmutator.getItemBurnTime(stack);
                if (this.transmutatorBurnTime > 0) {
                    flag1 = true;
                    if (!stack.func_190926_b()) {
                        Item item = stack.func_77973_b();
                        stack.func_190918_g(1);
                        if (stack.func_190926_b()) {
                            this.transmutatorItemStacks.set(1, (Object)item.getContainerItem(stack));
                        }
                    }
                }
            }
            if (this.isTransmuting() && this.canProcess()) {
                ++this.transmutatorProcessTime;
                if (this.transmutatorProcessTime == 200) {
                    this.transmutatorProcessTime = 0;
                    this.processItem();
                    flag1 = true;
                }
            } else {
                this.transmutatorProcessTime = 0;
            }
            if (flag != this.transmutatorBurnTime > 0) {
                flag1 = true;
                BlockTransmutator.updateTransmutatorBlockState(this.transmutatorBurnTime > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canProcess() {
        if (this.processingStack.func_190926_b()) {
            return false;
        }
        if (this.recheck) {
            ItemStack stack = (ItemStack)this.transmutatorItemStacks.get(2);
            if (stack.func_190926_b()) {
                this.recheck = false;
                return true;
            }
            if (!stack.func_77969_a(this.processingStack)) {
                return false;
            }
            int result = stack.func_190916_E() + this.processingStack.func_190916_E();
            if (result <= this.func_70297_j_() && result <= stack.func_77976_d()) {
                this.recheck = false;
                return true;
            }
            return false;
        }
        return true;
    }

    public void processItem() {
        if (this.canProcess()) {
            this.recheck = true;
            ItemStack itemstack = this.processingStack;
            ItemStack stack = (ItemStack)this.transmutatorItemStacks.get(2);
            ItemStack stack1 = (ItemStack)this.transmutatorItemStacks.get(0);
            if (stack.func_190926_b()) {
                this.transmutatorItemStacks.set(2, (Object)itemstack.func_77946_l());
            } else if (stack.func_77973_b() == itemstack.func_77973_b()) {
                stack.func_190917_f(itemstack.func_190916_E());
            }
            stack1.func_190918_g(1);
            if (stack1.func_190916_E() <= 0) {
                this.transmutatorItemStacks.set(0, (Object)ItemStack.field_190927_a);
                this.processingStack = ItemStack.field_190927_a;
            }
        }
    }

    public static int getItemBurnTime(ItemStack par1ItemStack) {
        if (par1ItemStack.func_190926_b()) {
            return 0;
        }
        Item item = par1ItemStack.func_77973_b();
        if (item == ACItems.coralium_plagued_flesh) {
            return 100;
        }
        if (item == ACItems.coralium_plagued_flesh_on_a_bone) {
            return 100;
        }
        if (item == ACItems.coralium_brick) {
            return 200;
        }
        if (item == ACItems.coralium_gem) {
            return 200;
        }
        if (item == ACItems.coralium_gem_cluster_2) {
            return 400;
        }
        if (item == ACItems.coralium_gem_cluster_3) {
            return 600;
        }
        if (item == ACItems.coralium_gem_cluster_4) {
            return 800;
        }
        if (item == ACItems.coralium_gem_cluster_5) {
            return 1000;
        }
        if (item == ACItems.coralium_gem_cluster_6) {
            return 1200;
        }
        if (item == ACItems.coralium_gem_cluster_7) {
            return 1400;
        }
        if (item == ACItems.coralium_gem_cluster_8) {
            return 1600;
        }
        if (item == ACItems.coralium_gem_cluster_9) {
            return 1800;
        }
        if (item == ACItems.coralium_pearl) {
            return 2000;
        }
        if (item == ACItems.transmutation_gem) {
            return 10000;
        }
        if (item == ACItems.chunk_of_coralium) {
            return 16200;
        }
        if (ItemStack.func_77989_b((ItemStack)par1ItemStack, (ItemStack)ACItems.liquid_coralium_bucket_stack) && APIUtils.areItemStackTagsEqual(par1ItemStack, ACItems.liquid_coralium_bucket_stack, 0)) {
            return 20000;
        }
        if (item == Items.field_151065_br) {
            return 1200;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        if (item == ACItems.methane) {
            return 10000;
        }
        return AbyssalCraftAPI.getFuelValue(par1ItemStack, AbyssalCraftAPI.FuelType.TRANSMUTATOR);
    }

    public static boolean isItemFuel(ItemStack par1ItemStack) {
        return TileEntityTransmutator.getItemBurnTime(par1ItemStack) > 0;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 2 ? false : (par1 == 1 ? TileEntityTransmutator.isItemFuel(par2ItemStack) : true);
    }

    public int[] func_180463_a(EnumFacing face) {
        return face == EnumFacing.DOWN ? slotsBottom : (face == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int par1, ItemStack par2ItemStack, EnumFacing face) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_180461_b(int par1, ItemStack par2ItemStack, EnumFacing face) {
        Item item;
        return face != EnumFacing.DOWN || par1 != 1 || (item = par2ItemStack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.transmutatorItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

