/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.recipe.CrystallizerRecipes;
import com.shinoow.abyssalcraft.common.blocks.BlockCrystallizer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityCrystallizer
extends TileEntity
implements ISidedInventory,
ITickable {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1, 3};
    private static final int[] slotsSides = new int[]{1};
    private NonNullList<ItemStack> crystallizerItemStacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public int crystallizerShapeTime;
    public int currentItemShapingTime;
    public int crystallizerFormTime;
    private String containerName;
    private ItemStack[] processingStacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};
    private boolean recheck;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.crystallizerItemStacks.size();
    }

    public ItemStack func_70301_a(int par1) {
        return (ItemStack)this.crystallizerItemStacks.get(par1);
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (par1 == 2 || par1 == 3) {
            this.recheck = true;
        }
        if (par1 == 0) {
            ItemStack stack = ItemStackHelper.func_188382_a(this.crystallizerItemStacks, (int)par1, (int)par2);
            if (((ItemStack)this.crystallizerItemStacks.get(0)).func_190926_b()) {
                this.processingStacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};
                this.recheck = true;
            }
            return stack;
        }
        return ItemStackHelper.func_188382_a(this.crystallizerItemStacks, (int)par1, (int)par2);
    }

    public ItemStack func_70304_b(int par1) {
        return ItemStackHelper.func_188383_a(this.crystallizerItemStacks, (int)par1);
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.crystallizerItemStacks.set(par1, (Object)par2ItemStack);
        if (par1 == 0) {
            if (this.processingStacks[0].func_190926_b() && !par2ItemStack.func_190926_b()) {
                this.processingStacks = CrystallizerRecipes.instance().getCrystallizationResult(par2ItemStack);
                this.recheck = true;
            } else if (!this.processingStacks[0].func_190926_b()) {
                ItemStack[] stacks = CrystallizerRecipes.instance().getCrystallizationResult(par2ItemStack);
                if (!(stacks[0].func_77969_a(this.processingStacks[0]) && (this.processingStacks[1].func_190926_b() && stacks[1].func_190926_b() || stacks[1].func_77969_a(this.processingStacks[1])))) {
                    ItemStack stack = (ItemStack)this.crystallizerItemStacks.get(2);
                    ItemStack stack1 = (ItemStack)this.crystallizerItemStacks.get(3);
                    this.processingStacks = stack.func_190926_b() || stacks[0].func_77969_a(stack) ? (stack1.func_190926_b() || stacks[1].func_190926_b() || stacks[1].func_77969_a(stack1) ? stacks : new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a}) : new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};
                    this.recheck = true;
                } else {
                    this.processingStacks = stacks;
                }
            }
        }
        if (par1 == 2 || par1 == 3) {
            this.recheck = true;
        }
        if (!par2ItemStack.func_190926_b() && par2ItemStack.func_190916_E() > this.func_70297_j_()) {
            par2ItemStack.func_190920_e(this.func_70297_j_());
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.containerName : "container.abyssalcraft.crystallizer";
    }

    public boolean func_145818_k_() {
        return this.containerName != null && this.containerName.length() > 0;
    }

    public void func_145951_a(String par1) {
        this.containerName = par1;
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.crystallizerItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)par1, this.crystallizerItemStacks);
        this.crystallizerShapeTime = par1.func_74765_d("ShapeTime");
        this.crystallizerFormTime = par1.func_74765_d("FormTime");
        this.currentItemShapingTime = TileEntityCrystallizer.getCrystallizationTime((ItemStack)this.crystallizerItemStacks.get(1));
        NBTTagCompound nbtItem = par1.func_74775_l("ProcessingStack");
        NBTTagCompound nbtItem1 = par1.func_74775_l("ProcessingStack1");
        this.processingStacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};
        this.processingStacks[0] = new ItemStack(nbtItem);
        this.processingStacks[1] = new ItemStack(nbtItem1);
        this.recheck = true;
        if (par1.func_150297_b("CustomName", 8)) {
            this.containerName = par1.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1) {
        super.func_189515_b(par1);
        par1.func_74777_a("ShapeTime", (short)this.crystallizerShapeTime);
        par1.func_74777_a("FormTime", (short)this.crystallizerFormTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)par1, this.crystallizerItemStacks);
        NBTTagCompound nbtItem = new NBTTagCompound();
        if (!this.processingStacks[0].func_190926_b()) {
            this.processingStacks[0].func_77955_b(nbtItem);
        }
        par1.func_74782_a("ProcessingStack", (NBTBase)nbtItem);
        NBTTagCompound nbtItem1 = new NBTTagCompound();
        if (!this.processingStacks[1].func_190926_b()) {
            this.processingStacks[1].func_77955_b(nbtItem1);
        }
        par1.func_74782_a("ProcessingStack1", (NBTBase)nbtItem1);
        if (this.func_145818_k_()) {
            par1.func_74778_a("CustomName", this.containerName);
        }
        return par1;
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFormProgressScaled(int par1) {
        return this.crystallizerFormTime * par1 / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getShapeTimeRemainingScaled(int par1) {
        if (this.currentItemShapingTime == 0) {
            this.currentItemShapingTime = 200;
        }
        return this.crystallizerShapeTime * par1 / this.currentItemShapingTime;
    }

    public boolean isCrystallizing() {
        return this.crystallizerShapeTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.crystallizerShapeTime > 0;
        boolean flag1 = false;
        if (this.crystallizerShapeTime > 0) {
            --this.crystallizerShapeTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.crystallizerShapeTime == 0 && this.canCrystallize()) {
                ItemStack stack = (ItemStack)this.crystallizerItemStacks.get(1);
                this.currentItemShapingTime = this.crystallizerShapeTime = TileEntityCrystallizer.getCrystallizationTime(stack);
                if (this.crystallizerShapeTime > 0) {
                    flag1 = true;
                    if (!stack.func_190926_b()) {
                        Item item = stack.func_77973_b();
                        stack.func_190918_g(1);
                        if (stack.func_190926_b()) {
                            this.crystallizerItemStacks.set(1, (Object)item.getContainerItem(stack));
                        }
                    }
                }
            }
            if (this.isCrystallizing() && this.canCrystallize()) {
                ++this.crystallizerFormTime;
                if (this.crystallizerFormTime == 200) {
                    this.crystallizerFormTime = 0;
                    this.crystalizeItem();
                    flag1 = true;
                }
            } else {
                this.crystallizerFormTime = 0;
            }
            if (flag != this.crystallizerShapeTime > 0) {
                flag1 = true;
                BlockCrystallizer.updateCrystallizerBlockState(this.crystallizerShapeTime > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canCrystallize() {
        if (this.processingStacks[0].func_190926_b()) {
            return false;
        }
        if (this.recheck) {
            ItemStack stack = (ItemStack)this.crystallizerItemStacks.get(2);
            ItemStack stack1 = (ItemStack)this.crystallizerItemStacks.get(3);
            if (this.processingStacks[0].func_190926_b() && this.processingStacks[1].func_190926_b() || this.processingStacks[0].func_190926_b()) {
                return false;
            }
            if (stack.func_190926_b() && stack1.func_190926_b()) {
                return true;
            }
            if (this.processingStacks[1].func_190926_b()) {
                if (stack.func_190926_b()) {
                    this.recheck = false;
                    return true;
                }
                if (!stack.func_77969_a(this.processingStacks[0])) {
                    return false;
                }
                int result = stack.func_190916_E() + this.processingStacks[0].func_190916_E();
                if (result <= this.func_70297_j_() && result <= stack.func_77976_d()) {
                    this.recheck = false;
                    return true;
                }
                return false;
            }
            if (stack.func_190926_b() && stack1.func_190926_b()) {
                this.recheck = false;
                return true;
            }
            if (!stack.func_190926_b() && !stack.func_77969_a(this.processingStacks[0])) {
                return false;
            }
            if (!stack1.func_190926_b() && !stack1.func_77969_a(this.processingStacks[1])) {
                return false;
            }
            int result = stack.func_190916_E() + this.processingStacks[0].func_190916_E();
            int result2 = stack1.func_190916_E() + this.processingStacks[1].func_190916_E();
            if (result > stack.func_77976_d() || result2 > stack1.func_77976_d()) {
                return false;
            }
            if (result <= this.func_70297_j_() && result2 <= this.func_70297_j_() && result <= stack.func_77976_d() && result2 <= stack1.func_77976_d()) {
                this.recheck = false;
                return true;
            }
        }
        return true;
    }

    public void crystalizeItem() {
        if (this.canCrystallize()) {
            this.recheck = true;
            ItemStack[] itemstack = this.processingStacks;
            ItemStack stack = (ItemStack)this.crystallizerItemStacks.get(2);
            ItemStack stack1 = (ItemStack)this.crystallizerItemStacks.get(3);
            ItemStack stack2 = (ItemStack)this.crystallizerItemStacks.get(0);
            if (stack.func_190926_b()) {
                this.crystallizerItemStacks.set(2, (Object)itemstack[0].func_77946_l());
            } else if (stack.func_77973_b() == itemstack[0].func_77973_b()) {
                stack.func_190917_f(itemstack[0].func_190916_E());
            }
            if (!itemstack[1].func_190926_b()) {
                if (stack1.func_190926_b()) {
                    this.crystallizerItemStacks.set(3, (Object)itemstack[1].func_77946_l());
                } else if (stack1.func_77973_b() == itemstack[1].func_77973_b()) {
                    stack1.func_190917_f(itemstack[1].func_190916_E());
                }
            }
            Item item = stack2.func_77973_b();
            stack2.func_190918_g(1);
            if (stack2.func_190916_E() <= 0) {
                this.crystallizerItemStacks.set(0, (Object)item.getContainerItem(stack2));
                if (item == Items.field_151068_bn) {
                    this.crystallizerItemStacks.set(0, (Object)new ItemStack(Items.field_151069_bo));
                }
                this.processingStacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};
            }
        }
    }

    public static int getCrystallizationTime(ItemStack par1ItemStack) {
        if (par1ItemStack.func_190926_b()) {
            return 0;
        }
        Item item = par1ItemStack.func_77973_b();
        if (item == ACItems.dread_fragment) {
            return 100;
        }
        if (item == ACItems.dreaded_shard_of_abyssalnite) {
            return 1000;
        }
        if (item == ACItems.dreaded_chunk_of_abyssalnite) {
            return 1600;
        }
        if (item == Items.field_151065_br) {
            return 1200;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        if (item == ACItems.methane) {
            return 10000;
        }
        return AbyssalCraftAPI.getFuelValue(par1ItemStack, AbyssalCraftAPI.FuelType.CRYSTALLIZER);
    }

    public static boolean isItemFuel(ItemStack par1ItemStack) {
        return TileEntityCrystallizer.getCrystallizationTime(par1ItemStack) > 0;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 2 ? false : (par1 == 1 ? TileEntityCrystallizer.isItemFuel(par2ItemStack) : true);
    }

    public int[] func_180463_a(EnumFacing face) {
        return face == EnumFacing.DOWN ? slotsBottom : (face == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int par1, ItemStack par2ItemStack, EnumFacing face) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_180461_b(int par1, ItemStack par2ItemStack, EnumFacing face) {
        Item item;
        return face != EnumFacing.DOWN || par1 != 1 || (item = par2ItemStack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.crystallizerItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

