/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks;

import com.google.common.collect.Maps;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityRitualAltar;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.util.blocks.SingletonInventoryUtil;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRitualAltar
extends BlockContainer {
    private static HashMap<Integer, IBlockState> blockMeta = Maps.newHashMap();
    public static final PropertyEnum MATERIAL = PropertyEnum.func_177709_a((String)"material", EnumRitualMatType.class);

    public BlockRitualAltar() {
        super(Material.field_151576_e);
        this.func_149711_c(6.0f);
        this.func_149752_b(12.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(null);
        this.func_149715_a(0.375f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MATERIAL, (Comparable)((Object)EnumRitualMatType.COBBLESTONE)));
        this.setHarvestLevel("pickaxe", 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.15f, 0.0, (double)0.15f, (double)0.85f, 1.0, (double)0.85f);
    }

    public void func_149666_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        par3List.add((Object)new ItemStack((Block)this, 1, 0));
        par3List.add((Object)new ItemStack((Block)this, 1, 1));
        par3List.add((Object)new ItemStack((Block)this, 1, 2));
        par3List.add((Object)new ItemStack((Block)this, 1, 3));
        par3List.add((Object)new ItemStack((Block)this, 1, 4));
        par3List.add((Object)new ItemStack((Block)this, 1, 5));
        par3List.add((Object)new ItemStack((Block)this, 1, 6));
        par3List.add((Object)new ItemStack((Block)this, 1, 7));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityRitualAltar();
    }

    public Item func_180660_a(IBlockState state, Random random, int j) {
        return Item.func_150898_a((Block)blockMeta.get(((EnumRitualMatType)((Object)state.func_177229_b((IProperty)MATERIAL))).getMeta()).func_177230_c());
    }

    public int func_180651_a(IBlockState state) {
        IBlockState s = blockMeta.get(((EnumRitualMatType)((Object)state.func_177229_b((IProperty)MATERIAL))).getMeta());
        return s.func_177230_c().func_176201_c(s);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180655_c(IBlockState state, World par1World, BlockPos pos, Random par5Random) {
        super.func_180655_c(state, par1World, pos, par5Random);
        if (ACConfig.particleBlock) {
            par1World.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + 0.75, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.75, 0.0, 0.0, 0.0, new int[0]);
            par1World.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + 0.25, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.75, 0.0, 0.0, 0.0, new int[0]);
            par1World.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + 0.25, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.25, 0.0, 0.0, 0.0, new int[0]);
            par1World.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + 0.75, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.25, 0.0, 0.0, 0.0, new int[0]);
            par1World.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.75, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.75, 0.0, 0.0, 0.0, new int[0]);
            par1World.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.25, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.75, 0.0, 0.0, 0.0, new int[0]);
            par1World.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.25, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.25, 0.0, 0.0, 0.0, new int[0]);
            par1World.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.75, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.25, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return SingletonInventoryUtil.handleBlockActivation(world, pos, player, player.func_184586_b(hand));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Random rand = new Random();
        TileEntityRitualAltar altar = (TileEntityRitualAltar)world.func_175625_s(pos);
        if (altar != null && !altar.getItem().func_190926_b()) {
            float f = rand.nextFloat() * 0.8f + 0.1f;
            float f1 = rand.nextFloat() * 0.8f + 0.1f;
            float f2 = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), altar.getItem());
            float f3 = 0.05f;
            item.field_70159_w = (float)rand.nextGaussian() * f3;
            item.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
            item.field_70179_y = (float)rand.nextGaussian() * f3;
            world.func_72838_d((Entity)item);
        }
        super.func_180663_b(world, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MATERIAL, (Comparable)((Object)EnumRitualMatType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumRitualMatType)((Object)state.func_177229_b((IProperty)MATERIAL))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{MATERIAL}).build();
    }

    public void setBlocks() {
        blockMeta.put(0, Blocks.field_150347_e.func_176223_P());
        blockMeta.put(1, ACBlocks.cobblestone.func_176203_a(0));
        blockMeta.put(2, ACBlocks.cobblestone.func_176203_a(1));
        blockMeta.put(3, ACBlocks.cobblestone.func_176203_a(4));
        blockMeta.put(4, ACBlocks.cobblestone.func_176203_a(2));
        blockMeta.put(5, ACBlocks.cobblestone.func_176203_a(3));
        blockMeta.put(6, ACBlocks.ethaxium_brick.func_176223_P());
        blockMeta.put(7, ACBlocks.dark_ethaxium_brick.func_176223_P());
    }

    public static enum EnumRitualMatType implements IStringSerializable
    {
        COBBLESTONE(0, "cobblestone"),
        DARKSTONE_COBBLESTONE(1, "darkstone_cobblestone"),
        ABYSSAL_STONE_BRICK(2, "abyssal_stone_brick"),
        CORALIUM_STONE_BRICK(3, "coralium_stone_brick"),
        DREADSTONE_BRICK(4, "dreadstone_brick"),
        ABYSSALNITE_STONE_BRICK(5, "abyssalnite_stone_brick"),
        ETHAXIUM_BRICK(6, "ethaxium_brick"),
        DARK_ETHAXIUM_BRICK(7, "dark_ethaxium_brick");

        private static final EnumRitualMatType[] META_LOOKUP;
        private int meta;
        private String name;

        private EnumRitualMatType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumRitualMatType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String toString() {
            return this.func_176610_l();
        }

        static {
            META_LOOKUP = new EnumRitualMatType[EnumRitualMatType.values().length];
            EnumRitualMatType[] enumRitualMatTypeArray = EnumRitualMatType.values();
            int n = enumRitualMatTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumRitualMatType type;
                EnumRitualMatType.META_LOOKUP[type.getMeta()] = type = enumRitualMatTypeArray[i];
            }
        }
    }
}

