/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.client.gui.necronomicon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.necronomicon.GuiInstance;
import com.shinoow.abyssalcraft.api.necronomicon.NecroData;
import com.shinoow.abyssalcraft.api.necronomicon.condition.IUnlockCondition;
import com.shinoow.abyssalcraft.api.necronomicon.condition.NecronomiconCondition;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.INecroDataCapability;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.NecroDataCapability;
import com.shinoow.abyssalcraft.client.gui.necronomicon.GuiNecronomiconEntry;
import com.shinoow.abyssalcraft.client.gui.necronomicon.GuiNecronomiconMachines;
import com.shinoow.abyssalcraft.client.gui.necronomicon.GuiNecronomiconOther;
import com.shinoow.abyssalcraft.client.gui.necronomicon.GuiNecronomiconRitualEntry;
import com.shinoow.abyssalcraft.client.gui.necronomicon.GuiNecronomiconSpells;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonCategory;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonNextPage;
import com.shinoow.abyssalcraft.client.lib.GuiRenderHelper;
import com.shinoow.abyssalcraft.lib.NecronomiconResources;
import com.shinoow.abyssalcraft.lib.NecronomiconText;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiNecronomicon
extends GuiScreen {
    private static ResourceLocation bookGuiTextures = new ResourceLocation("abyssalcraft:textures/gui/necronomicon.png");
    protected static final ResourceLocation MISSING_PICTURE = new ResourceLocation("abyssalcraft", "textures/gui/necronomicon/missing.png");
    protected static final ResourceLocation MISSING_ITEM = new ResourceLocation("abyssalcraft", "textures/gui/necronomicon/missing_item.png");
    protected static final ResourceLocation MISSING_RECIPE = new ResourceLocation("abyssalcraft", "textures/gui/necronomicon/missing_recipe.png");
    public static GuiNecronomicon currentNecro = new GuiNecronomicon();
    public final int guiWidth = 255;
    public final int guiHeight = 192;
    private int bookTotalTurnups = 2;
    protected int currTurnup;
    private ButtonNextPage buttonNextPage;
    private ButtonNextPage buttonPreviousPage;
    private ButtonCategory buttonCat1;
    private ButtonCategory buttonCat2;
    private ButtonCategory buttonCat3;
    private ButtonCategory buttonCat4;
    private ButtonCategory buttonCat5;
    private ButtonCategory buttonCat6;
    private ButtonCategory buttonCat7;
    private GuiButton buttonDone;
    private int bookType;
    private static final int cycleTime = 1000;
    private long startTime;
    private long drawTime;
    protected boolean isInfo;
    private boolean isNecroInfo;
    private boolean isKnowledgeInfo;
    protected boolean isInvalid;
    public static final Map<String, DynamicTexture> successcache = Maps.newHashMap();
    public static final List<String> failcache = Lists.newArrayList();
    private static NecroData.Chapter patreon;
    private INecroDataCapability cap;
    protected ItemStack tooltipStack;

    public GuiNecronomicon() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            this.cap = NecroDataCapability.getCap((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
        long time = System.currentTimeMillis();
        this.startTime = time - 1000L;
        this.drawTime = time;
    }

    public GuiNecronomicon(int par1) {
        this();
        this.withBookType(par1);
    }

    public GuiNecronomicon withBookType(int par1) {
        if (this.bookType == par1) {
            return this;
        }
        this.bookType = par1;
        switch (par1) {
            case 0: {
                bookGuiTextures = new ResourceLocation("abyssalcraft:textures/gui/necronomicon.png");
                break;
            }
            case 1: {
                bookGuiTextures = new ResourceLocation("abyssalcraft:textures/gui/necronomicon_cor.png");
                break;
            }
            case 2: {
                bookGuiTextures = new ResourceLocation("abyssalcraft:textures/gui/necronomicon_dre.png");
                break;
            }
            case 3: {
                bookGuiTextures = new ResourceLocation("abyssalcraft:textures/gui/necronomicon_omt.png");
                break;
            }
            case 4: {
                bookGuiTextures = new ResourceLocation("abyssalcraft:textures/gui/abyssalnomicon.png");
            }
        }
        return this;
    }

    public void func_73876_c() {
        this.drawTime = System.currentTimeMillis();
        super.func_73876_c();
    }

    public void func_73866_w_() {
        currentNecro = this;
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        int i = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        this.buttonNextPage = new ButtonNextPage(1, i + 215, b0 + 154, true, false);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new ButtonNextPage(2, i + 18, b0 + 154, false, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonCat1 = new ButtonCategory(3, i + 14, b0 + 24, this, NecronomiconText.LABEL_INFORMATION, false, ACItems.necronomicon);
        this.field_146292_n.add(this.buttonCat1);
        this.buttonCat2 = new ButtonCategory(4, i + 14, b0 + 41, this, NecronomiconText.LABEL_SPELLBOOK, false, ACItems.necronomicon);
        this.field_146292_n.add(this.buttonCat2);
        this.buttonCat3 = new ButtonCategory(5, i + 14, b0 + 58, this, NecronomiconText.LABEL_RITUALS, false, ACItems.necronomicon);
        this.field_146292_n.add(this.buttonCat3);
        if (this.bookType == 4) {
            this.buttonCat4 = new ButtonCategory(6, i + 14, b0 + 75, this, NecronomiconText.LABEL_HUH, false, ACItems.abyssalnomicon);
            this.field_146292_n.add(this.buttonCat4);
        } else {
            this.buttonCat4 = new ButtonCategory(6, i + 14, b0 + 75, this, NecronomiconText.LABEL_HUH, false, ACItems.necronomicon);
            this.field_146292_n.add(this.buttonCat4);
        }
        this.buttonCat5 = new ButtonCategory(7, i + 14, b0 + 92, this, NecronomiconText.LABEL_KNOWLEDGE, false, ACItems.necronomicon);
        this.field_146292_n.add(this.buttonCat5);
        this.buttonCat6 = new ButtonCategory(8, i + 14, b0 + 109, this, NecronomiconText.LABEL_MISC_INFORMATION, false, ACItems.necronomicon);
        this.field_146292_n.add(this.buttonCat6);
        if (!AbyssalCraftAPI.getNecronomiconData().isEmpty()) {
            this.buttonCat7 = new ButtonCategory(9, i + 14, b0 + 126, this, NecronomiconText.LABEL_OTHER, false, ACItems.necronomicon);
            this.field_146292_n.add(this.buttonCat7);
        }
        this.updateButtons();
    }

    protected Item getItem(int par1) {
        switch (par1) {
            case 0: {
                return ACItems.necronomicon;
            }
            case 1: {
                return ACItems.abyssal_wasteland_necronomicon;
            }
            case 2: {
                return ACItems.dreadlands_necronomicon;
            }
            case 3: {
                return ACItems.omothol_necronomicon;
            }
            case 4: {
                return ACItems.abyssalnomicon;
            }
        }
        return ACItems.oblivion_catalyst;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return false;
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currTurnup < this.bookTotalTurnups - 1 && this.isInfo;
        this.buttonPreviousPage.field_146125_m = this.isInfo;
        this.buttonDone.field_146125_m = true;
        this.buttonCat1.field_146125_m = true;
        this.buttonCat2.field_146125_m = true;
        this.buttonCat3.field_146125_m = true;
        this.buttonCat4.field_146125_m = true;
        this.buttonCat5.field_146125_m = true;
        this.buttonCat6.field_146125_m = true;
        if (!AbyssalCraftAPI.getNecronomiconData().isEmpty()) {
            this.buttonCat7.field_146125_m = true;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.isInfo = false;
                this.isNecroInfo = false;
                this.isKnowledgeInfo = false;
                this.currTurnup = 0;
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 1) {
                if (this.currTurnup < this.bookTotalTurnups - 1) {
                    ++this.currTurnup;
                }
            } else if (button.field_146127_k == 2) {
                if (this.isInfo && this.currTurnup == 0) {
                    this.func_73866_w_();
                    this.isInfo = false;
                    this.isNecroInfo = false;
                    this.isKnowledgeInfo = false;
                } else if (this.currTurnup > 0) {
                    --this.currTurnup;
                }
            } else if (button.field_146127_k == 3) {
                NecroData data = new NecroData("information", NecronomiconText.LABEL_INFORMATION, 0, new NecroData.Chapter("acinfo", NecronomiconText.LABEL_INFORMATION_ABYSSALCRAFT, 0, new NecroData.Page(1, NecronomiconText.LABEL_INFORMATION_ABYSSALCRAFT, 0, NecronomiconResources.ABYSSALCRAFT_1, NecronomiconText.INFORMATION_ABYSSALCRAFT_PAGE_1), new NecroData.Page(2, NecronomiconText.LABEL_INFORMATION_ABYSSALCRAFT, 0, NecronomiconResources.BLANK, NecronomiconText.INFORMATION_ABYSSALCRAFT_PAGE_2), new NecroData.Page(3, NecronomiconText.LABEL_INFORMATION_ABYSSALCRAFT, 0, NecronomiconResources.ABYSSALCRAFT_2, NecronomiconText.INFORMATION_ABYSSALCRAFT_PAGE_3), new NecroData.Page(4, NecronomiconText.LABEL_INFORMATION_ABYSSALCRAFT, 0, NecronomiconResources.BLANK, NecronomiconText.INFORMATION_ABYSSALCRAFT_PAGE_4), new NecroData.Page(5, NecronomiconText.LABEL_INFORMATION_ABYSSALCRAFT, 0, NecronomiconResources.ABYSSALCRAFT_3, NecronomiconText.INFORMATION_ABYSSALCRAFT_PAGE_5), new NecroData.Page(6, NecronomiconText.LABEL_INFORMATION_ABYSSALCRAFT, 0, NecronomiconResources.BLANK, NecronomiconText.INFORMATION_ABYSSALCRAFT_PAGE_6)), AbyssalCraftAPI.getInternalNDHandler().getInternalNecroData("greatoldones"), new NecroData.Page(1, NecronomiconText.LABEL_INFORMATION_ABYSSALNOMICON, 4, NecronomiconText.INFORMATION_ABYSSALNOMICON), patreon, new GuiInstance(0, NecronomiconText.LABEL_INFORMATION_MACHINES, "machines"){

                    @Override
                    public IUnlockCondition getCondition() {
                        return new NecronomiconCondition(1);
                    }

                    @Override
                    public GuiScreen getOpenGui(int bookType, GuiScreen parent) {
                        return new GuiNecronomiconMachines(bookType, (GuiNecronomicon)parent);
                    }
                }, AbyssalCraftAPI.getInternalNDHandler().getInternalNecroData("overworld"), AbyssalCraftAPI.getInternalNDHandler().getInternalNecroData("abyssalwasteland"), AbyssalCraftAPI.getInternalNDHandler().getInternalNecroData("dreadlands"), AbyssalCraftAPI.getInternalNDHandler().getInternalNecroData("omothol"), AbyssalCraftAPI.getInternalNDHandler().getInternalNecroData("darkrealm"));
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNecronomiconEntry(this.bookType, data, this));
            } else if (button.field_146127_k == 4) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNecronomiconSpells(this.bookType, Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND)));
            } else if (button.field_146127_k == 5) {
                NecroData data = new NecroData("ritualinfo", NecronomiconText.LABEL_RITUALS, 0, NecronomiconText.RITUAL_INFO, AbyssalCraftAPI.getInternalNDHandler().getInternalNecroData("rituals"), new RitualGuiInstance(0, NecronomiconText.LABEL_NORMAL, "ritualsoverworld"), new RitualGuiInstance(1, NecronomiconText.LABEL_INFORMATION_ABYSSAL_WASTELAND, "ritualsabyssalwasteland"), new RitualGuiInstance(2, NecronomiconText.LABEL_INFORMATION_DREADLANDS, "ritualsdreadlands"), new RitualGuiInstance(3, NecronomiconText.LABEL_INFORMATION_OMOTHOL, "ritualsomothol"), new RitualGuiInstance(4, ACItems.abyssalnomicon.func_77658_a() + ".name", "ritualsabyssalnomicon"));
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNecronomiconEntry(this.bookType, data, this));
            } else if (button.field_146127_k == 6) {
                this.isInfo = true;
                this.isNecroInfo = true;
                this.bookTotalTurnups = this.bookType == 4 ? 1 : 2;
                this.drawButtons();
            } else if (button.field_146127_k == 7) {
                this.isInfo = true;
                this.isKnowledgeInfo = true;
                this.bookTotalTurnups = 2;
                this.drawButtons();
            } else if (button.field_146127_k == 8) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNecronomiconEntry(this.bookType, AbyssalCraftAPI.getInternalNDHandler().getInternalNecroData("miscinfo"), this, ACItems.necronomicon));
            } else if (button.field_146127_k == 9) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNecronomiconOther(this.bookType));
            }
            this.updateButtons();
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
    }

    private void drawButtons() {
        this.field_146292_n.clear();
        this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        int i = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        this.buttonNextPage = new ButtonNextPage(1, i + 215, b0 + 154, true, false);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new ButtonNextPage(2, i + 18, b0 + 154, false, false);
        this.field_146292_n.add(this.buttonPreviousPage);
    }

    public static void setPatreonInfo(NecroData.Chapter info) {
        if (Loader.instance().getLoaderState() == LoaderState.INITIALIZATION && Loader.instance().activeModContainer().getModId().equals("abyssalcraft")) {
            patreon = info;
        }
    }

    protected void drawInformationText(int x, int y) {
        if (this.isNecroInfo) {
            if (this.currTurnup == 0) {
                if (this.bookType < 4) {
                    this.writeText(1, NecronomiconText.NECRONOMICON_PAGE_1);
                    this.writeText(2, NecronomiconText.NECRONOMICON_PAGE_2);
                } else {
                    this.writeText(1, NecronomiconText.ABYSSALNOMICON_PAGE_1);
                    this.writeText(2, NecronomiconText.ABYSSALNOMICON_PAGE_2);
                }
            } else if (this.currTurnup == 1 && this.bookType < 4) {
                this.writeText(1, NecronomiconText.NECRONOMICON_PAGE_3);
                this.writeText(2, NecronomiconText.NECRONOMICON_PAGE_4);
            }
        } else if (this.isKnowledgeInfo) {
            if (this.currTurnup == 0) {
                this.writeText(1, NecronomiconText.KNOWLEDGE_INFO_1);
                this.writeText(2, NecronomiconText.KNOWLEDGE_INFO_2);
            } else if (this.currTurnup == 1) {
                this.writeText(1, NecronomiconText.KNOWLEDGE_INFO_3);
                this.writeText(2, NecronomiconText.TEST_95, 28, true);
            }
        }
    }

    protected void drawIndexText() {
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        String stuff = this.localize(NecronomiconText.LABEL_INDEX);
        int length = this.field_146289_q.func_78256_a(stuff);
        this.field_146289_q.func_78276_b(stuff, k + 50 - length, b0 + 16, 0);
    }

    public int getBookType() {
        return this.bookType;
    }

    public ResourceLocation getGuiTexture() {
        return bookGuiTextures;
    }

    public int getTurnupLimit() {
        return this.bookTotalTurnups;
    }

    public void setTurnupLimit(int i) {
        this.bookTotalTurnups = i;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        this.func_73729_b(k, b0, 0, 0, 255, 192);
        super.func_73863_a(par1, par2, par3);
        if (this.isInfo) {
            if (this.isNecroInfo || this.isKnowledgeInfo) {
                String stuff = this.localize(this.isNecroInfo ? NecronomiconText.LABEL_HUH : NecronomiconText.LABEL_KNOWLEDGE);
                this.field_146289_q.func_78279_b(stuff, k + 20, b0 + 16, 116, 0xC40000);
            }
            String s = I18n.func_135052_a((String)"necronomicon.turnupindicator", (Object[])new Object[]{this.currTurnup + 1, this.bookTotalTurnups});
            int l = this.field_146289_q.func_78256_a(s);
            if (this.getTurnupLimit() > 1) {
                this.field_146289_q.func_78276_b(s, k - l + 255 - 22, b0 + 16, 0);
            }
            this.drawInformationText(par1, par2);
        } else {
            this.drawIndexText();
        }
        this.field_146289_q.func_78264_a(unicode);
    }

    protected void writeText(int page, String text) {
        this.writeText(page, text, 28);
    }

    protected void writeText(int page, String text, boolean aklo) {
        this.writeText(page, text, 28, aklo);
    }

    protected void writeText(int page, String text, int height) {
        this.writeText(page, text, height, 0);
    }

    protected void writeText(int page, String text, int height, boolean aklo) {
        this.writeText(page, text, height, 0, aklo);
    }

    protected void writeText(int page, String text, int height, int width) {
        this.writeText(page, text, height, width, false);
    }

    protected void writeText(int page, String text, int height, int width, boolean aklo) {
        int k = (this.field_146294_l - 255) / 2;
        if (page > 2) {
            throw new IndexOutOfBoundsException("Number is greater than 2 (" + page + ")!");
        }
        if (page < 1) {
            throw new IndexOutOfBoundsException("Number is smaller than 1 (" + page + ")!");
        }
        if (text.length() > 368) {
            throw new IndexOutOfBoundsException("Text is longer than 368 characters (" + text.length() + ")!");
        }
        if (page == 1) {
            this.getFontRenderer(aklo).func_78279_b(this.localize(text), k + 20 + width, height, 107, 0);
        }
        if (page == 2) {
            this.getFontRenderer(aklo).func_78279_b(this.localize(text), k + 138 + width, height, 107, 0);
        }
    }

    public FontRenderer getFontRenderer(boolean aklo) {
        if (aklo) {
            return AbyssalCraftAPI.getAkloFont();
        }
        return this.field_146289_q;
    }

    protected String localize(String str) {
        return I18n.func_135052_a((String)str, (Object[])new Object[0]);
    }

    protected boolean isUnlocked(IUnlockCondition cnd) {
        if (cnd instanceof NecronomiconCondition) {
            return this.getBookType() >= (Integer)cnd.getConditionObject();
        }
        return this.cap.isUnlocked(cnd, (EntityPlayer)this.field_146297_k.field_71439_g);
    }

    private boolean list(Object obj) {
        return obj == null ? false : obj instanceof ItemStack[] || obj instanceof String || obj instanceof List || obj instanceof Ingredient || obj instanceof ItemStack && ((ItemStack)obj).func_77981_g() && ((ItemStack)obj).func_77960_j() == Short.MAX_VALUE;
    }

    private List<ItemStack> getList(Object obj) {
        ArrayList l;
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            l = Lists.newArrayList();
                            if (!(obj instanceof ItemStack[])) break block5;
                            for (ItemStack stack : (ItemStack[])obj) {
                                if (stack.func_190926_b()) continue;
                                l.add(stack.func_77946_l());
                            }
                            break block6;
                        }
                        if (!(obj instanceof String)) break block7;
                        for (ItemStack stack : OreDictionary.getOres((String)((String)obj))) {
                            if (stack.func_190926_b()) continue;
                            l.add(stack.func_77946_l());
                        }
                        break block6;
                    }
                    if (!(obj instanceof List)) break block8;
                    for (ItemStack stack : (List)obj) {
                        if (stack.func_190926_b()) continue;
                        l.add(stack.func_77946_l());
                    }
                    break block6;
                }
                if (!(obj instanceof Ingredient)) break block9;
                for (ItemStack stack : ((Ingredient)obj).func_193365_a()) {
                    if (stack.func_190926_b()) continue;
                    l.add(stack.func_77946_l());
                }
                break block6;
            }
            if (!(obj instanceof ItemStack)) break block6;
            NonNullList list = NonNullList.func_191196_a();
            ((ItemStack)obj).func_77973_b().func_150895_a(((ItemStack)obj).func_77973_b().func_77640_w(), list);
            for (ItemStack stack : list) {
                if (stack.func_190926_b()) continue;
                l.add(stack.func_77946_l());
            }
        }
        return l;
    }

    public void renderObject(int xPos, int yPos, Object obj, int mx, int my) {
        if (this.list(obj)) {
            List<ItemStack> list = this.getList(obj);
            if (!list.isEmpty()) {
                int index = (int)((this.drawTime - this.startTime) / 1000L) % list.size();
                this.renderItem(xPos, yPos, list.get(index), mx, my);
            } else if (obj instanceof ItemStack) {
                this.renderItem(xPos, yPos, APIUtils.convertToStack(obj), mx, my);
            }
        } else {
            this.renderItem(xPos, yPos, APIUtils.convertToStack(obj), mx, my);
        }
    }

    public void renderItem(int xPos, int yPos, ItemStack stack, int mx, int my) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            stack.func_77964_b(0);
        }
        RenderItem render = this.field_146297_k.func_175599_af();
        if (mx > xPos && mx < xPos + 16 && my > yPos && my < yPos + 16) {
            this.tooltipStack = stack;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        render.func_180450_b(stack, xPos, yPos);
        render.func_180453_a(this.field_146297_k.field_71466_p, stack, xPos, yPos, null);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
    }

    public void renderTooltip(int x, int y) {
        if (this.tooltipStack != null) {
            List tooltipData = this.tooltipStack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            ArrayList<String> parsedTooltip = new ArrayList<String>();
            boolean first = true;
            Iterator iterator = tooltipData.iterator();
            while (iterator.hasNext()) {
                String s;
                String s_ = s = (String)iterator.next();
                if (!first) {
                    s_ = TextFormatting.GRAY + s;
                }
                parsedTooltip.add(s_);
                first = false;
            }
            GuiRenderHelper.renderTooltip(x, y, parsedTooltip);
        }
    }

    private class RitualGuiInstance
    extends GuiInstance {
        protected RitualGuiInstance(int displayIcon, String title, String identifier) {
            super(displayIcon, title, identifier);
        }

        @Override
        public IUnlockCondition getCondition() {
            return new NecronomiconCondition(this.displayIcon);
        }

        @Override
        public GuiScreen getOpenGui(int bookType, GuiScreen parent) {
            return new GuiNecronomiconRitualEntry(bookType, (GuiNecronomicon)parent, this.displayIcon);
        }
    }
}

