/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.necronomicon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.necronomicon.CraftingStack;
import com.shinoow.abyssalcraft.api.necronomicon.INecroData;
import com.shinoow.abyssalcraft.api.necronomicon.condition.DefaultCondition;
import com.shinoow.abyssalcraft.api.necronomicon.condition.IUnlockCondition;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class NecroData
implements INecroData {
    private String identifier;
    private String title;
    private String information;
    private List<INecroData> containedData = Lists.newArrayList();
    private IUnlockCondition condition;
    private int displayIcon;

    public NecroData(String identifier, String title, int displayIcon, String info, IUnlockCondition condition, INecroData ... data) {
        this.identifier = identifier;
        this.title = title;
        this.displayIcon = displayIcon;
        this.information = info;
        this.condition = condition;
        for (INecroData t : data) {
            this.addData(t);
        }
    }

    public NecroData(String identifier, String title, int displayIcon, IUnlockCondition condition, INecroData ... data) {
        this(identifier, title, displayIcon, null, condition, data);
    }

    public NecroData(String identifier, String title, int displayIcon, String info, INecroData ... data) {
        this(identifier, title, displayIcon, info, new DefaultCondition(), data);
    }

    public NecroData(String identifier, String title, int displayIcon, INecroData ... data) {
        this(identifier, title, displayIcon, null, new DefaultCondition(), data);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public int getDisplayIcon() {
        return this.displayIcon;
    }

    @Override
    public String getText() {
        return this.information;
    }

    @Override
    public boolean hasText() {
        return !StringUtils.isEmpty((CharSequence)this.information);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public IUnlockCondition getCondition() {
        return this.condition;
    }

    public List<INecroData> getContainedData() {
        return ImmutableList.copyOf(this.containedData);
    }

    public void addData(INecroData data) {
        for (INecroData t : this.containedData) {
            if (!t.getIdentifier().equals(data.getIdentifier())) continue;
            t = data;
            return;
        }
        if (this.hasText() ? this.containedData.size() < 7 : this.containedData.size() < 14) {
            this.containedData.add(data);
        } else {
            FMLLog.log((String)"AbyssalCraftAPI", (Level)Level.ERROR, (String)"NecroData instance is already full, can't add more data!", (Object[])new Object[0]);
        }
    }

    public void removeData(String identifier) {
        for (INecroData data : this.containedData) {
            if (!data.getIdentifier().equals(identifier)) continue;
            this.containedData.remove(data);
            break;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NecroData)) {
            return false;
        }
        NecroData nd = (NecroData)obj;
        boolean b1 = nd.title.equals(this.title);
        boolean b2 = nd.identifier.equals(this.identifier);
        boolean b3 = !nd.hasText() && !this.hasText() || nd.information.equals(this.information);
        boolean b4 = true;
        for (INecroData o1 : nd.containedData) {
            for (INecroData o2 : this.containedData) {
                if (o1.equals(o2)) continue;
                b4 = false;
            }
        }
        return b1 && b2 && b3 && b4 && nd.condition.areConditionObjectsEqual(this.condition.getConditionObject());
    }

    public static class Page
    implements INecroData {
        private Object icon;
        private String title;
        private int pageNum;
        private String text;
        private IUnlockCondition condition;
        private int displayIcon;

        public Page(int pageNum, String title, int displayIcon, String text) {
            this(pageNum, title, displayIcon, null, text, new DefaultCondition());
        }

        public Page(int pageNum, String title, int displayIcon, String text, IUnlockCondition condition) {
            this(pageNum, title, displayIcon, null, text, condition);
        }

        public Page(int pageNum, String title, int displayIcon, Object icon, String text) {
            this(pageNum, title, displayIcon, icon, text, new DefaultCondition());
        }

        public Page(int pageNum, String title, int displayIcon, Object icon, String text, IUnlockCondition condition) {
            if (pageNum == 0) {
                throw new ArithmeticException("The Page number can't be zero");
            }
            this.pageNum = pageNum;
            this.title = title;
            this.displayIcon = displayIcon;
            if (!(icon == null || icon instanceof ResourceLocation || icon instanceof ItemStack || icon instanceof CraftingStack || icon instanceof String)) {
                throw new IllegalArgumentException("Icon isn't a ResourceLocation, ItemStack, CraftingStack or URL String!");
            }
            this.icon = this.verify(icon);
            this.text = text;
            this.condition = condition;
        }

        private Object verify(Object obj) {
            if (obj instanceof String) {
                AbyssalCraftAPI.getInternalNDHandler().verifyImageURL((String)obj);
            }
            if (!(obj instanceof ResourceLocation)) {
                return obj;
            }
            if (FMLCommonHandler.instance().getSide().isServer()) {
                return obj;
            }
            ResourceLocation res = (ResourceLocation)obj;
            if (res.toString().equals("abyssalcraft:textures/gui/necronomicon/missing.png")) {
                return obj;
            }
            try {
                TextureUtil.func_177053_a((InputStream)Minecraft.func_71410_x().func_110442_L().func_110536_a(res).func_110527_b());
            }
            catch (IOException e) {
                return new ResourceLocation("abyssalcraft", "textures/gui/necronomicon/missing.png");
            }
            return res;
        }

        public int getPageNumber() {
            return this.pageNum;
        }

        public Object getIcon() {
            return this.icon;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public int getDisplayIcon() {
            return this.displayIcon;
        }

        @Override
        public boolean hasText() {
            return true;
        }

        @Override
        public String getIdentifier() {
            return "";
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public IUnlockCondition getCondition() {
            return this.condition;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Page)) {
                return false;
            }
            Page page = (Page)obj;
            boolean b1 = page.title.equals(this.title);
            boolean b2 = page.pageNum == this.pageNum;
            boolean b3 = page.icon == null && this.icon == null || page.icon.equals(this.icon);
            boolean b4 = page.text.equals(this.text);
            boolean b5 = page.condition.areConditionObjectsEqual(this.condition.getConditionObject());
            return b1 && b2 && b3 && b4 && b5;
        }
    }

    public static class Chapter
    implements INecroData {
        private NavigableMap<Integer, Page> pages = Maps.newTreeMap((o1, o2) -> {
            if (o1 > o2) {
                return 1;
            }
            if (o1 < o2) {
                return -1;
            }
            return 0;
        });
        private String identifier;
        private String title;
        private IUnlockCondition condition;
        private int displayIcon;

        public Chapter(String identifier, String title, int displayIcon, IUnlockCondition condition) {
            this.identifier = identifier;
            this.title = title;
            this.displayIcon = displayIcon;
            this.condition = condition;
        }

        public Chapter(String identifier, String title, int displayIcon) {
            this(identifier, title, displayIcon, new DefaultCondition());
        }

        public Chapter(String identifier, String title, int displayIcon, IUnlockCondition condition, Page ... pages) {
            this(identifier, title, displayIcon, condition);
            for (Page page : pages) {
                this.addPage(page);
            }
        }

        public Chapter(String identifier, String title, int displayIcon, Page ... pages) {
            this(identifier, title, displayIcon, new DefaultCondition(), pages);
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public int getDisplayIcon() {
            return this.displayIcon;
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public boolean hasText() {
            return false;
        }

        @Override
        public IUnlockCondition getCondition() {
            return this.condition;
        }

        public Map<Integer, Page> getPages() {
            return Collections.unmodifiableMap(this.pages);
        }

        public int getPageAmount() {
            return this.pages.size();
        }

        public int getTurnupAmount() {
            return (Integer)this.pages.lastKey() / 2 + ((Integer)this.pages.lastKey() % 2 == 0 ? 0 : 1);
        }

        public void addPage(Page page) {
            this.pages.put(page.pageNum, page);
        }

        public void removePage(int pageNum) {
            this.pages.remove(pageNum);
        }

        public Page getPage(int pageNum) {
            return (Page)this.pages.get(pageNum);
        }

        public boolean hasPage(int pageNum) {
            return this.pages.containsKey(pageNum);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Chapter)) {
                return false;
            }
            Chapter c = (Chapter)obj;
            boolean b1 = c.title.equals(this.title);
            boolean b2 = c.identifier.equals(this.identifier);
            boolean b3 = true;
            for (Map.Entry e1 : c.pages.entrySet()) {
                for (Map.Entry e2 : this.pages.entrySet()) {
                    if (e1.getKey() == e2.getKey() && ((Page)e1.getValue()).equals(e2.getValue())) continue;
                    b3 = false;
                }
            }
            return b1 && b2 && b3 && c.condition.areConditionObjectsEqual(this.condition.getConditionObject());
        }
    }
}

