/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.blocks.ModBlocks;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.stats.StatList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class TownHallRecipe
extends ShapedRecipes {
    public static NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();

    public TownHallRecipe() {
        super("minecolonies", 3, 3, ingredients, new ItemStack((Block)ModBlocks.blockHutTownHall));
        this.setRegistryName("minecolonies:townhall.recipe");
    }

    public boolean func_77569_a(@NotNull InventoryCrafting inventoryCrafting, @NotNull World world) {
        try {
            Optional<Field> playerField = Arrays.stream(inventoryCrafting.field_70465_c.getClass().getDeclaredFields()).filter(string -> string.getName().equals("player") || string.getName().equals("field_192390_i")).findFirst();
            if (playerField.isPresent()) {
                playerField.get().setAccessible(true);
                EntityPlayer player = (EntityPlayer)playerField.get().get(inventoryCrafting.field_70465_c);
                if (player instanceof EntityPlayerMP) {
                    return ((EntityPlayerMP)player).func_147099_x().func_77444_a(Objects.requireNonNull(StatList.func_188057_b((Item)com.minecolonies.coremod.items.ModItems.supplyChest))) > 0 && this.hasSufficientResources(inventoryCrafting);
                }
                return this.hasSufficientResources(inventoryCrafting);
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    private boolean hasSufficientResources(InventoryCrafting inv) {
        int plankCount = 0;
        int hasBuildToolCount = 0;
        block0: for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i).func_77946_l();
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            if (stack.func_77973_b() == ModItems.buildTool) {
                ++hasBuildToolCount;
            }
            for (int oreId : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)oreId).contains("plankWood")) continue;
                ++plankCount;
                continue block0;
            }
        }
        return hasBuildToolCount == 2 && plankCount == 7;
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull InventoryCrafting inventoryCrafting) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int height, int width) {
        return height * width >= 9;
    }

    @NotNull
    public ItemStack func_77571_b() {
        return new ItemStack((Block)ModBlocks.blockHutTownHall);
    }

    static {
        ingredients.add(0, (Object)Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150344_f)));
        ingredients.add(1, (Object)Ingredient.func_193367_a((Item)ModItems.buildTool));
        ingredients.add(2, (Object)Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150344_f)));
        ingredients.add(3, (Object)Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150344_f)));
        ingredients.add(4, (Object)Ingredient.func_193367_a((Item)ModItems.buildTool));
        ingredients.add(5, (Object)Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150344_f)));
        ingredients.add(6, (Object)Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150344_f)));
        ingredients.add(7, (Object)Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150344_f)));
        ingredients.add(8, (Object)Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150344_f)));
    }
}

