/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.inventory.api.CombinedItemHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class SortingUtils {
    private SortingUtils() {
    }

    public static void sort(CombinedItemHandler inv) {
        AtomicInteger runCount = new AtomicInteger(0);
        HashMap<ItemStorage, Integer> map = new HashMap<ItemStorage, Integer>();
        if (inv != null) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (ItemStackUtils.isEmpty(inv.getStackInSlot(i)).booleanValue()) continue;
                ItemStorage storage = new ItemStorage(inv.extractItem(i, 64, false));
                int amount = storage.getAmount();
                if (map.containsKey(storage)) {
                    amount += ((Integer)map.remove(storage)).intValue();
                }
                map.put(storage, amount);
            }
            Tuple<AtomicInteger, Map<Integer, Integer>> tuple = SortingUtils.calcRequiredSlots(map);
            double totalSlots = inv.getSlots();
            int totalReq = ((AtomicInteger)tuple.func_76341_a()).get();
            map.entrySet().stream().sorted(SortingUtils::compare).forEach(entry -> SortingUtils.pushIntoInv(runCount, entry, inv, (AtomicInteger)tuple.func_76341_a(), totalSlots, totalReq, (Map)tuple.func_76340_b()));
        }
    }

    private static void pushIntoInv(AtomicInteger currentSlot, Map.Entry<ItemStorage, Integer> entry, CombinedItemHandler inv, AtomicInteger requiredSlots, double totalSlots, double totalRequirement, Map<Integer, Integer> creativeTabs) {
        ItemStack tempStack;
        int creativeTabId = entry.getKey().getCreativeTabIndex();
        int slotLimit = 0;
        ItemStack stack = entry.getKey().getItemStack();
        for (int tempSize = entry.getValue().intValue(); tempSize > 0; tempSize -= tempStack.func_190916_E()) {
            tempStack = stack.func_77946_l();
            tempStack.func_190920_e(Math.min(tempSize, tempStack.func_77976_d()));
            slotLimit = inv.getLastIndex(currentSlot.get());
            while (!inv.insertItem(currentSlot.getAndIncrement(), tempStack, false).func_190926_b()) {
                Log.getLogger().error("Trying to dump into same slot again!");
            }
            requiredSlots.decrementAndGet();
            creativeTabs.put(creativeTabId, creativeTabs.get(creativeTabId) - 1);
        }
        if (creativeTabs.get(creativeTabId) <= 0 && totalSlots - (double)slotLimit >= (double)requiredSlots.get()) {
            double dumpedSlots = totalRequirement - (double)requiredSlots.get();
            double usageFactor = totalSlots / dumpedSlots;
            double theoreticalJumpFactor = (totalSlots - (double)slotLimit) / (double)requiredSlots.get();
            if (theoreticalJumpFactor <= usageFactor || theoreticalJumpFactor > 4.0) {
                currentSlot.set(slotLimit);
            }
        }
    }

    private static int compare(Map.Entry<ItemStorage, Integer> t1, Map.Entry<ItemStorage, Integer> t2) {
        int id2;
        int creativeTabId2;
        int creativeTabId1 = t1.getKey().getCreativeTabIndex();
        if (creativeTabId1 != (creativeTabId2 = t2.getKey().getCreativeTabIndex())) {
            return creativeTabId1 - creativeTabId2;
        }
        int id1 = SortingUtils.getId(t1.getKey().getItem());
        if (id1 == (id2 = SortingUtils.getId(t2.getKey().getItem()))) {
            return t1.getKey().getDamageValue() - t2.getKey().getDamageValue();
        }
        return id1 - id2;
    }

    private static int getId(Item item) {
        return ((ForgeRegistry)ForgeRegistries.ITEMS).getID((IForgeRegistryEntry)item);
    }

    private static Tuple<AtomicInteger, Map<Integer, Integer>> calcRequiredSlots(Map<ItemStorage, Integer> map) {
        HashMap<Integer, Integer> creativeTabs = new HashMap<Integer, Integer>();
        int sum = 0;
        for (Map.Entry<ItemStorage, Integer> entry : map.entrySet()) {
            sum = (int)((double)sum + Math.ceil((double)entry.getValue().intValue() / (double)entry.getKey().getItemStack().func_77976_d()));
            creativeTabs.put(entry.getKey().getCreativeTabIndex(), creativeTabs.getOrDefault(entry.getKey().getCreativeTabIndex(), 0) + (int)Math.ceil((double)entry.getValue().intValue() / (double)entry.getKey().getItemStack().func_77976_d()));
        }
        return new Tuple((Object)new AtomicInteger(sum), creativeTabs);
    }
}

