/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class TeamColonyColorChangeMessage
extends AbstractMessage<TeamColonyColorChangeMessage, IMessage> {
    private int colonyId;
    private int colorOrdinal;
    private int dimension;

    public TeamColonyColorChangeMessage() {
    }

    public TeamColonyColorChangeMessage(int colorOrdinal, @NotNull AbstractBuildingView building) {
        this.colonyId = building.getColony().getID();
        this.colorOrdinal = colorOrdinal;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.colorOrdinal = buf.readInt();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.colorOrdinal);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(TeamColonyColorChangeMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            colony.setColonyColor(TextFormatting.values()[message.colorOrdinal]);
        }
    }
}

