/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingShepherd;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ShepherdSetDyeSheepsMessage
extends AbstractMessage<ShepherdSetDyeSheepsMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private boolean dyeSheeps;
    private int dimension;

    public ShepherdSetDyeSheepsMessage() {
    }

    public ShepherdSetDyeSheepsMessage(@NotNull BuildingShepherd.View building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.dyeSheeps = building.isDyeSheeps();
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.colonyId = byteBuf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(byteBuf);
        this.dyeSheeps = byteBuf.readBoolean();
        this.dimension = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(byteBuf, this.buildingId);
        byteBuf.writeBoolean(this.dyeSheeps);
        byteBuf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(ShepherdSetDyeSheepsMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            BuildingShepherd building = colony.getBuildingManager().getBuilding(message.buildingId, BuildingShepherd.class);
            if (building != null) {
                building.setDyeSheeps(message.dyeSheeps);
            }
        }
    }
}

