/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import com.minecolonies.coremod.colony.buildings.views.FilterableListView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class AssignFilterableItemMessage
extends AbstractMessage<AssignFilterableItemMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private boolean assign;
    private ItemStorage item;
    private int dimension;

    public AssignFilterableItemMessage() {
    }

    public AssignFilterableItemMessage(@NotNull FilterableListView building, ItemStorage item, boolean assign) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.assign = assign;
        this.item = item;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.assign = buf.readBoolean();
        this.item = new ItemStorage(ByteBufUtils.readItemStack((ByteBuf)buf));
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeBoolean(this.assign);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.item.getItemStack());
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(AssignFilterableItemMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            AbstractFilterableListBuilding building = colony.getBuildingManager().getBuilding(message.buildingId, AbstractFilterableListBuilding.class);
            if (building != null) {
                if (message.assign) {
                    building.addItem(message.item);
                } else {
                    building.removeItem(message.item);
                }
            }
        }
    }
}

