/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.inventory;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class ContainerMinecoloniesCitizenInventory
extends Container {
    private final IInventory chestInventory;
    private final IInventory playerInventory;
    private final int inventorySize;

    public ContainerMinecoloniesCitizenInventory(IInventory playerInventory, IInventory inventory, final int colonyId, final BlockPos buildingId, final int citizenId, final World world) {
        int i;
        this.chestInventory = inventory;
        this.inventorySize = inventory.func_70302_i_() / 9;
        int size = inventory.func_70302_i_();
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.func_75146_a(new Slot(inventory, index, 8 + k * 18, 18 + j * 18){

                    public void func_75215_d(ItemStack stack) {
                        if (buildingId != null && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !ItemStackUtils.isEmpty(stack).booleanValue()) {
                            Colony colony = ColonyManager.getColonyByWorld(colonyId, world);
                            AbstractBuilding building = colony.getBuildingManager().getBuilding(buildingId);
                            CitizenData citizenData = colony.getCitizenManager().getCitizen(citizenId);
                            building.overruleNextOpenRequestOfCitizenWithStack(citizenData, stack);
                        }
                        super.func_75215_d(stack);
                    }
                });
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(playerInventory, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(playerInventory, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
        this.playerInventory = playerInventory;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.func_75211_c().func_77946_l();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.func_75135_a(stackCopy, maxIndex, this.field_75151_b.size(), true) : !this.func_75135_a(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.func_75215_d(ItemStackUtils.EMPTY);
        } else {
            slot.func_75218_e();
        }
        return stackCopy;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.chestInventory.func_174886_c(playerIn);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.chestInventory.func_70300_a(playerIn);
    }

    public IInventory getLowerChestInventory() {
        return this.chestInventory;
    }

    public IInventory getPlayerInventory() {
        return this.playerInventory;
    }
}

