/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.huts.BlockHutField;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.blocks.huts.BlockHutWareHouse;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesChunkCapabilityProvider;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesWorldCapabilityProvider;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesWorldColonyManagerCapabilityProvider;
import com.minecolonies.coremod.network.messages.UpdateChunkCapabilityMessage;
import com.minecolonies.coremod.util.ChunkDataHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class EventHandler {
    private static final String ABANDON_COLONY_CONFIRM_COMMAND_SUGGESTED = "/mc colony ownerchange colony: %d player: [abandoned]";

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDebugOverlay(RenderGameOverlayEvent.Text event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71474_y.field_74330_P) {
                WorldClient world = mc.field_71441_e;
                EntityPlayerSP player = mc.field_71439_g;
                IColony colony = ColonyManager.getIColony((World)world, player.func_180425_c());
                if (colony == null) {
                    if (!ColonyManager.isTooCloseToColony((World)world, player.func_180425_c())) {
                        event.getLeft().add(LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.noCloseColony", new Object[0]));
                        return;
                    }
                    colony = ColonyManager.getClosestIColony((World)world, player.func_180425_c());
                    if (colony == null) {
                        return;
                    }
                    event.getLeft().add(LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.nextColony", (int)Math.sqrt(colony.getDistanceSquared(player.func_180425_c())), ColonyManager.getMinimumDistanceBetweenTownHalls()));
                    return;
                }
                event.getLeft().add(colony.getName() + " : " + LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.blocksFromCenter", (int)Math.sqrt(colony.getDistanceSquared(player.func_180425_c()))));
            }
        }
    }

    @SubscribeEvent
    public void onAttachingCapabilitiesChunk(@NotNull AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(new ResourceLocation("minecolonies", "closeColony"), (ICapabilityProvider)new MinecoloniesChunkCapabilityProvider());
    }

    @SubscribeEvent
    public void onAttachingCapabilitiesWorld(@NotNull AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("minecolonies", "chunkUpdate"), (ICapabilityProvider)new MinecoloniesWorldCapabilityProvider());
        event.addCapability(new ResourceLocation("minecolonies", "colonyManager"), (ICapabilityProvider)new MinecoloniesWorldColonyManagerCapabilityProvider());
    }

    @SubscribeEvent
    public void onChunkLoad(@NotNull ChunkEvent.Load event) {
        if (event.getWorld() instanceof WorldServer) {
            ChunkDataHelper.loadChunk(event.getChunk(), event.getWorld());
        }
    }

    @SubscribeEvent
    public void onEnteringChunk(@NotNull EntityEvent.EnteringChunk event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP) {
            Colony colony;
            World world = entity.func_130014_f_();
            Chunk newChunk = world.func_72964_e(event.getNewChunkX(), event.getNewChunkZ());
            ChunkDataHelper.loadChunk(newChunk, entity.field_70170_p);
            IColonyTagCapability newCloseColonies = (IColonyTagCapability)newChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
            MineColonies.getNetwork().sendToAll((IMessage)new UpdateChunkCapabilityMessage(newCloseColonies, newChunk.field_76635_g, newChunk.field_76647_h));
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Chunk oldChunk = world.func_72964_e(event.getOldChunkX(), event.getOldChunkZ());
            IColonyTagCapability oldCloseColonies = (IColonyTagCapability)oldChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
            for (int colonyId : newCloseColonies.getAllCloseColonies()) {
                colony = ColonyManager.getColonyByWorld(colonyId, (World)((EntityPlayerMP)entity).func_71121_q());
                if (colony == null) continue;
                colony.getPackageManager().addSubscribers(player);
            }
            for (int colonyId : oldCloseColonies.getAllCloseColonies()) {
                if (newCloseColonies.getAllCloseColonies().contains(colonyId) || (colony = ColonyManager.getColonyByWorld(colonyId, (World)((EntityPlayerMP)entity).func_71121_q())) == null) continue;
                colony.getPackageManager().removeSubscriber(player);
            }
            if (newCloseColonies.getOwningColony() != oldCloseColonies.getOwningColony()) {
                Colony colony2;
                if (newCloseColonies.getOwningColony() == 0) {
                    colony2 = ColonyManager.getColonyByWorld(oldCloseColonies.getOwningColony(), (World)((EntityPlayerMP)entity).func_71121_q());
                    if (colony2 != null) {
                        colony2.removeVisitingPlayer((EntityPlayer)player);
                    }
                    return;
                }
                colony2 = ColonyManager.getColonyByWorld(newCloseColonies.getOwningColony(), (World)((EntityPlayerMP)entity).func_71121_q());
                if (colony2 != null) {
                    colony2.addVisitingPlayer((EntityPlayer)player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEnteringChunkEntity(@NotNull EntityEvent.EnteringChunk event) {
        if (Configurations.gameplay.pvp_mode && event.getEntity() instanceof EntityCitizen) {
            Colony colony;
            World world;
            Chunk chunk;
            IColonyTagCapability chunkCapability;
            if (event.getEntity().field_70170_p != null && !event.getEntity().field_70170_p.func_175667_e(new BlockPos(event.getNewChunkX() * 16, 70, event.getNewChunkZ() * 16))) {
                return;
            }
            EntityCitizen entityCitizen = (EntityCitizen)event.getEntity();
            if (entityCitizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && entityCitizen.func_130014_f_().func_175667_e(entityCitizen.func_180425_c()) && (chunkCapability = (IColonyTagCapability)(chunk = (world = entityCitizen.func_130014_f_()).func_72964_e(event.getNewChunkX(), event.getNewChunkZ())).getCapability(MineColonies.CLOSE_COLONY_CAP, null)) != null && chunkCapability.getOwningColony() != 0 && entityCitizen.getCitizenColonyHandler().getColonyId() != chunkCapability.getOwningColony() && (colony = ColonyManager.getColonyByWorld(chunkCapability.getOwningColony(), entityCitizen.field_70170_p)) != null) {
                colony.addGuardToAttackers(entityCitizen, ((AbstractBuildingGuards)entityCitizen.getCitizenColonyHandler().getWorkBuilding()).getFollowPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && event.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ModItems.scanTool) {
            ItemStack itemstack = event.getPlayer().func_184586_b(EnumHand.MAIN_HAND);
            if (!itemstack.func_77942_o()) {
                itemstack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound compound = itemstack.func_77978_p();
            BlockPosUtil.writeToNBT(compound, "pos1", event.getPos());
            LanguageHandler.sendPlayerMessage(event.getPlayer(), "item.scepterSteel.point", event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
            itemstack.func_77982_d(compound);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        BlockPos bedBlockPos = event.getPos();
        if (event.getHand() == EnumHand.MAIN_HAND) {
            Colony colony;
            if (EventHandler.playerRightClickInteract(player, world, event.getPos()) && world.func_180495_p(event.getPos()).func_177230_c() instanceof AbstractBlockHut) {
                IColony colony2 = ColonyManager.getIColony(world, event.getPos());
                if (colony2 != null && !colony2.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                    event.setCanceled(true);
                }
                return;
            }
            if ("pmardle".equalsIgnoreCase(event.getEntityPlayer().func_70005_c_()) && Block.func_149634_a((Item)event.getItemStack().func_77973_b()) instanceof BlockSilverfish) {
                LanguageHandler.sendPlayerMessage(event.getEntityPlayer(), "Stop that you twat!!!", new Object[0]);
                event.setCanceled(true);
            }
            if (player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null) {
                return;
            }
            if (world.func_180495_p(event.getPos()).func_177230_c().isBed(world.func_180495_p(event.getPos()), (IBlockAccess)world, event.getPos(), (Entity)player) && (colony = ColonyManager.getColonyByPosFromWorld(world, bedBlockPos)) != null && world.func_180495_p(event.getPos()).func_177227_a().contains(BlockBed.field_176472_a)) {
                List<CitizenData> citizenList = colony.getCitizenManager().getCitizens();
                if (world.func_180495_p(event.getPos()).func_177230_c().isBedFoot((IBlockAccess)world, event.getPos())) {
                    bedBlockPos = bedBlockPos.func_177972_a((EnumFacing)world.func_180495_p(event.getPos()).func_177229_b((IProperty)BlockBed.field_185512_D));
                }
                for (CitizenData citizen : citizenList) {
                    if (!citizen.getBedPos().equals((Object)bedBlockPos) || !citizen.isAsleep()) continue;
                    event.setCanceled(true);
                    LanguageHandler.sendPlayerMessage(player, "tile.bed.occupied", new Object[0]);
                }
            }
            EventHandler.handleEventCancellation((PlayerInteractEvent)event, player);
        }
        if (event.getHand() == EnumHand.MAIN_HAND && event.getItemStack().func_77973_b() == ModItems.buildTool) {
            if (event.getWorld().field_72995_K) {
                if (event.getUseBlock() == Event.Result.DEFAULT && event.getFace() != null) {
                    MineColonies.proxy.openBuildToolWindow(event.getPos().func_177972_a(event.getFace()));
                } else {
                    MineColonies.proxy.openBuildToolWindow(null);
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickItem event) {
        if (event.getHand() == EnumHand.MAIN_HAND && event.getItemStack().func_77973_b() == ModItems.buildTool && event.getWorld().field_72995_K) {
            MineColonies.proxy.openBuildToolWindow(null);
            event.setCanceled(true);
        }
    }

    private static boolean playerRightClickInteract(@NotNull EntityPlayer player, World world, BlockPos pos) {
        return !player.func_70093_af() || player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null || player.func_184614_ca().func_77973_b().doesSneakBypassUse(player.func_184614_ca(), (IBlockAccess)world, pos, player);
    }

    private static void handleEventCancellation(@NotNull PlayerInteractEvent event, @NotNull EntityPlayer player) {
        Block heldBlock = Block.func_149634_a((Item)player.func_184614_ca().func_77973_b());
        if (heldBlock instanceof AbstractBlockHut || heldBlock instanceof BlockHutField) {
            event.setCanceled(!EventHandler.onBlockHutPlaced(event.getWorld(), player, heldBlock, event.getPos().func_177972_a(event.getFace())));
        }
    }

    public static boolean onBlockHutPlaced(@NotNull World world, @NotNull EntityPlayer player, Block block, BlockPos pos) {
        if (!Configurations.gameplay.allowOtherDimColonies && world.field_73011_w.getDimension() != 0) {
            LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.dimension.no", new Object[0]);
            return false;
        }
        if (block instanceof BlockHutTownHall) {
            return EventHandler.onTownHallPlaced(world, player, pos);
        }
        if (block instanceof BlockHutWareHouse) {
            return EventHandler.onWareHousePlaced(world, player, pos);
        }
        return EventHandler.onBlockHutPlaced(world, player, pos);
    }

    protected static boolean onTownHallPlaced(@NotNull World world, @NotNull EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColonyByOwner(world, player);
        if (colony != null) {
            return EventHandler.canOwnerPlaceTownHallHere(world, player, colony, pos);
        }
        if (Configurations.gameplay.restrictColonyPlacement) {
            double spawnDistance = Math.sqrt(BlockPosUtil.getDistanceSquared2D(pos, world.func_175694_M()));
            if (spawnDistance < (double)Configurations.gameplay.minDistanceFromWorldSpawn) {
                if (!world.field_72995_K) {
                    LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.tooClose", Configurations.gameplay.minDistanceFromWorldSpawn);
                }
                return false;
            }
            if (spawnDistance > (double)Configurations.gameplay.maxDistanceFromWorldSpawn) {
                if (!world.field_72995_K) {
                    LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.tooFar", Configurations.gameplay.maxDistanceFromWorldSpawn);
                }
                return false;
            }
        }
        if ((colony = ColonyManager.getClosestIColony(world, pos)) == null) {
            return true;
        }
        return EventHandler.canPlayerPlaceTownHallHere(world, player, pos, colony);
    }

    private static boolean onWareHousePlaced(World world, EntityPlayer player, BlockPos pos) {
        if (EventHandler.onBlockHutPlaced(world, player, pos)) {
            IColony colony = ColonyManager.getClosestIColony(world, pos);
            if (!(colony == null || Configurations.gameplay.limitToOneWareHousePerColony && colony.hasWarehouse())) {
                return true;
            }
            LanguageHandler.sendPlayerMessage(player, "tile.blockHut.warehouse.limit", new Object[0]);
        }
        return false;
    }

    private static boolean onBlockHutPlaced(World world, @NotNull EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColony(world, pos);
        if (colony == null) {
            if (ColonyManager.getIColonyByOwner(world, player) == null) {
                LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoTownHall", new Object[0]);
            } else {
                LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageTooFarFromTownHall", new Object[0]);
            }
            return false;
        }
        if (!colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoPermission", colony.getName());
            return false;
        }
        return true;
    }

    private static boolean canOwnerPlaceTownHallHere(World world, @NotNull EntityPlayer player, @NotNull IColony colony, BlockPos pos) {
        IColony currentColony = ColonyManager.getIColony(world, pos);
        if (currentColony != null && currentColony != colony) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.permission.no", new Object[0]));
            }
            return false;
        }
        if (!colony.isCoordInColony(world, pos)) {
            if (!world.field_72995_K) {
                ITextComponent deleteButton = new TextComponentTranslation("tile.blockHutTownHall.deleteMessageLink", new Object[0]).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/mc colony delete colony: %d canDestroy: %s confirmDelete: true", colony.getID(), true))));
                if (Configurations.gameplay.allowInfiniteColonies) {
                    ITextComponent abandonButton = new TextComponentTranslation("tile.blockHutTownHall.abandonMessageLink", new Object[0]).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(ABANDON_COLONY_CONFIRM_COMMAND_SUGGESTED, colony.getID()))));
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("tile.blockHutTownHall.messagePlacedAlreadyInfi", new Object[0]));
                    player.func_145747_a(abandonButton);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("tile.blockHutTownHall.messagePlacedAlreadyDel", new Object[0]));
                }
                player.func_145747_a(deleteButton);
            }
            return false;
        }
        if (colony.hasTownHall()) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("tile.blockHutTownHall.messagePlacedAlready", new Object[0]));
            }
            return false;
        }
        return true;
    }

    private static boolean canPlayerPlaceTownHallHere(@NotNull World world, @NotNull EntityPlayer player, BlockPos pos, @NotNull IColony closestColony) {
        if (closestColony.isCoordInColony(world, pos)) {
            if (closestColony.hasTownHall() || !closestColony.getPermissions().isColonyMember(player)) {
                if (!world.field_72995_K) {
                    Log.getLogger().info("Can't place at: " + pos.func_177958_n() + "." + pos.func_177956_o() + "." + pos.func_177952_p() + ". Because of townhall of: " + closestColony.getName() + " at " + closestColony.getCenter().func_177958_n() + "." + closestColony.getCenter().func_177956_o() + "." + closestColony.getCenter().func_177952_p());
                    LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
                }
                return false;
            }
            if (!closestColony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
                if (!world.field_72995_K) {
                    LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoPermissionPlace", closestColony.getName());
                }
                return false;
            }
            return true;
        }
        if (ColonyManager.isTooCloseToColony(world, pos)) {
            Log.getLogger().info("Can't place at: " + pos.func_177958_n() + "." + pos.func_177956_o() + "." + pos.func_177952_p() + ". Because of townhall of: " + closestColony.getName() + " at " + closestColony.getCenter().func_177958_n() + "." + closestColony.getCenter().func_177956_o() + "." + closestColony.getCenter().func_177952_p());
            LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
            return false;
        }
        if (Configurations.gameplay.protectVillages && world.func_175714_ae().func_176056_a(pos, Configurations.gameplay.workingRangeTownHallChunks * 16) != null) {
            Log.getLogger().warn("Village close by!");
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void onWorldLoad(@NotNull WorldEvent.Load event) {
        ColonyManager.onWorldLoad(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldUnload(@NotNull WorldEvent.Unload event) {
        ColonyManager.onWorldUnload(event.getWorld());
    }
}

